package com.biz.eisp.mdm.timeTask.service;

import java.util.Set;

import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import com.biz.eisp.mdm.timeTask.entity.TimeTaskEntity;

/**
 * 调度容器类.<p>
 * 读取数据库 然后判断是否启动任务。
 * @author grover
 * @version v1.0
 */
public class DataBaseSchedulerFactoryBean extends SchedulerFactoryBean {

    @Autowired
    private TimeTaskService timeTaskService;

    /**
     * spring容器加载完之后执行读取数据库判断是否开始定时任务.
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Set<TriggerKey> trigerrNames = this.getScheduler().getTriggerKeys(GroupMatcher.triggerGroupEquals(Scheduler.DEFAULT_GROUP));
        TimeTaskEntity task;

        for (TriggerKey triggerKey : trigerrNames) {
            task = timeTaskService.findUniqueByProperty(TimeTaskEntity.class, "taskId", triggerKey.getName());
            // 数据库查询不到的定时任务或者定时任务的运行状态不为1(运行)时，都停止
            // TASK #327 定时器任务默认未启动
            if (task == null || !"1".equals(task.getIsStart())) {
                this.getScheduler().pauseTrigger(triggerKey);
            }
        }
    }

}
