package com.biz.eisp.mdm.timeTask.service.impl;

import java.util.List;

import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.utils.Key;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.timeTask.dao.TimeTaskDao;
import com.biz.eisp.mdm.timeTask.entity.TimeTaskEntity;
import com.biz.eisp.mdm.timeTask.service.TimeTaskService;

/**
 * 任务demo实现接口.
 * @author grover
 * @version v1.0
 */
@Service("timeTaskService")
public class TimeTaskServiceImpl extends BaseServiceImpl implements TimeTaskService {

	@Autowired
	private TimeTaskDao timeTaskDao;
	
	@Override
	public void demoWork() {
//		executeSql("select count(1) from tm_user");
	}

	@Override
	public AjaxJson saveTask(TimeTaskEntity timeTask) {
		AjaxJson j = new AjaxJson();
		CronTrigger trigger = new CronTriggerImpl();
		String message = "";
		try {
			CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule(timeTask.getCronExpression());  
			trigger = TriggerBuilder.newTrigger().withIdentity(timeTask.getTaskId(), Key.DEFAULT_GROUP)  
                    .withSchedule(scheduleBuilder).build();  
		} catch (Exception e) {
			j.setMsg("Cron表达式错误");
			return j;
		}
		if (StringUtil.isNotEmpty(timeTask.getId())) {
			message = "定时任务管理更新成功";
			TimeTaskEntity t = this.get(TimeTaskEntity.class, timeTask.getId());
			try {
				if (!timeTask.getCronExpression().equals(t.getCronExpression())) {
					timeTask.setIsEffect("0");
				}
				MyBeanUtils.copyBeanNotNull2Bean(timeTask, t);
				this.saveOrUpdate(t);
			} catch (Exception e) {
				e.printStackTrace();
				message = "定时任务管理更新失败";
			}
		} else {
			message = "定时任务管理添加成功";
			timeTask.setIsEffect("0");
			timeTask.setIsStart("0");
			this.save(timeTask);
		}
		j.setMsg(message);
		return j;
	}

	@Override
	public List<TimeTaskEntity> findTimeTaskList(TimeTaskEntity timeTaskEntity,
			Page page) {
		return timeTaskDao.findTimeTaskList(timeTaskEntity, page);
	}
}
