package com.biz.eisp.mdm.timeTask.util;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.Set;

/**
 * 任务工具类.
 * @author grover
 * @version v1.0
 */
public class QuartzManagerUtil {
	
	 private static Logger logger = LoggerFactory.getLogger(QuartzManagerUtil.class);
	 
    /**
     * 根据触发器名称修改cron表达式.
     * @author grover
     * @param triggerName 触发器名称
     * @param cronExpression 表达式
     */
    public static void changeCronExpByName(String triggerName, String cronExpression) {
        try {
        	StdScheduler schedulerFactory = (StdScheduler) ApplicationContextUtils.getContext().getBean("schedulerFactory");
        	 
            //获取触发器集合
            Set<TriggerKey> triggerKeys = schedulerFactory.getTriggerKeys(GroupMatcher
                    .triggerGroupEquals(Key.DEFAULT_GROUP));
            for (TriggerKey triggerKey : triggerKeys) {
                if (triggerKey.getName().equals(triggerName)) {
                    CronTrigger trigger = (CronTrigger) schedulerFactory.getTrigger(triggerKey);
                    CronExpression.validateExpression(cronExpression);
                    CronTrigger reTrigger = TriggerBuilder.newTrigger().forJob(trigger.getJobKey())
                   			//绑定同一个触发器
                            .withIdentity(triggerName, Key.DEFAULT_GROUP)
                            //绑定非原来的cron表达式
                            .withSchedule(CronScheduleBuilder.cronSchedule(cronExpression)).build();
                    //重新计划
                    schedulerFactory.rescheduleJob(triggerKey, reTrigger);
                    break;
                }
            }
        } catch (SchedulerException exp) {
        	logger.error("Fail to reschedule. " + exp);
            exp.printStackTrace();
        } catch (ParseException exp) {
        	logger.error("The new cronExpression - " + cronExpression + " not conform to the standard. " + exp);
            exp.printStackTrace();
        }
    }
}