package com.biz.eisp.mdm.user.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.user.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/** 用户控制器.
 * <p>用户相关功能的方法
 * @author grover
 * @version v1.0
 */
@Controller
@RequestMapping("/tmUserController")
public class TmUserController extends BaseController{
	/**
	 * 注入用户Service
	 */
	@Autowired
	private TmUserService tmUserService;
	/**
	 * 注入用户扩展service
	 */
	@Autowired(required=false)
	private TmUserBackExtendService tmUserBackExtendService;
	/**
	 * 注入用户表单扩展接口
	 */
	@Autowired(required=false)
	private TmUserFormExtendService tmUserFormExtendService;

	/**
	 * 注入用户表单扩展接口
	 */
	@Autowired(required=false)
	private TmUserMainExtendService tmUserMainExtendService;

	@Autowired
	private SysConfigUtils sysConfigUtils;

	/**
	 * <p>跳转到用户管理主页面<br>
	 * @return 用户管理页面路径
	 */
	@RequestMapping(value = "goTmUserMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmUserMain(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_USER);

		if(tmUserMainExtendService != null) {
			request.setAttribute("includeJsp", tmUserMainExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserMain");
	}
	
	/**
	 * <p>跳转到用户表单页面<br>
	 * 新增，查询，修改 都共同使用此表单页面
	 * @return 用户表单页面路径
	 */
	@RequestMapping(value = "goTmUserForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmUserForm(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		if(StringUtil.isNotEmpty(tmUserVo.getId())){
			List <TmUserVo> tmUserVoList = tmUserService.findTmUserList(tmUserVo, null);
			if(tmUserVoList!=null&&tmUserVoList.size()>0){
				TmUserVo vo = tmUserVoList.get(0);
				if(StringUtil.isNotEmpty(vo)){
					vo.setPassword(Globals.NO_PASSWORD);
				}
				request.setAttribute("vo", vo);
			}
		}
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		request.setAttribute("extendTableName",Globals.TABLE_USER);
		if(tmUserFormExtendService != null) {
			request.setAttribute("includeJsp", tmUserFormExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserForm");
	}
	
	@RequestMapping(value = "findTmUserList", method = {RequestMethod.GET, RequestMethod.POST})
	public void findTmUserList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		tmUserVo.setUserType(Globals.ENTERPRISE_USER);
		List <TmUserVo> tmUserVoList = tmUserService.findTmUserListNew(tmUserVo, page);
		this.datagridReturn(response, tmUserVoList, page);
	}
	/**
	 * 业务标签查询用户.
	 * @author grover
	 * @param tmUserVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "findTmUserBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	public void findTmUserBySearchList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		tmUserVo.setUserType(Globals.ENTERPRISE_USER);
		if(StringUtil.isNotEmpty(tmUserVo.getSearchParam())){
			tmUserVo.setFullName(tmUserVo.getSearchParam());
		}
		List <TmUserVo> tmUserVoList;
		try {
			tmUserVoList = tmUserService.findTmUserList(tmUserVo, page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取用户信息失败,"+e.getMessage());
		}
		this.datagridReturn(response, tmUserVoList, page);
	}
	/**
	 * 业务标签查询用户.
	 * @author grover
	 * @param tmUserVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "getTmUserBySearch",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson getTmUserBySearch(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		AjaxJson json = new AjaxJson();
		Map<String, Object> attributes = new HashMap<String, Object>();
		Page page = new EuPage(request);
		tmUserVo.setUserType(Globals.ENTERPRISE_USER);
		if(StringUtil.isNotEmpty(tmUserVo.getSearchParam())){
			tmUserVo.setFullName(tmUserVo.getSearchParam());
		}
		try {
			List <TmUserVo> tmUserVoList = tmUserService.findTmUserList(tmUserVo, page);
			json.setObj(tmUserVoList);
			attributes.put("totle", tmUserVoList.size());
		} catch (Exception e) {
			attributes.put("totle", 0);
			e.printStackTrace();
			throw new BusinessException("获取用户失败"+e.getMessage());
		}
		json.setAttributes(attributes);
		return json;
	}
	/**
	 * 跳转业务标签查询用户界面.
	 * @author grover
	 * @param tmUserVo vo对象
	 * @return
	 */
	@RequestMapping(value = "goTmUserSearch",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmUserSearch(TmUserVo tmUserVo,String singleSelect,String searchUrl) {
		ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserSearchMain");
		view.addObject("extendTableName",Globals.TABLE_USER);
		view.addObject("vo", tmUserVo);
		if(StringUtil.isEmpty(searchUrl)){
			searchUrl="tmUserController.do?findTmUserBySearchList";
		}
		view.addObject("searchUrl", searchUrl);
		view.addObject("singleSelect", singleSelect);
		return view;
	}
	/**
	 * 保存用户.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @param request 请求对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveTmUser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		Page page = new EuPage(request);
		try {
			tmUserVo.setUserType(Globals.ENTERPRISE_USER);
			String id = tmUserService.saveTmUser(tmUserVo, page);
			if (null != tmUserBackExtendService){
				tmUserBackExtendService.afterSaveTmUser(id);
			}
		} catch (Exception e) {
			e.printStackTrace();
			j.setSuccess(false);
			j.setMsg("操作失败");
		}
		
		return j;
	}
	
	/**
	 * 删除用户信息
	 * <p>
	 * @param tmUserVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "deleteTmUser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmUser(String ids, 
			HttpServletRequest request, HttpServletResponse response) {
		AjaxJson ajaxJson=new AjaxJson();
		try {
			ajaxJson = tmUserService.deleteTmUser(ids, page);
			if (null != tmUserBackExtendService){
				Map<String, Object> attributes = ajaxJson.getAttributes();
				Object userNameList = attributes.get("userNameList");
				if (null != userNameList){
					tmUserBackExtendService.afterDeleteTmUser((List<String>) userNameList);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setMsg("删除失败");
		}
		return ajaxJson;
	}
	/**
	 * 验证重复.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @param request 请求对象
	 * @return 验证信息
	 */
	@RequestMapping(value = "valideTmUser",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm valideTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
		ValidForm validForm = new ValidForm();
		String param = OConvertUtils.getString(request.getParameter("param"));
		try {
			validForm = tmUserService.valideTmUser(tmUserVo, param);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("验证用户异常");
		}
		return validForm;
	}
	/**
	 * 启用停用.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @return 成功或者失败模型
	 */
	@RequestMapping(value = "startOrStopTmuser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
		AjaxJson json = new AjaxJson();
		try {
			json = tmUserService.startOrStopTmuser(tmUserVo);
			if (null != tmUserBackExtendService){
				tmUserBackExtendService.afterStartOrStopTmuser(tmUserVo);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("操作失败，请稍后再试");
		}
		return json;
	}
	/**
	 * 跳转修改密码.
	 * @param request 请求对象
	 * @return 修改密码页面
	 */
	@RequestMapping(value = "goChangeTmUserPassword", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goChangeTmUserPassword(HttpServletRequest request) {
//		String passwordDataType = ResourceUtil.getSysConfigProperty("passwordDataType");
//		String passwordErrorMsg = ResourceUtil.getSysConfigProperty("passwordErrorMsg");
		String passwordDataType = sysConfigUtils.getPasswordDataType();
		String passwordErrorMsg = sysConfigUtils.getPasswordErrorMsg();
		if(StringUtil.isBlank(passwordDataType)) {
			passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
		}
		if(StringUtil.isBlank(passwordErrorMsg)) {
			passwordErrorMsg = "只能填写长度为6~20，字符类型（英文、数字、标点符号、特殊字符）";
		}
		request.setAttribute("passwordDataType", passwordDataType);
		request.setAttribute("passwordErrorMsg", passwordErrorMsg);
		return new ModelAndView("com/biz/eisp/mdm/tmUser/changeTmPassword");
	}
	/**
	 * 跳转修改密码.
	 * @param request 请求对象
	 * @return 修改密码页面
	 */
	@RequestMapping(value = "goFirstChangeTmUserPassword", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goFirstChangeTmUserPassword(TmUserVo tmUserVo) {
//		String passwordDataType = ResourceUtil.getSysConfigProperty("passwordDataType");
//		String passwordErrorMsg = ResourceUtil.getSysConfigProperty("passwordErrorMsg");
		String passwordDataType = sysConfigUtils.getPasswordDataType();
		String passwordErrorMsg = sysConfigUtils.getPasswordErrorMsg();
		if(StringUtil.isBlank(passwordDataType)) {
			passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
		}
		if(StringUtil.isBlank(passwordErrorMsg)) {
			passwordErrorMsg = "只能填写长度为6~20，字符类型（英文、数字、标点符号、特殊字符）";
		}
		ModelAndView view = new ModelAndView("login/loginFirstChangeTmPassword");
		view.addObject("tmUserVo", tmUserVo);
		view.addObject("passwordDataType", passwordDataType);
		view.addObject("passwordErrorMsg", passwordErrorMsg);
		return view;
	}
	 /**
     * 修改密码.
     * @param request 请求对象
     * @param tmUserVo 用户vo对象
     * @return 成功或者失败
     */
    @RequestMapping(value = "changeTmPassword", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson changeTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
    	AjaxJson j = new AjaxJson();
    	try {
			j = tmUserService.changeTmuserPassword(tmUserVo);
			if (null != tmUserBackExtendService){
				tmUserBackExtendService.afterChangeTmPassword(tmUserVo);
			}
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("修改密码失败，请稍后再试");
			e.printStackTrace();
		}
    	return j;
    }
    /**
     * 第一次登录修改密码.
     * @param request 请求对象
     * @param tmUserVo 用户vo对象
     * @return 成功或者失败
     */
    @RequestMapping(value = "changeFirstTmPassword", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson changeFirstTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
    	AjaxJson j = new AjaxJson();
    	try {
    		j = tmUserService.changeFirstTmPassword(tmUserVo);
			if (null != tmUserBackExtendService){
				tmUserBackExtendService.afterChangeFirstTmPassword(tmUserVo);
			}
    	} catch (Exception e) {
    		j.setSuccess(false);
    		j.setMsg("修改密码失败，请稍后再试");
    		e.printStackTrace();
    	}
    	return j;
    }
    /**
	 * 导出excel
	 * @param customerVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls( TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		tmUserVo.setUserType(Globals.ENTERPRISE_USER);
		List <TmUserVo> tmUserVoList = tmUserService.findTmUserList(tmUserVo, null);
		doExportXls(response, request, tmUserVoList, TmUserVo.class, "企业用户列表");
	}
}
