package com.biz.eisp.mdm.user.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.user.vo.QueryTmuserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;

/** 企业用户dao.
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmUserDao {

	@Arguments({"tmUserVo","page","sql"})
	@ResultType(TmUserVo.class)
	public List <TmUserVo> findTmUserList(TmUserVo tmUserVo, Page page,String sql);
	/**
	 * 获取用户信息.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @return 用户信息
	 */
	@Arguments({"tmUserVo"})
	@ResultType(TmUserVo.class)
	TmUserVo getTmUser(TmUserVo tmUserVo);
	/**
	 * 企业用户相关接口.
	 * @author grover
	 * @param queryTmuserVo 用户vo对象
	 * @return 用户信息
	 */
	@Arguments({"queryTmuserVo","page"})
	@ResultType(TmUserVo.class)
	List<TmUserVo> findTmUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page);
	/**
	 * 经销商用户相关接口.
	 * @author grover
	 * @param queryTmuserVo 用户vo对象
	 * @return 用户信息
	 */
	@Arguments({"queryTmuserVo","page"})
	@ResultType(TmUserVo.class)
	List<TmUserVo> findTmCustUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page);
	
	/**
	 * 获取用户信息.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @return 用户信息
	 */
	@Arguments({"tmUserVo"})
	@ResultType(TmUserVo.class)
	List<TmUserVo> getTmUserList(TmUserVo tmUserVo);
	
	/**
	 * 获取用户职位信息
	 */
    @Arguments({ "posId", "nowDate" })
    @ResultType(UserInfoEntity.class)
    public UserInfoEntity findUserInfoEntityByPosId(String posId, String nowDate);
}
