package com.biz.eisp.mdm.user.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * 用户信息实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_user")
public class TmUserEntity extends IdEntity implements java.io.Serializable,Loggerable{
	
	private static final long serialVersionUID = 1L;
	/**
	 * 用户名
	 */
	private String userName;
	/**
	 * 真实姓名
	 */
	private String fullName;
	/**
	 * 性别
	 */
	private Integer sex;
	/**
	 * 手机
	 */
	private String mobilePhone;
	/**
	 * 邮箱
	 */
	private String email;
	/**
	 * 用户密码
	 */
	private String password;
	/**
	 * 启用状态：0-启用，1-不启用
	 */
	private Short enableStatus;
	/**
	 * 姓名拼音简写
	 */
	private String headString;
	/**
	 * 是否第一次登录 0-否 1或者null-是
	 */
	private Integer hasFirstTime;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人ID
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人
	 */
	private java.lang.String updateName;
	/**
	 * 用户类型 数据字典user_type 0企业用户 1经销商用户
	 */
	private java.lang.Integer userType;
	/**
	 * 用户生效开始时间（yyyy-mm-dd）
	 */
	private java.util.Date beginDate;
	/**
	 * 用户生效开始时间（yyyy-mm-dd）
	 */
	private java.util.Date endDate;
	/**
	 * 登陆失败次数，默认为0 最大为3
	 */
	private Short loginErrTimes;
	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 字符类型（length=500）-扩展字段6
	 */
	private String extChar6;
	/**
	 * 字符类型（length=500）-扩展字段7
	 */
	private String extChar7;
	/**
	 * 字符类型（length=500）-扩展字段8
	 */
	private String extChar8;
	/**
	 * 字符类型（length=500）-扩展字段9
	 */
	private String extChar9;
	/**
	 * 字符类型（length=500）-扩展字段10
	 */
	private String extChar10;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/**
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	/**
	 * 日期类型-扩展字段1
	 */
	private Date extDate1;
	/**
	 * 日期类型-扩展字段2
	 */
	private Date extDate2;
	/**
	 * 用户与职位关系列表
	 */
	private List <TmUserPositionEntity> tmUserPositionList = new ArrayList<TmUserPositionEntity>();
	/**
	 * 经销商用户与角色关系列表
	 */
	private List <TmUserRoleEntity> tmUserRoleList = new ArrayList<TmUserRoleEntity>();
	/**
	 * 经销商用户与客户关系列表
	 */
	private List <TmRUserCustomerEntity> TmRUserCustomerList  = new ArrayList<TmRUserCustomerEntity>();
	
	
	
	/**
	 *方法: 取得 java.lang.Short
	 *@return: java.lang.Short 登陆失败次数
	 */
	@Column(name = "login_err_times")
	public Short getLoginErrTimes() {
		return loginErrTimes;
	}
	/**
	 *方法: 设置 java.lang.Short
	 *@param: java.lang.Short 登陆失败次数
	 */
	public void setLoginErrTimes(Short loginErrTimes) {
		this.loginErrTimes = loginErrTimes;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 电话
	 */
	@Column(name = "mobilePhone")
	public String getMobilePhone() {
		return this.mobilePhone;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 电话
	 */
	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 邮箱
	 */
	@Column(name = "email")
	public String getEmail() {
		return this.email;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 密码
	 */
	@Column(name = "password")
	public String getPassword() {
		return this.password;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 密码
	 */
	public void setPassword(String password) {
		this.password = password;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 登录名
	 */
	@Column(name = "username", nullable = false)
	public String getUserName() {
		return this.userName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 登录名
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 正式名
	 */
	@Column(name = "fullname")
	public String getFullName() {
		return this.fullName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 正式名
	 */
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 邮箱
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 java.lang.Integer
	 *@return: java.lang.Integer 性别
	 */
	@Column(name = "sex")
	public Integer getSex() {
		return sex;
	}
	/**
	 *方法: 设置 java.lang.Integer
	 *@param: java.lang.Integer 性别
	 */
	public void setSex(Integer sex) {
		this.sex = sex;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 名称拼音简写
	 */
	@Column(name = "headstring")
	public String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 名称拼音简写
	 */
	public void setHeadString(String headString) {
		this.headString = headString;
	}
	/**
	 *方法: 取得 java.lang.Short
	 *@return: java.lang.Short 状态
	 */
	@Column(name = "enable_status")
	public Short getEnableStatus() {
		return this.enableStatus;
	}
	/**
	 *方法: 设置 java.lang.Short
	 *@param: java.lang.Short 状态
	 */
	public void setEnableStatus(Short enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 用户生效开始时间
	 */
	@Column(name="begin_date")
	public java.util.Date getBeginDate() {
		return beginDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 用户生效开始时间
	 */
	public void setBeginDate(java.util.Date beginDate) {
		this.beginDate = beginDate;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 用户生效结束时间
	 */
	@Column(name="end_date")
	public Date getEndDate() {
		return endDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 用户生效结束时间
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 是否第一次登录 0-否 1或者null-是
	 */
	@Column(name = "has_first_time")
	public java.lang.Integer getHasFirstTime() {
		return hasFirstTime;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 是否第一次登录 0-否 1或者null-是
	 */
	public void setHasFirstTime(java.lang.Integer hasFitstTime) {
		this.hasFirstTime = hasFitstTime;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 用户类型
	 */
	@Column(name = "user_type")
	public java.lang.Integer getUserType() {
		return userType;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 用户类型
	 */
	public void setUserType(java.lang.Integer userType) {
		this.userType = userType;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1(){
		return extChar1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段2
	 */
	@Column(name = "ext_char_2")
	public String getExtChar2(){
		return extChar2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3(){
		return extChar3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4(){
		return extChar4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5(){
		return extChar5;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1(){
		return extNumber1;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2(){
		return extNumber2;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3(){
		return extNumber3;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段1
	 */
	@Column(name = "ext_date_1")
	public Date getExtDate1() {
		return extDate1;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段1
	 */
	public void setExtDate1(Date extDate1) {
		this.extDate1 = extDate1;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段2
	 */
	@Column(name = "ext_date_2")
	public Date getExtDate2() {
		return extDate2;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段2
	 */
	public void setExtDate2(Date extDate2) {
		this.extDate2 = extDate2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}
	@Column(name = "ext_char_6")
	public String getExtChar6() {
		return extChar6;
	}
	public void setExtChar6(String extChar6) {
		this.extChar6 = extChar6;
	}
	@Column(name = "ext_char_7")
	public String getExtChar7() {
		return extChar7;
	}
	public void setExtChar7(String extChar7) {
		this.extChar7 = extChar7;
	}
	@Column(name = "ext_char_8")
	public String getExtChar8() {
		return extChar8;
	}
	public void setExtChar8(String extChar8) {
		this.extChar8 = extChar8;
	}
	@Column(name = "ext_char_9")
	public String getExtChar9() {
		return extChar9;
	}
	public void setExtChar9(String extChar9) {
		this.extChar9 = extChar9;
	}
	@Column(name = "ext_char_10")
	public String getExtChar10() {
		return extChar10;
	}
	public void setExtChar10(String extChar10) {
		this.extChar10 = extChar10;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.user.entity.TmUserRoleEntity> 
	 * 
	 * @return java.util.List<com.biz.eisp.mdm.user.entity.TmUserRoleEntity> 经销商用户与角色关系
	 */
	@OneToMany(cascade = CascadeType.ALL,fetch=FetchType.LAZY)
	@JoinColumn(name="user_id")
	@JsonIgnore
	public List<TmUserRoleEntity> getTmUserRoleList() {
		return tmUserRoleList;
	}

	/**
	 * 方法：设置java.util.List<com.biz.eisp.mdm.user.entity.TmUserRoleEntity> 
	 * 
	 * setter java.util.List<com.biz.eisp.mdm.user.entity.TmUserRoleEntity> 经销商用户与角色关系
	 */
	public void setTmUserRoleList(List<TmUserRoleEntity> tmUserRoleList) {
		this.tmUserRoleList = tmUserRoleList;
	}
	
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity>
	 * @return java.util.List<com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity> 经销商用户与客户关系
	 */
	@OneToMany(cascade = CascadeType.ALL,fetch=FetchType.LAZY)
	@JoinColumn(name="user_id")
	@JsonIgnore
	public List<TmRUserCustomerEntity> getTmRUserCustomerList() {
		return TmRUserCustomerList;
	}

	/**
	 * 方法：设置java.util.List<com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity>
	 * 
	 *@param java.util.List<com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity> 经销商用户与客户关系
	 */
	public void setTmRUserCustomerList(
			List<TmRUserCustomerEntity> tmRUserCustomerList) {
		TmRUserCustomerList = tmRUserCustomerList;
	}
	
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.user.entity.TmUserPositionEntity> 
	 * 
	 * @return java.util.List<com.biz.eisp.mdm.user.entity.TmUserPositionEntity> 用户与职位关系列表.
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id")
	@JsonIgnore
	@Fetch(FetchMode.SUBSELECT)
	public List<TmUserPositionEntity> getTmUserPositionList() {
		return tmUserPositionList;
	}
	
	/**
	 * 方法：设置java.util.List<com.biz.eisp.mdm.user.entity.TmUserPositionEntity> 
	 * @param  java.util.List<com.biz.eisp.mdm.user.entity.TmUserPositionEntity> 用户与职位关系列表
	 */
	public void setTmUserPositionList(List<TmUserPositionEntity> tmUserPositionList) {
		this.tmUserPositionList = tmUserPositionList;
	}
	@Override
	public String businessDesc() {
		return "用户基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
}
