package com.biz.eisp.mdm.user.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
/**
 * 用户与职位对应关系实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_user_position")
public class TmUserPositionEntity extends IdEntity implements java.io.Serializable,Loggerable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 关系开始日期
	 */
	private Date startDate;
	/**
	 * 关系结束日期
	 */
	private Date endDate;
	/**
	 * 关系类型 0－主职位 1-兼职职位
	 */
	private String isMain;
	/**
	 * 状态 0删除 1正常
	 */
	private Integer status;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人ID
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人
	 */
	private java.lang.String updateName;
	/**
	 * 用户实体
	 */
	private TmUserEntity tmUser;
	/**
	 * 职位实体
	 */
	private TmPositionEntity tmPosition;
	
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 开始日期
	 */
	@Column(name ="start_date",nullable=true)
	public Date getStartDate() {
		return startDate;
	}
	/**
	 *方法: 设置 java.util.Date 开始日期
	 *@param: java.util.Date 开始日期
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 结束日期
	 */
	@Column(name ="end_date",nullable=true)
	public Date getEndDate() {
		return endDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 结束日期
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 职位类型标示
	 */
	@Column(name = "is_main")
	public String getIsMain() {
		return isMain;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 职位类型标示
	 */
	public void setIsMain(String isMain) {
		this.isMain = isMain;
	}
	/**
	 *方法: 取得 java.lang.Integer
	 *@return: java.lang.Integer 状态
	 */
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 状态
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.user.entity.TmUserEntity
	 *@return: com.biz.eisp.mdm.user.entity.TmUserEntity 用户实体
	 */
	@ManyToOne(fetch = FetchType.EAGER )
	@JoinColumn(name = "user_id",referencedColumnName="id",updatable=true,insertable=true) 
	public TmUserEntity getTmUser() {
		return tmUser;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.user.entity.TmUserEntity
	 *@param: com.biz.eisp.mdm.user.entity.TmUserEntity 用户实体
	 */
	public void setTmUser(TmUserEntity tmUser) {
		this.tmUser = tmUser;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.position.entity.TmPositionEntity
	 *@return: com.biz.eisp.mdm.position.entity.TmPositionEntity 职位实体
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPosition() {
		return tmPosition;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.position.entity.TmPositionEntity 职位实体
	 *@param: com.biz.eisp.mdm.position.entity.TmPositionEntity 职位实体
	 */
	public void setTmPosition(TmPositionEntity tmPosition) {
		this.tmPosition = tmPosition;
	}
	@Override
	public String businessDesc() {
		return "用户职位管理";
	}
	@Override
	public String addLogContent() {
		String content="";
		if(tmPosition!=null){
			content="用户["+tmUser.getUserName()+"-"+tmUser.getFullName()+"]关联职位["
					+tmPosition.getPositionCode()+"-"+tmPosition.getPositionName()+"]</br>";
		}
		return content;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		String content="";
		String postCode=tmPosition!=null?tmPosition.getPositionCode():"空";
		String postName=tmPosition!=null?tmPosition.getPositionName():"";
		if(tmUser==null){
			content="取消关联职位["+postCode+"-"+postName+"]</br>";
		} else {

			//处理主职位修改的日志信息
			if(CollectionUtil.listNotEmptyNotSizeZero(modifyFieldList)) {
				for(ModifyObject obj : modifyFieldList) {
					String fieldName = obj.getFieldName();
					if(fieldName.equals("isMain")) {
						String oldVal = obj.getOldVal().toString().equals("0") ? "是" : "否";
						String nowVal = obj.getNowVal().toString().equals("0") ? "是" : "否";
						content=postName + "[是否主职位] " + oldVal + " 修改为 " + nowVal + "</br>";
					}
				}
			}
		}
		return content;
	}
}
