package com.biz.eisp.mdm.user.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
/**
 * 用户与角色的对应关系实体.
 * <p>关联数据库表:tm_r_user_role<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_user_role")
public class TmUserRoleEntity extends IdEntity implements java.io.Serializable,Loggerable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 修改人
	 */
	private String updateName;
	/**
	 * 用户
	 */
	private TmUserEntity tmUser;
	/**
	 * 角色
	 */
	private TmRoleEntity tmRole;
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 创建日期
	 */
	@Column(name="create_date")
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 创建日期
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 修改日期
	 */
	@Column(name="update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 修改日期
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得 java.lang.String 
	 *@return: java.lang.String 创建人
	 */
	@Column(name="create_name")
	public String getCreateName() {
		return createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 修改人
	 */
	@Column(name="update_name")
	public String getUpdateName() {
		return updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 修改人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.user.entity.TmUserEntity
	 *@return: com.biz.eisp.mdm.user.entity.TmUserEntity 用户实体
	 */
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="user_id",insertable=true,updatable=true)
	public TmUserEntity getTmUser() {
		return tmUser;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.user.entity.TmUserEntity
	 *@param: com.biz.eisp.mdm.user.entity.TmUserEntity 用户实体
	 */
	public void setTmUser(TmUserEntity tmUser) {
		this.tmUser = tmUser;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@return: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色实体
	 */
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="role_id",insertable=true,updatable=true)
	public TmRoleEntity getTmRole() {
		return tmRole;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.role.entity.TmRoleEntity
	 *@param: com.biz.eisp.mdm.role.entity.TmRoleEntity 角色实体
	 */
	public void setTmRole(TmRoleEntity tmRole) {
		this.tmRole = tmRole;
	}
	@Override
	public String businessDesc() {
		return "客户用户与角色关系";
	}
	@Override
	public String addLogContent() {
		String content="";
		if(tmRole!=null){
			content="客户用户["+tmUser.getUserName()+"-"+tmUser.getFullName()+"]关联角色["
					+tmRole.getRoleCode()+"-"+tmRole.getRoleName()+"]</br>";
		}
		return content;
	}
	
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		String content="";
		String roleCode=tmRole!=null?tmRole.getRoleCode():"空";
		String roleName=tmRole!=null?tmRole.getRoleName():"";
		if(tmUser==null){
			content="取消关联角色["+roleCode+"-"+roleName+"]</br>";
		}
		return content;
	}
}
