package com.biz.eisp.mdm.user.service;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.user.vo.TmUserVo;

import java.util.List;

/**
 * 用户管理操作数据后回调（操作提交后，数据已更新）
 */
public interface TmUserBackExtendService extends BaseService {


    /**
     * 保存用户.
     */
    void afterSaveTmUser(String userId);

    /**
     * 删除用户信息
     */
    void afterDeleteTmUser(List<String> userNameList);

    /**
     * 启用停用
     */
    void afterStartOrStopTmuser(TmUserVo tmUserVo);

    /**
     * 修改密码
     */
    void afterChangeTmPassword(TmUserVo tmUserVo);

    /**
     * 第一次登录修改密码
     */
    void afterChangeFirstTmPassword(TmUserVo tmUserVo);

    /**
     * 导入用户之后
     */
    void afterImportUser(List<String> saveIdList);

}
