package com.biz.eisp.mdm.user.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/**  用户导入.
 * @author grover
 * @version v1.0
 */
public class TmUserEventHandler extends ImpEventHandler <TmUserVo>{
	/**
	 * service注入.
	 */
	private TmUserService tmUserService;

	private TmUserBackExtendService tmUserBackExtendService;
	private List<String> saveIdList;
	public TmUserEventHandler(){
		tmUserService = (TmUserService) ApplicationContextUtils.getContext().getBean("tmUserService");

		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmUserBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmUserBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmUserBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());
	}
	
	@Override
	public void validate(java.util.Map<String,Object> row) throws ValidateException {
		//导入字段
		 List<TmMdmTableConfigEntity> list=DynamicConfigUtil.
				allTableConfigImpColumn.get(tableName.toUpperCase());
		for(TmMdmTableConfigEntity tableConfig:list){
			Object fieldValue=row.get(tableConfig.getField());
			String errorMsg=ValidatorFactory.validateDynamicImplData(
					tableConfig, fieldValue);
			if(StringUtil.isNotEmpty(errorMsg)){
				addError("第"+getRowNumber()+"行:"+errorMsg);
			}
			//手动验证登录名
			if(StringUtil.equals("userName", tableConfig.getField())){
				//验证重复
				String hql=" from TmUserEntity where userType=0 and userName=?";
				List result = tmUserService.findByHql(hql,fieldValue);
				if(result != null&&result.size()>0){
					addError("第" + getRowNumber() + "行,登录账号" + fieldValue + "已存在或出现重复");
				}
			}
		}
		
		//主职位信息行索引 
		Object positionId=row.get("positionId");
		//主职位验证
		if(StringUtil.isNotEmpty(positionId)){
			String sql = "SELECT COUNT(1) FROM TM_POSITION WHERE POSITION_CODE=? AND ENABLE_STATUS=?";
			long count = tmUserService.getCountForJdbcParam(sql,positionId,Globals.ZERO);
			if(count == 0){
				addError("第"+getRowNumber()+"行,主职位在系统中不存在");
			}else{
				//验证是否被用
				TmPositionEntity entity = tmUserService
						.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
				String userSql = "SELECT COUNT(1) FROM TM_R_USER_POSITION WHERE POSITION_ID=?";
				count = tmUserService.getCountForJdbcParam(userSql,entity.getId());
				if(count > 0){
					addError("第"+getRowNumber()+"行,主职位已经被使用");
				}else{
					row.put("positionId", entity.getId());
				}
			}
		}
	};
	
	@Override
	public void endRow(Map<String, Object> row, TmUserVo bean) throws ValidateException {
		try {
			if(StringUtil.isEmpty(bean.getPassword())){
				bean.setPassword("123456");
			}
			bean.setUserType(Globals.ENTERPRISE_USER);
			String mainPositionId=bean.getPositionId();
			if(StringUtil.isNotEmpty(mainPositionId)){
				List <TmPositionVo> tmUserPositionList = new ArrayList<TmPositionVo>();
				TmPositionVo tmPositionVo = new TmPositionVo();
				tmPositionVo.setId(mainPositionId);
				tmPositionVo.setIsMain("0");
				tmUserPositionList.add(tmPositionVo);
				bean.setPositionJson(JSONArray.toJSONString(tmUserPositionList));
			}
			String id = tmUserService.saveTmUser(bean, null);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		setSuccNum(getSuccNum()+1);
	}

	@Override
	public void impEnd() {
		if (null != tmUserBackExtendService){
			tmUserBackExtendService.afterImportUser(saveIdList);
		}
	}
}
