package com.biz.eisp.mdm.user.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.user.vo.QueryTmuserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;

/**
 * 用户service.
 * @author grover
 * @version v1.0
 */
public interface TmUserService extends BaseService {
	/**
	 * 查询用户信息.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @param page 分页及其其他信息对象
	 * @return 用户信息
	 */
	public List<TmUserVo> findTmUserList(TmUserVo tmUserVo, Page page);

	/**
	 * 查询用户信息-Fily(2020-07-16)
	 * @param tmUserVo
	 * @param page
	 * @return
	 */
	public List<TmUserVo> findTmUserListNew(TmUserVo tmUserVo, Page page);

	/**
	 * 业务标签查询用户信息.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @param page 分页及其其他信息对象
	 * @return 用户信息
	 */
	public List<TmUserVo> getTmUserBySearch(TmUserVo tmUserVo, Page page);
	/**
	 * 通过主键查询用户.
	 * @author grover
	 * @param id 用户id
	 * @return 用户vo对象
	 */
	public TmUserVo getTmUserVo(String id);
	/**
	 * 保存或者编辑用户.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @param page 分页及其其他信息对象
	 */
	public String saveTmUser(TmUserVo tmUserVo, Page page);
	/**
	 * 批量删除用户.
	 * @author Sean
	 * @param ids 用户id
	 * @param page 分页及其其他信息对象
	 */
	public AjaxJson deleteTmUser(String ids, Page page);
	/**
	 * 获取用户信息.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @return 用户信息
	 */
	TmUserVo getTmUser(TmUserVo tmUserVo);
	/**
	 * 验证用户重复.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @param param 验证值
	 * @return 验证信息
	 */
	ValidForm valideTmUser(TmUserVo tmUserVo, String param);
	/**
	 * 启用停用.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @return 失败或者成功
	 */
	AjaxJson startOrStopTmuser(TmUserVo tmUserVo);
	/**
	 * 修改密码.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @return 失败或者成功
	 */
	AjaxJson changeTmuserPassword(TmUserVo tmUserVo);
	/**
	 * 第一次登录修改密码.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @return 失败或者成功
	 */
	AjaxJson changeFirstTmPassword(TmUserVo tmUserVo);
	/**
	 *  企业用户相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询企业用户的方式.<br>
	 * 0、无参数 userName用户名，fullName姓名 模糊查询
	 * 1、当前企业用户信息 所需参数：id用户id<br>
	 * 2、上级企业用户信息 所需参数：parentUserId用户id<br>
	 * 3、下级企业用户信息 所需参数：levelUserId用户id<br>
	 * 4、某种角色的企业用户信息 所需参数：roleIds角色id 或者 roleNames角色名称<br>
	 * 5、某种职级的企业用户信息 所需参数：positionLevel职位级别编码<br>
	 * 6、某职位企业用户信息 所需参数：positionId职位id 或者 positionName职位名称<br>
	 * 7、职位及下级职位的企业用户信息 所需参数：levelPositionId职位id<br>
	 * 8、职位及上级职位的企业用户信息 所需参数：parentPositionId职位id<br>
	 * 9、组织直管的企业用户信息 所需参数：orgId组织id 或者 orgName组织名称<br>
	 * 10、组织及其下级组织的企业用户信息 所需参数：levelOrgId组织id<br>
	 * 11、组织及其上级级组织的企业用户信息 所需参数：parentOrgId组织id<br>
	 * 12、 其他情况自由组合0-11
	 * @author grover
	 * @param queryTmuserVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 用户vo集合
	 */
	List<TmUserVo> findTmUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page);
	/**
	 *  经销商用户相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询经销商用户的方式.<br>
	 * 0、无参数 userName用户名，fullName姓名 模糊查询
	 * 1、当前经销商用户信息 所需参数：custName经销商名称 或者 custId经销商id<br>
	 * 2、某种角色的经销商用户信息 所需参数：roleIds角色id 或者 roleNames角色名称<br>
	 * 3、 其他情况自由组合0-2
	 * @author grover
	 * @param queryTmuserVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 用户vo集合
	 */
	List<TmUserVo> findTmCustUserByAllPossible(QueryTmuserVo queryTmuserVo, Page page);
	/**所有组织与岗位*/
	List<TmUserVo> getTmUserList(TmUserVo tmUserVo);
	 /**
     * 根据职位获取用户相关信息.
     * @author grover
     * @param posId
     * 		职位id
     * @return
     * 		用户相关信息
     */
    public UserInfoEntity findUserInfoEntityByPosId(String posId);
}
