package com.biz.eisp.mdm.user.service.impl;

import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

import com.biz.eisp.base.common.util.*;
import com.biz.eisp.login.service.PasswdService;
import com.biz.eisp.mdm.user.service.TmUserSearchExtendService;
import com.biz.eisp.mdm.user.service.future.FutureVisitCount;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.dao.TmUserDao;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserExtendService;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.transformer.TmUserEntityToTmUserVo;
import com.biz.eisp.mdm.user.transformer.TmUserVoToTmUserEntity;
import com.biz.eisp.mdm.user.vo.QueryTmuserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.biz.eisp.mdm.web.pojo.Client;

/** 企业用户接口实现.
 * @author liukai
 * @version v1.0
 */
@Service("tmUserService")
@Transactional
public class TmUserServiceImpl extends BaseServiceImpl implements TmUserService{
	/**
	 * 注入用户dao
	 */
	@Autowired
	private TmUserDao tmUserDao;
	/**
	 * 注入职位service
	 */
	@Autowired
	private TmPositionService tmPositionService;
	/**
	 * 注入用户扩展service
	 */
	@Autowired(required=false)
	private TmUserExtendService tmUserExtendService;

	@Autowired(required=false)
	private TmUserSearchExtendService tmUserSearchExtendService;

	/**
	 * 密码加密扩展
	 */
	@Autowired(required = false)
	private PasswdService passwdService;

	@Autowired(required = false)
	private ThreadPoolTaskExecutor taskExecutor;

	@Override
	public List<TmUserVo> findTmUserList(TmUserVo tmUserVo, Page page) {
		String sql="";
		if(tmUserSearchExtendService!=null){
			sql=tmUserSearchExtendService.buildSearchSql(tmUserVo);
			if(StringUtil.isEmpty(sql)){
				sql =DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
				sql=tmUserSearchExtendService.extendSearchSql(tmUserVo,sql);
			}
		}else{
			sql =DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
			sql=this.appendUserCondition(sql, tmUserVo);
		}

		List <TmUserVo> volist = tmUserDao.findTmUserList(tmUserVo, page,sql);

		//查询职位
		TmPositionVo tmPositionVo = null;
		if(!CollectionUtils.isEmpty(volist)){
			StringBuffer posNames = null;
			StringBuffer isMains = null;
			StringBuffer posIds = null;
			if (taskExecutor !=null && volist.size()>1){ //如果超过1条那么进行加速处理 使用多线程
				Map<String,List<TmPositionVo>> result=new HashMap<>();
				for (TmUserVo userVo : volist) {
					TmPositionVo tmPosition = new TmPositionVo();
					tmPosition.setUserId(tmUserVo.getId());
					List<TmPositionVo> list = tmPositionService.findTmPositionList(tmPosition, null);
					if (!CollectionUtil.listNotEmptyNotSizeZero(list)){
						list=new ArrayList<>();
					}
					result.put(userVo.getId(), list);
				}
				/*List<FutureTask<Map<String,List<TmPositionVo>>>> futureTasks=new ArrayList<>();
				for (TmUserVo tmUserVo2 : volist) {
					doTask(futureTasks,tmUserVo2);
				}
				for (int i = 0; i <futureTasks.size() ; i++) {
					try {
						Map<String,List<TmPositionVo>> map=futureTasks.get(i).get();
						if (map!=null){
							result.putAll(map);
						}
					} catch (InterruptedException e) {
						e.printStackTrace();
					} catch (ExecutionException e) {
						e.printStackTrace();
					}
				}*/
				for (TmUserVo tmUserVo2 : volist) {
					posNames = new StringBuffer();
					isMains = new StringBuffer();
					posIds = new StringBuffer();
					tmPositionVo = new TmPositionVo();
					tmPositionVo.setUserId(tmUserVo2.getId());
					List<TmPositionVo> list = result.get(tmUserVo2.getId());
					if (CollectionUtils.isEmpty(list)){
						list=new ArrayList<>();
					}
					//封装json
					tmUserVo2.setPositionJson(JSONArray.toJSONString(list));
					//封装字符串
					for (TmPositionVo tmPositionVo2 : list) {
						if (posNames.length() > 0) {
							posNames.append(",");
							isMains.append(",");
							posIds.append(",");
						}
						posNames.append(tmPositionVo2.getPositionName());
						isMains.append(tmPositionVo2.getIsMain());
						posIds.append(tmPositionVo2.getId());
					}
					tmUserVo2.setPositionName(posNames.toString());
					tmUserVo2.setIsMain(isMains.toString());
					tmUserVo2.setPositionId(posIds.toString());
				}

			}else {
				for (TmUserVo tmUserVo2 : volist) {
					posNames = new StringBuffer();
					isMains = new StringBuffer();
					posIds = new StringBuffer();
					tmPositionVo = new TmPositionVo();
					tmPositionVo.setUserId(tmUserVo2.getId());
					List<TmPositionVo> list = tmPositionService.findTmPositionList(tmPositionVo, null);
					if (CollectionUtils.isEmpty(list)){
						list=new ArrayList<>();
					}
					//封装json
					tmUserVo2.setPositionJson(JSONArray.toJSONString(list));
					//封装字符串
					for (TmPositionVo tmPositionVo2 : list) {
						if (posNames.length() > 0) {
							posNames.append(",");
							isMains.append(",");
							posIds.append(",");
						}
						posNames.append(tmPositionVo2.getPositionName());
						isMains.append(tmPositionVo2.getIsMain());
						posIds.append(tmPositionVo2.getId());
					}
					tmUserVo2.setPositionName(posNames.toString());
					tmUserVo2.setIsMain(isMains.toString());
					tmUserVo2.setPositionId(posIds.toString());
				}
			}
		}
		return volist;
	}

	@Override
	public List<TmUserVo> findTmUserListNew(TmUserVo tmUserVo, Page page) {
		String sql="";
		if(tmUserSearchExtendService!=null){
			sql=tmUserSearchExtendService.buildSearchSql(tmUserVo);
			if(StringUtil.isEmpty(sql)){
				sql =DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
				sql=tmUserSearchExtendService.extendSearchSql(tmUserVo,sql);
			}
		}else{
			sql =DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_USER, tmUserVo);
			sql=this.appendUserCondition(sql, tmUserVo);
		}

		List <TmUserVo> volist = tmUserDao.findTmUserList(tmUserVo, page,sql);

		return volist;
	}

	private void doTask(List<FutureTask<Map<String,List<TmPositionVo>>>> futureTasks,TmUserVo tmUserVo){
		FutureVisitCount f = new FutureVisitCount(tmUserVo,tmPositionService);
		FutureTask<Map<String,List<TmPositionVo>>> futureTask=new FutureTask<>(f);
		taskExecutor.execute(futureTask);
		futureTasks.add(futureTask);
	}
	/**
	 * 扩展动态生成sql ，添加非本身数据表查询条件
	 * 扩展查询字段 关联查询
	 * @param sql
	 * @param userVo
	 * @return
	 */
	public String appendUserCondition(String sql,TmUserVo userVo){
		//关联查询关联了职位表、企业组织表、用户与职位对应关系表、用户表
		String joinSql="SELECT rup.user_id," +
				"   listagg(rup.position_id,',') within GROUP (order by  tr.org_name) positionId," +
				"   listagg( p.position_name,',') within GROUP (order by  tr.org_name) positionName," +
				"   listagg( p.position_level,',') within GROUP (order by  tr.org_name) positionLevel," +
				"   listagg(tr.org_name,',') within GROUP (order by  tr.org_name) orgName," +
				"   listagg(tr.id,',') within GROUP (order by  tr.org_name) orgId," +
				"   listagg( prp.position_name,',') within GROUP (order by tr.org_name) parentPositionName," +
				"  listagg( prp.id,',') within GROUP (order by tr.org_name) parentPositionId," +
				"  listagg( pu.fullname,',') within GROUP (order by tr.org_name) parentUserName," +
				"  listagg( pu.id,',') within GROUP (order by tr.org_name) parentUserId FROM tm_r_user_position rup " +
				"  LEFT JOIN tm_position p" +
				"  ON p.id = rup.position_id" +
				"  LEFT JOIN tm_org tr" +
				"  ON p.org_id = tr.id" +
				"  LEFT JOIN tm_position prp" +
				"  ON prp.id = p.parent_id" +
				"  LEFT JOIN tm_r_user_position ptup" +
				"  ON (ptup.position_id=prp.id" +
				"  AND ptup.is_main    = 0) " +
				"  LEFT JOIN tm_user pu" +
				"  ON pu.id  =ptup.user_id where 1=1  group by rup.user_id";

		
		//追加查询条件
		String sqlWhere="";
		
		//id查询 更新、查看时用
		if(StringUtil.isNotEmpty(userVo.getId())){
			sqlWhere+=" and t.id='"+userVo.getId()+"'";
		}
		
		//根据企业组织查询
		if(StringUtil.isNotEmpty(userVo.getOrgId())){
			sqlWhere+=" and t1.orgId like '%"+userVo.getOrgId()+"%'";
		}
		//根据企业组织查询  精确查询 固定查询
		if(StringUtil.isNotEmpty(userVo.getOrgName())){
			sqlWhere+=" and t1.orgId like '%"+userVo.getOrgName()+"%'";
		}
		//根据职位名称查询
		if(StringUtil.isNotEmpty(userVo.getPositionName())){
			sqlWhere+=" and t1.positionName like '%"+userVo.getPositionName()+"%'";
		}
		//根据上级职位名称查询
		if(StringUtil.isNotEmpty(userVo.getParentPositionName())){
			sqlWhere+=" and t1.parentPositionName like '%"+userVo.getParentPositionName()+"%'";
		}
		//根据上级用户姓名查询
		if(StringUtil.isNotEmpty(userVo.getParentUserName())){
			sqlWhere+=" and t1.parentUserName like '%"+userVo.getParentUserName()+"%'";
		}
		//根据启用状态查询
		if(userVo.getEnableStatus() != null){
			sqlWhere+=" and t.enableStatus = "+userVo.getEnableStatus();
		}
		//根据用户类型查询
		if(userVo.getUserType() != null){
			sqlWhere+=" and t.userType = 0";
		}
		
		String orderSql=" order by t.userName asc";
		//关联on关键字
		String sqlOn=" t1.user_id = t.id";
		//拼装关联后的查询sql
		return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql,sqlOn, sqlWhere,orderSql);
	}
	
	@Override
	public TmUserVo getTmUserVo(String id) {
		TmUserVo vo = null;
		if(StringUtils.isBlank(id)) {
			return vo;
		}
		
		TmUserEntity tmUserEntity = this.get(TmUserEntity.class, id);
		
		if(tmUserEntity == null) {
			throw new BusinessException("找不到职位Entity实体:" + id);
		}
		
		vo = new TmUserEntityToTmUserVo(this).apply(tmUserEntity);
		
		return vo;
	}

	@Override
	public String saveTmUser(TmUserVo tmUserVo, Page page) {
		TmUserEntity tmUserEntity = null;
		String userId="";
		//保存前扩展 entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmUserExtendService)){
			//保存前检验数据
			try {
				tmUserExtendService.validate(tmUserVo, page);
			} catch (Exception e) {
				throw new BusinessException("数据校验失败:"+e.getMessage());
			}
			//保存前扩展
			tmUserEntity = tmUserExtendService.saveBefore(tmUserVo, page);
		}
		//如果没有扩展 则直接vo转entity
		if(tmUserEntity==null){
			TmUserVoToTmUserEntity tmUserVoToTmUserEntity = new TmUserVoToTmUserEntity(this,passwdService);
			tmUserEntity = tmUserVoToTmUserEntity.apply(tmUserVo);
			userId=tmUserEntity.getId();
		}
		//保存前扩展 entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmUserExtendService)){
			tmUserEntity = tmUserExtendService.saveBefore(tmUserEntity, tmUserVo, page);
		}
		//1.保存用户主数据
		this.saveOrUpdate(tmUserEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(tmUserExtendService)){
			tmUserEntity = tmUserExtendService.savePost(tmUserEntity, tmUserVo, page);
		}
		
		//2.删除无用关系数据同时记录日志
		String hql="FROM TmUserPositionEntity where tmUser.id is null";
		List<TmUserPositionEntity> list=this.findByHql(hql);
		for(TmUserPositionEntity userPosition:list){
			String userPostId=userPosition.getId();
			super.addLogAndRemoveInvalidInfo(userPostId, userPosition, userId,null);
		}
		//删除无用职位与职员关系
		executeSql("DELETE FROM TM_R_USER_POSITION WHERE USER_ID IS NULL");

		if (null != tmUserEntity){
			return tmUserEntity.getId();
		}
		return null;
	}

	@Override
	public AjaxJson deleteTmUser(String ids, Page page) {
		AjaxJson json = new AjaxJson();
		Map<String,Object> attributes = new HashMap<>();
		if(StringUtil.isNotEmpty(ids)){
			List<String> userNameList = new ArrayList<>();
			String userIds[] =ids.split(",");
			for(String userId:userIds){
				TmUserEntity userEntity=this.get(TmUserEntity.class, userId);
				if(userEntity!=null&&StringUtil.isNotEmpty(userEntity.getId())){
					userNameList.add(userEntity.getUserName());
					this.delete(userEntity);
				}
			
			}
			attributes.put("userNameList",userNameList);
		}
		json.setAttributes(attributes);
		return json;
	}
	

	@Override
	public ValidForm valideTmUser(TmUserVo tmUserVo, String param) {
		ValidForm validForm = new ValidForm();
		String hql = "";
		if(StringUtil.isNotEmpty(tmUserVo.getId())){
			//修改
			hql = "from TmUserEntity where userName=? and id<>? and enableStatus=?";
			List<TmUserEntity> list = findByHql(hql, param, tmUserVo.getId(), Short.parseShort(Globals.ZERO.toString()));
			if(!CollectionUtils.isEmpty(list)){
				validForm.setInfo("登录账号已经存在");
				validForm.setStatus("n");
			}
		}else{
			//新增
			hql = "from TmUserEntity where userName=? and enableStatus=?";
			List<TmUserEntity> list = findByHql(hql, param, Short.parseShort(Globals.ZERO.toString()));
			if(!CollectionUtils.isEmpty(list)){
				validForm.setInfo("登录账号已经存在");
				validForm.setStatus("n");
			}
		}
		return validForm;
	}

	@Override
	public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
		AjaxJson j = new AjaxJson();
		TmUserEntity tmUserEntity = get(TmUserEntity.class, tmUserVo.getId());
		if(StringUtil.isNotEmpty(tmUserEntity)){
			if(tmUserEntity.getEnableStatus().toString().equals(tmUserVo.getEnableStatus().toString())){
				j.setSuccess(false);
				String fg = Globals.ZERO == tmUserVo.getEnableStatus().intValue()?"启用":"停用";
				j.setMsg("该数据状态已经为"+fg+"，无需再次操作");
			}else{
				tmUserEntity.setEnableStatus(Short.parseShort(tmUserVo.getEnableStatus().toString()));
				tmUserEntity.setLoginErrTimes(Globals.User_Normal);
				updateEntity(tmUserEntity);
			}
		}else{
			throw new BusinessException("未找到该纪录");
		}
		return j;
	}

	@Override
	public TmUserVo getTmUser(TmUserVo tmUserVo) {
		return tmUserDao.getTmUser(tmUserVo);
	}

	@Override
	public AjaxJson changeTmuserPassword(TmUserVo tmUserVo) {
		AjaxJson json = new AjaxJson();
		if(StringUtil.isEmpty(tmUserVo.getPassword())
				|| StringUtil.isEmpty(tmUserVo.getNewpassword())){
			json.setSuccess(false);
			json.setMsg("缺少必要的参数");
			return json;
		}else{
			//原密码
			String password = Md5EncryptionAndDecryption.encryPwd(tmUserVo.getPassword());
			//当前用户
			TmUserEntity userEntity = ResourceConfigUtils.getSessionUserName();
			if(!password.equals(userEntity.getPassword())){
				json.setSuccess(false);
				json.setMsg("原密码不一致,请重新输入原密码");
				return json;
			}else{
				//修改
				String sql="update tm_user set password = ? , update_date = ? , update_name = ? where id=?";
				int flag = executeSql(sql, Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()),
						new Date(), ResourceConfigUtils.getSessionUserName().getUserName(),userEntity.getId());
				//更新session
				if(flag > 0){
					Client client = ResourceConfigUtils.getClient();
					userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()));
					client.setUser(userEntity);
					ResourceConfigUtils.setClient(client);
				}
			}
		}
		return json;
	}
	
	@Override
	public AjaxJson changeFirstTmPassword(TmUserVo tmUserVo) {
		AjaxJson json = new AjaxJson();
		if(StringUtil.isEmpty(tmUserVo.getPassword())
				|| StringUtil.isEmpty(tmUserVo.getNewpassword())){
			json.setSuccess(false);
			json.setMsg("缺少必要的参数");
			return json;
		}else{
			//原密码
			String password = Md5EncryptionAndDecryption.encryPwd(tmUserVo.getPassword());
			//当前用户
			TmUserEntity userEntity = ResourceConfigUtils.getSessionUserName();
			if(!password.equals(userEntity.getPassword())){
				json.setSuccess(false);
				json.setMsg("原密码不一致,请重新输入原密码");
				return json;
			}else{
				//修改
				String sql="update tm_user set has_first_time=0 , password = ? , update_date = ? , update_name = ? where id=?";
				int flag = executeSql(sql, Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()),
						new Date(),tmUserVo.getUserName(),userEntity.getId());
				//更新session
				if(flag > 0){
					Client client = ResourceConfigUtils.getClient();
					userEntity.setPassword(Md5EncryptionAndDecryption.encryPwd(tmUserVo.getNewpassword()));
					client.setUser(userEntity);
					ResourceConfigUtils.setClient(client);
				}
			}
		}
		return json;
	}

	@Override
	public List<TmUserVo> findTmUserByAllPossible(QueryTmuserVo queryTmuserVo,
			Page page) {
		return tmUserDao.findTmUserByAllPossible(queryTmuserVo, page);
	}

	@Override
	public List<TmUserVo> findTmCustUserByAllPossible(
			QueryTmuserVo queryTmuserVo, Page page) {
		return tmUserDao.findTmCustUserByAllPossible(queryTmuserVo,page);
	}

	@Override
	public List<TmUserVo> getTmUserBySearch(TmUserVo tmUserVo, Page page) {
		QueryTmuserVo queryTmuserVo = new QueryTmuserVo();
		if(StringUtil.isNotEmpty(tmUserVo.getSearchParam())){
			queryTmuserVo.setFullName(tmUserVo.getSearchParam());
		}
		return tmUserDao.findTmUserByAllPossible(queryTmuserVo,page);
	}

	@Override
	public List<TmUserVo> getTmUserList(TmUserVo tmUserVo) {
		// TODO Auto-generated method stub
		return tmUserDao.getTmUserList(tmUserVo);
	}

	@Override
	public UserInfoEntity findUserInfoEntityByPosId(String posId) {
		String nowDate = DateUtils.dateNow2Str();
		return tmUserDao.findUserInfoEntityByPosId(posId, nowDate);
	}
}
