package com.biz.eisp.mdm.user.transformer;

import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TmUserEntityToTmUserVo implements Function<TmUserEntity, TmUserVo>{
	
	private TmUserService  tmUserService;
	
	public TmUserEntityToTmUserVo(TmUserService userService){
		tmUserService = userService;
	}
	
	@Override
	public TmUserVo apply(TmUserEntity entity) {
		TmUserVo vo = new TmUserVo();
		
		BeanUtils.copyProperties(entity, vo);
		//职位
		List<TmUserPositionEntity> positions = tmUserService
				.findByProperty(TmUserPositionEntity.class, "tmUser.id", entity.getId());
		if(!CollectionUtils.isEmpty(positions)){
			StringBuffer posNames = new StringBuffer();
			StringBuffer posIds = new StringBuffer();
			StringBuffer isMains = new StringBuffer();
			for (TmUserPositionEntity tmUserPositionEntity : positions) {
				if(posIds.length() > 0){
					posIds.append(",");
					posNames.append(",");
					isMains.append(",");
				}
				posIds.append(tmUserPositionEntity.getTmPosition().getId());
				posNames.append(tmUserPositionEntity.getTmPosition().getPositionName());
				isMains.append(tmUserPositionEntity.getIsMain());
			}
			vo.setPositionName(posNames.toString());
			vo.setPositionId(posIds.toString());
			vo.setIsMain(isMains.toString());
		}
		
		return vo;
	}

}
