package com.biz.eisp.mdm.user.transformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.biz.eisp.login.service.PasswdService;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.biz.eisp.mdm.user.entity.TmUserRoleEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.google.common.base.Function;

/** vo转entity.
 * @author liukai
 * @version v1.0
 */
@SuppressWarnings("deprecation")
public class TmUserVoToTmUserEntity implements Function<TmUserVo, TmUserEntity>, Serializable{
	/**
	 * 描述.
	 */
	private static final long serialVersionUID = 1L;
	private TmUserService tmUserService;
	private PasswdService passwdService;
	public TmUserVoToTmUserEntity(TmUserService tmUserService,PasswdService passwdService) {
		this.tmUserService = tmUserService;
		this.passwdService=passwdService;
	}
	
	@Override
	public TmUserEntity apply(TmUserVo vo) {
		TmUserEntity entity = new TmUserEntity();
		if(StringUtil.isNotEmpty(vo.getId())){
			entity = tmUserService.get(TmUserEntity.class, vo.getId());
		}else{
			//验证重复
			String hql=" from TmUserEntity where userType=0 and userName=?";
			List list = tmUserService.findByHql(hql,vo.getUserName());
			if(list != null&&list.size()>0){
				throw new BusinessException("登录账号"+vo.getUserName()+"已存在");
			}
		}
		
		try {
			if(!StringUtil.isNotEmpty(vo.getEnableStatus())){
				vo.setEnableStatus(Globals.ZERO);
			}
			//headstring
			vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getFullName()));
			if (passwdService!=null&&passwdService.isExtend(entity)){
				if(!Globals.NO_PASSWORD.equals(vo.getPassword())){
					vo.setHasFirstTime(1);
					String md5Password = passwdService.pwd(vo.getPassword());
					vo.setPassword(md5Password);
				}else{
					vo.setPassword(null);
				}
			}else{
				//md5密码
				if(!Globals.NO_PASSWORD.equals(vo.getPassword())){
					vo.setHasFirstTime(1);
					String md5Password = Md5EncryptionAndDecryption.encryPwd(vo.getPassword());
					vo.setPassword(md5Password);
				}else{
					vo.setPassword(null);
				}
			}

			copyProperties(vo, entity);
			
			//设置职位
			String positionJson = vo.getPositionJson();
			List <TmUserPositionEntity>userPositionList = this.getTmUserPositionList(vo,entity, positionJson);
			entity.setTmUserPositionList(userPositionList);
			//经销商用户
			//设置客户
			String custId = vo.getCustId();
			List<TmRUserCustomerEntity> tmRUserCustomerList = this.getTmRUserCustomerList(entity, custId);
			entity.setTmRUserCustomerList(tmRUserCustomerList);
			//设置角色
			String roleIds = vo.getRoleIds();
			List<TmUserRoleEntity> tmUserRoleList = this.getTmUserRoleList(entity, roleIds);
			entity.setTmUserRoleList(tmUserRoleList);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("用户vo转换entity异常");
		}
		return entity;
	}
	
	public void copyProperties(TmUserVo vo, TmUserEntity entity) {
		entity.setEmail(vo.getEmail());
		entity.setBeginDate(vo.getBeginDate());
		entity.setEndDate(vo.getEndDate());
		entity.setEnableStatus(vo.getEnableStatus().shortValue());
		if (StringUtils.isNotBlank(vo.getExtChar1()))
		entity.setExtChar1(vo.getExtChar1());
		if (StringUtils.isNotBlank(vo.getExtChar2()))
		entity.setExtChar2(vo.getExtChar2());
		if (StringUtils.isNotBlank(vo.getExtChar3()))
		entity.setExtChar3(vo.getExtChar3());
		if (StringUtils.isNotBlank(vo.getExtChar4()))
		entity.setExtChar4(vo.getExtChar4());
		if (StringUtils.isNotBlank(vo.getExtChar5()))
		entity.setExtChar5(vo.getExtChar5());
		if (StringUtils.isNotBlank(vo.getExtChar6()))
		entity.setExtChar6(vo.getExtChar6());
		if (StringUtils.isNotBlank(vo.getExtChar7()))
		entity.setExtChar7(vo.getExtChar7());
		if (StringUtils.isNotBlank(vo.getExtChar8()))
		entity.setExtChar8(vo.getExtChar8());
		if (StringUtils.isNotBlank(vo.getExtChar9()))
		entity.setExtChar9(vo.getExtChar9());
		if (StringUtils.isNotBlank(vo.getExtChar10()))
		entity.setExtChar10(vo.getExtChar10());
		entity.setExtDate1(vo.getExtDate1());
		entity.setExtDate2(vo.getExtDate2());
		if (vo.getExtNumber1()!=null)
		entity.setExtNumber1(vo.getExtNumber1());
		if (vo.getExtNumber2()!=null)
		entity.setExtNumber2(vo.getExtNumber2());
		if (vo.getExtNumber3()!=null)
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setFullName(vo.getFullName());
		entity.setMobilePhone(vo.getMobilePhone());
		if(StringUtil.isNotEmpty(vo.getPassword())){
			entity.setPassword(vo.getPassword());
		}
		if(StringUtils.isNotBlank(vo.getSex()))
		entity.setSex(Integer.parseInt(vo.getSex()));
		entity.setUserName(vo.getUserName());
		entity.setHeadString(vo.getHeadString());
		entity.setUserType(vo.getUserType());
		if (StringUtil.isNotEmpty(vo.getHasFirstTime()))
		entity.setHasFirstTime(vo.getHasFirstTime());
	}
	
	/**
	 * 设置职位.
	 * @author grover
	 * @param userEntity 用户对象
	 * @param positionJson 职位json
	 * @return 用户职位集合
	 */
	public List <TmUserPositionEntity> getTmUserPositionList(TmUserVo vo,TmUserEntity userEntity, String positionJson) {
		JSONArray array = JSONArray.parseArray(positionJson);
		List <TmUserPositionEntity> tmUserPositionList = new ArrayList<TmUserPositionEntity>();
		if(StringUtil.isNotEmpty(array) && array.size() > 0){
			for(int i = 0;i < array.size(); i++) {
				JSONObject obj = array.getJSONObject(i);
				String tmRPositionUserId = obj.getString("tmRPositionUserId");
				String positionId = obj.getString("id");
				String isMain = obj.getString("isMain");
				TmUserPositionEntity userPositionEntity = null;
				if(StringUtils.isNotBlank(tmRPositionUserId)) {
					userPositionEntity = tmUserService.get(TmUserPositionEntity.class, tmRPositionUserId);
				} else {
					userPositionEntity = new TmUserPositionEntity();
					TmPositionEntity positionEntity = tmUserService.get(TmPositionEntity.class, positionId);
					userPositionEntity.setTmPosition(positionEntity);
					userPositionEntity.setTmUser(userEntity);
				}
				
				//开始日期
				Calendar startCalendar = Calendar.getInstance();
				startCalendar.setTime(new Date());
				startCalendar.add(Calendar.DAY_OF_MONTH, -1);
				//结束日期
				Calendar endCalendar = Calendar.getInstance();
				endCalendar.set(9998, 12, 1, 1, 1, 1);
				
				userPositionEntity.setIsMain(isMain);
				userPositionEntity.setStartDate(startCalendar.getTime());
				userPositionEntity.setEndDate(endCalendar.getTime());
				userPositionEntity.setStatus(Globals.ZERO);
				
				tmUserPositionList.add(userPositionEntity);
			}
		}
		return tmUserPositionList;
	}
	/**
	 * 设置经销商用户与客户的关系.
	 * @author grover
	 * @param tmUserEntity 用户对象
	 * @param custId 客户id
	 * @return 经销商用户与客户的关系
	 */
	public List<TmRUserCustomerEntity> getTmRUserCustomerList(TmUserEntity tmUserEntity, String custId) {
		List<TmRUserCustomerEntity> list = new ArrayList<TmRUserCustomerEntity>();
		if(StringUtil.isNotEmpty(custId)){
			String hql="from TmRUserCustomerEntity where tmUser.id=? and tmCustomer.id=?";
			TmRUserCustomerEntity tmRUserCustomerEntity = tmUserService
					.getUniqueByHql(TmRUserCustomerEntity.class, hql,
							tmUserEntity.getId(), custId);
			if(tmRUserCustomerEntity == null){
				//设置关系
				tmRUserCustomerEntity = new TmRUserCustomerEntity();
				tmRUserCustomerEntity.setTmUser(tmUserEntity);
				tmRUserCustomerEntity.setTmCustomer(tmUserService.get(TmCustomerEntity.class, custId));
				//设置其他属性
				tmRUserCustomerEntity.setStatus(Globals.ZERO);
				//开始日期
				Calendar startCalendar = Calendar.getInstance();
				startCalendar.setTime(new Date());
				startCalendar.add(Calendar.DAY_OF_MONTH, -1);
				//结束日期
				Calendar endCalendar = Calendar.getInstance();
				endCalendar.set(9998, 12, 1, 1, 1, 1);
				tmRUserCustomerEntity.setStartDate(startCalendar.getTime());
				tmRUserCustomerEntity.setEndDate(endCalendar.getTime());
			}
			list.add(tmRUserCustomerEntity);
		}
		return list;
	}
	/**
	 * 设置经销商用户与角色的关系.
	 * @author grover
	 * @param tmUserEntity 用户对象
	 * @param roleIds 角色id集合
	 * @return 经销商用户与角色的关系
	 */
	public List<TmUserRoleEntity> getTmUserRoleList(TmUserEntity tmUserEntity, String roleIds) {
		List<TmUserRoleEntity> list = new ArrayList<TmUserRoleEntity>();
		if(StringUtil.isNotEmpty(roleIds)){
			String hql="from TmUserRoleEntity where tmUser.id=? and tmRole.id=?";
			for (String roleId : roleIds.split(",")) {
				TmUserRoleEntity tmUserRoleEntity = tmUserService
						.getUniqueByHql(TmUserRoleEntity.class, hql,
								tmUserEntity.getId(), roleId);
				if(tmUserRoleEntity == null){
					//设置关系
					tmUserRoleEntity = new TmUserRoleEntity();
					tmUserRoleEntity.setTmUser(tmUserEntity);
					tmUserRoleEntity.setTmRole(tmUserService.get(TmRoleEntity.class, roleId));
				}
				list.add(tmUserRoleEntity);
			}
		}
		return list;
	}
}
