package com.biz.eisp.webservice;

import javax.xml.namespace.QName;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class StockQuoteClient {
	/**
	 * 方法一：
	 * 应用rpc的方式调用，这种方式就等于远程调用
	 * 即通过url定位告诉远程服务器，告知方法名称，参数等，调用远程服务，得到结果
	 * 使用 org.apache.axis2.rpc.client.RPCServiceClient类调用WebService 
	 * 注
	 * 如果被调用的WebService方法有返回值，应使用invokeBlocking方法 该方法有三个参数
	 * 第一个参数的类型是QName对象，表示要调用的方法名
	 * 第二个参数表示要调用的WebService方法的参数值，参数类开为Object[],当方法没有参数时，invokeBlocking方法的第二个参数whfgi能是null,而使用new Object[]{}
	 * 第三个参数表示WebService方法 返回值类型的Class对象，参数类型为Class[]。
	 * 如果被调用的WebService方法没有返回值，应使用invokeRobust方法，该方法只有两个参数，它的含义与invokeBlocking方法的前两个参数的含义相同
	 * 在创建QName对象时，QName类的构造方法的第一个参数表示WSDL文件的命名空间名，也就是<wsdl:definitions>元素的targetNamespace属性值
	 */
	public static void testRPCClient(){
		try{
			String url = "http://localhost:8080/axis2ServerDemo/services/StockQuoteService?wsdl";  
			//使用RPC方式调用WebService
			RPCServiceClient serviceClient = new RPCServiceClient();
			//指定调用webservice的url
			EndpointReference targetERP = new EndpointReference(url);
			Options options = serviceClient.getOptions();
			
			//确定目标服务地址
			options.setTo(targetERP);
			//确定调用方法
			options.setAction("urn:getPrice");
			
			//第一个种设置密码的方式
//			options.setUserName("aaa");
//			options.setPassword("bbb");
			//第二种设置密码的方式
			HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();  
            auth.setUsername("aaa");  
            auth.setPassword("bbb");  
            options.setProperty(HTTPConstants.AUTHENTICATE, auth);
            
			/**
			 * 指定要调用的getPrice方法及wsdl文件的命名空间
			 * 如果webservice 服务端由axis2编写
			 * 命名空间 不一至导致的问题
			 * org.apache.axis2.AxisFault: java.lang.RuntimeException: Unexpected subelement arg0 
			 */
			QName qname = new QName("http://quickstart.samples/xsd", "getPrice");  
			//指定getPrice方法的参数值
			Object[] parameters = new Object[]{"13"};
			
			//指定getPrice方法返回值的数据类型的class对象
			Class[] returnTypes = new Class[] { double.class };  
			//调用方法一传递参数，调用服务，获取服务返回结果集是一段由OMElement对象封装的xml字符串
			OMElement element = serviceClient.invokeBlocking(qname, parameters);
			String result = element.getFirstElement().getText();
			
			System.out.println(result);
			// 调用方法二 getPrice方法并输出该方法的返回值  
		    Object[] response = serviceClient.invokeBlocking(qname, parameters, returnTypes);  
		    // String r = (String) response[0];  
		    Double r = (Double) response[0];  
		    System.out.println(r);  
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		new StockQuoteClient().testRPCClient();
	}
}
