package com.biz.eisp.webservice.util;

import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import com.biz.eisp.base.utils.SysConfigUtils;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ResourceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/** 
 * webservice工具类.
 * <p>该工具类使用axis2实现webservice访问第三方服务,<br>
 * <p>无需生成java客户端，即可调用
 * @author grover
 * @version v1.0
 */
@Component
public class WebserviceUtil {

	private static SysConfigUtils sysConfigUtils;

	@Autowired
	private static void setSysConfigUtils(SysConfigUtils sysConfigUtils) {
		WebserviceUtil.sysConfigUtils = sysConfigUtils;
	}

	private static String userName;
	private static String password; 
	
	/**
	 * webservice通用请求数据.
	 * @author grover
	 * @param wsdlUrl 请求wsdl文件url
	 * @param targetNamespace 命名空间， 对应wsdl文件的targetNamespace属性
	 * @param methodName 请求的方法名称， 对应wsdl文件的<s:element>中的name属性
	 * @param parameterName 请求方法的参数， 对应wsdl文件<s:sequence>下<s:element>的name属性
	 * @param parameterType 请求方法的参数类型， 对应wsdl文件<s:sequence>下<s:element>的type属性，<br>
	 * 		  java中使用javax.xml.rpc.ParameterMode下类型表示
	 * @param returnParameterType 请求方法的返回类型，对应wsdl文件的<s:element>中的name属性+Response描述中<s:sequence>下<s:element>的name属性
	 * @param parameterVlaue 请求参数
	 * @return
	 */
	public static Object getResult(String wsdlUrl, String targetNamespace,
			String methodName, String parameterName, QName parameterType,
			QName returnParameterType, String[] parameterVlaue) {
		try {
			// 获取用户名和密码
			getWebserviceSignIn();
			// wsdl请求url
			String endpoint = wsdlUrl;
			// 客户端service对象
			Service service = new Service();
			// 通过service创建call对象
			Call call = (Call) service.createCall();
			// 设置账号
			call.setUsername(userName);
			// 设置密码
			call.setPassword(password);
			// 设置service所在URL
			call.setTargetEndpointAddress(new java.net.URL(endpoint));
			// 设置作用方法和命名空间
			call.setOperationName(new QName(targetNamespace, methodName));
			// 设置请求参数
			call.addParameter(new QName(targetNamespace, parameterName),
					parameterType, ParameterMode.IN);
			// 设置调用soap协议里面的方法
			call.setUseSOAPAction(true);
			// 返回参数的类型
			call.setReturnType(returnParameterType);
			// 为防止出现无法识别SOAPAction的值 设置指定访问的空间+方法
			call.setSOAPActionURI(targetNamespace + methodName);
			//超时时间
			call.setTimeout(60000);
			// 返回
			Object ret = call.invoke(parameterVlaue);
			return ret;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	/**
	 * 获取webservice请求的账号和密码.
	 * @author grover
	 * @param userName 账号
	 * @param password 密码
	 * @return
	 */
	private static void getWebserviceSignIn() {
		// 获取是否正式配置
//		String isFormal = ResourceUtil.getSysConfigProperty("isFormal");
		String isFormal = sysConfigUtils.getIsFormal();
		if (Globals.ISTEST.equalsIgnoreCase(isFormal)) {
			// 测试
//			userName = ResourceUtil.getSysConfigProperty("testWebserviceName");
//			password = ResourceUtil.getSysConfigProperty("testWebservicePassw");
			userName = sysConfigUtils.getTestWebserviceName();
			password = sysConfigUtils.getTestWebservicePassw();
		} else if (Globals.ISFORMAL.equalsIgnoreCase(isFormal)) {
			// 正式
//			userName = ResourceUtil.getSysConfigProperty("webserviceName");
//			password = ResourceUtil.getSysConfigProperty("webservicePassw");
			userName = sysConfigUtils.getTestWebserviceName();
			password = sysConfigUtils.getTestWebservicePassw();
		} else {
			// 未配置或者配置错误
			userName = "";
			password = "";
		}
	}
}
