/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.StdSerializers;
import org.codehaus.jackson.type.TypeReference;

public class JsonUtil {
    private static JsonUtil jsonUtil;
    private ObjectMapper mapper;

    private JsonUtil(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    private static JsonUtil getInstance() {
        if (jsonUtil == null) {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule("JsonUtil", new Version(1, 0, 0, null));
            module.addSerializer((JsonSerializer)new StdSerializers.LongSerializer());
            mapper.registerModule((Module)module);
            jsonUtil = new JsonUtil(mapper);
        }
        return jsonUtil;
    }

    private ObjectMapper getMapper() {
        return this.mapper;
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) throws Exception {
        return (T)JsonUtil.getInstance().getMapper().readValue(json, clazz);
    }

    public static String toJson(Object value) throws Exception {
        return JsonUtil.getInstance().getMapper().writeValueAsString(value);
    }

    public static <T> T covertValue(Object value, Class<T> toValueType) throws Exception {
        return (T)JsonUtil.getInstance().getMapper().convertValue(value, toValueType);
    }

    public static ArrayList<?> toObjectArrayListFromJson(String json, TypeReference<?> t) throws JsonParseException, JsonMappingException, IOException {
        return (ArrayList)JsonUtil.getInstance().getMapper().readValue(json, t);
    }

    public static String filterJSONStr(String value) {
        String retStr = value;
        retStr = retStr.replace("\"", "\"").replace(",", ",");
        return retStr;
    }

    public static String format(String jsonStr) {
        int level = 0;
        StringBuffer jsonForMatStr = new StringBuffer();
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            char c = jsonStr.charAt(i);
            if (level > 0 && '\n' == jsonForMatStr.charAt(jsonForMatStr.length() - 1)) {
                jsonForMatStr.append(JsonUtil.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    jsonForMatStr.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    jsonForMatStr.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    jsonForMatStr.append("\n");
                    jsonForMatStr.append(JsonUtil.getLevelStr(--level));
                    jsonForMatStr.append(c);
                    continue block5;
                }
                default: {
                    jsonForMatStr.append(c);
                }
            }
        }
        return jsonForMatStr.toString();
    }

    private static String getLevelStr(int level) {
        StringBuffer levelStr = new StringBuffer();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("\t");
        }
        return levelStr.toString();
    }

    public static List<Map<String, Object>> fromJson2Maps(String json) {
        JSONArray jsonArray;
        JSONArray jsonMapList = jsonArray = JSONArray.fromObject((Object)json);
        return jsonMapList;
    }
}

