/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.validation;

import com.biz.eisp.base.common.validation.ValidationMessage;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.commons.collections.CollectionUtils;

public class ValidationUtils {
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> ValidationMessage validateEntity(T obj) {
        ValidationMessage result = new ValidationMessage();
        Set set = validator.validate(obj, new Class[]{Default.class});
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            result.setSuccess(false);
            StringBuffer errorMsg = new StringBuffer();
            for (ConstraintViolation cv : set) {
                errorMsg.append(cv.getMessage());
            }
            result.setMessage(errorMsg.toString());
        } else {
            result.setSuccess(true);
        }
        return result;
    }

    public static <T> ValidationMessage validateProperty(T obj, String propertyName) {
        ValidationMessage result = new ValidationMessage();
        Set set = validator.validateProperty(obj, propertyName, new Class[]{Default.class});
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            result.setSuccess(false);
            StringBuffer errorMsg = new StringBuffer();
            for (ConstraintViolation cv : set) {
                errorMsg.append(cv.getMessage());
            }
            result.setMessage(errorMsg.toString());
        } else {
            result.setSuccess(true);
        }
        return result;
    }
}

