/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerDelExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerSearchExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.service.TmRCustPosBgDetailService;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.util.CustomerLogMsgUtil;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustomerService")
@Transactional
public class TmCustomerServiceImpl
extends BaseServiceImpl
implements TmCustomerService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired
    private TmRCustPosBgDetailService tmRCustPosBgDetailService;
    @Autowired(required=false)
    private TmCustomerSearchExtendService tmCustomerSearchExtendService;
    @Autowired(required=false)
    private TmCustomerExtendService tmCustomerExtendService;
    @Autowired(required=false)
    private TmCustomerDelExtendService tmCustomerDelExtendService;

    @Override
    public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page) {
        String sql = "";
        if (this.tmCustomerSearchExtendService != null) {
            sql = this.tmCustomerSearchExtendService.buildSearchSql(customerVo);
            if (StringUtil.isEmpty(sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
                sql = this.tmCustomerSearchExtendService.extendSearchSql(customerVo, sql);
            }
            List<TmCustomerVo> result = this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
            return this.tmCustomerSearchExtendService.afterSearch(result);
        }
        sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
        return this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
    }

    @Override
    public String saveTmCustomer(TmCustomerVo customerVo, Page page) {
        ArrayList<TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        ArrayList<TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        TmCustomerEntity tmCustomerEntity = null;
        String customerId = "";
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            try {
                this.tmCustomerExtendService.validate(customerVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(customerVo, page);
        }
        if (StringUtil.isEmpty(tmCustomerEntity)) {
            tmCustomerEntity = new TmCustomerVoToTmCustomerEntity(this, this.tmRCustPosBgDetailService, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(customerVo);
            customerId = tmCustomerEntity.getId();
        }
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
        }
        this.saveOrUpdate(tmCustomerEntity);
        if (StringUtil.isNotEmpty((String)tmCustomerEntity.getCooperative()) && tmCustomerEntity.getCooperative().equals("end")) {
            this.disableCustomerUser(tmCustomerEntity.getId());
        }
        this.executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL", new Object[0]);
        this.getSession().flush();
        this.saveBusinessGroupInfo(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty(this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
        }
        if (null != tmCustomerEntity) {
            return tmCustomerEntity.getId();
        }
        return null;
    }

    private void saveBusinessGroupInfo(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, key);
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode") continue;
                TmRCustPosBgDetailEntity entity = new TmRCustPosBgDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save(entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map<String, List<TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map<String, List<TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set<String> oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + CustomerLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + CustomerLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmCustomerEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmCustomerEntity tmCustomerEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + CustomerLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    private void disableCustomerUser(String customerId) {
        String sql = "UPDATE tm_user SET enable_status = 1 WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
        this.executeSql(sql, customerId);
    }

    @Override
    public AjaxJson deleteTmCustomer(String ids, Page page) {
        AjaxJson json = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] customerIds;
            ArrayList<String> customerCodeList = new ArrayList<String>();
            for (String customerId : customerIds = ids.split(",")) {
                TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
                if (this.tmCustomerDelExtendService != null) {
                    this.tmCustomerDelExtendService.validate(tmCustomerEntity, page);
                    this.tmCustomerDelExtendService.delBefore(tmCustomerEntity, page);
                }
                if (tmCustomerEntity == null || !StringUtil.isNotEmpty((String)tmCustomerEntity.getId())) continue;
                customerCodeList.add(tmCustomerEntity.getCustomerCode());
                this.delete(tmCustomerEntity);
                if (this.tmCustomerDelExtendService == null) continue;
                this.tmCustomerDelExtendService.delPost(tmCustomerEntity, page);
            }
            attributes.put("customerCodeList", customerCodeList);
        }
        json.setAttributes(attributes);
        return json;
    }

    @Override
    public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> list = this.findTmCustomerList(customerVo, null);
        return list.size() > 0 ? list.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustomerByPosList(customerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
    }

    @Override
    public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTpmCustomerList(customerVo, page);
    }

    @Override
    public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustomerDao.findCustomerLogList(tmLogVo, page);
    }

    @Override
    public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
    }

    @Override
    public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
        String sql = "SELECT DISTINCT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE FROM TM_CUSTOMER TC JOIN TM_R_CUST_POS_BG TRCP ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
        return this.findBySql(ComboBox.class, sql, positionId);
    }

    @Override
    public List<TmCustomerVo> findCustomer(String settlementCode, String customerType, String contractCode, String orgId) {
        return this.tmCustomerDao.findCustomer(settlementCode, customerType, contractCode, orgId);
    }

    @Override
    public TmCustomerVo findSapCustomer(String code) {
        List<TmCustomerVo> customerVoList = this.tmCustomerDao.findSapCustomer(code);
        return customerVoList != null && customerVoList.size() > 0 ? customerVoList.get(0) : new TmCustomerVo();
    }

    @Override
    public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page) {
        List<TmCustomerVo> voList = this.tmCustomerDao.findTmCustomerListByOrgMain(customerVo, page);
        return voList;
    }

    @Override
    public AjaxJson changeCustomerForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getCustomerIds())) {
            String[] customerIds;
            TmCustomerEntity tmCustomerEntity = null;
            TmOrgEntity tmOrgEntity = null;
            for (String posId : customerIds = tmOrgVo.getCustomerIds().split(",")) {
                tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)posId));
                if (!StringUtil.isNotEmpty(tmCustomerEntity)) continue;
                tmOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)tmOrgVo.getOrgId()));
                tmCustomerEntity.setTmOrg(tmOrgEntity);
                this.saveOrUpdate(tmCustomerEntity);
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }
}

