/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.importer.ImpInfo;
import com.biz.eisp.base.importer.ImportEnum;
import com.biz.eisp.base.importer.ImportMonitor;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ImportThreadWrapper
extends Thread
implements Importer,
ImportMonitor {
    public static final Log log = LogFactory.getLog((String)"ImportWrapper");
    public static final String STATE_RUNNING = "R";
    public static final String STATE_ERROR = "E";
    public static final String STATE_SUCCESS = "S";
    private Map<String, ImportMonitor> container;
    private String name;
    private Importer importer;
    private DataIterator iterator;
    private boolean test;
    private String impState;
    private ImpInfo impInfo;
    private String errInfo;
    private RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
    private HttpSession httpSession;
    private HttpServletResponse response;
    private boolean isDistributed;

    public ImportThreadWrapper(Importer importer, HttpSession httpSession, HttpServletResponse response, String key, boolean isDistributed) {
        this.importer = importer;
        this.httpSession = httpSession;
        this.response = response;
        this.name = key;
        this.isDistributed = isDistributed;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public String getImpState() {
        return this.impState;
    }

    @Override
    public ImpInfo getImpInfo() {
        return this.impInfo;
    }

    @Override
    public String getErrInfo() {
        return this.errInfo;
    }

    @Override
    public int getSize() {
        return this.importer.getIterator() != null ? this.importer.getIterator().getSize() : -1;
    }

    @Override
    public int getIndex() {
        return this.importer.getIterator() != null ? this.importer.getIterator().getIndex() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(HttpServletResponse response, String mess, boolean flag) {
        response.setContentType("text/html;charset=utf-8");
        JSONObject obj = new JSONObject();
        obj.put("success", (Object)flag);
        obj.put("result", (Object)true);
        obj.put("message", (Object)mess);
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.write(obj.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        RequestContextHolder.setRequestAttributes((RequestAttributes)this.attributes);
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtils.getContext().getBean("sessionFactory");
        RedisService redisService = null;
        if (this.isDistributed) {
            Object redis = ApplicationContextUtils.getContext().getBean("redisService");
            redisService = redis != null ? (RedisService)redis : null;
        }
        Session session = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            participate = true;
        } else {
            session = sessionFactory.openSession();
            session.setFlushMode(FlushMode.MANUAL);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
        }
        try {
            this.impState = STATE_RUNNING;
            ImpInfo info = null;
            if (this.isDistributed) {
                redisService.hset(this.name, ImportEnum.ImpState.getValue(), this.impState, 1800L);
            }
            info = this.test ? this.importer.test(this.iterator) : this.importer.imp(this.iterator, this.httpSession);
            this.impState = STATE_SUCCESS;
            this.impInfo = info;
            if (!this.isDistributed) return;
            redisService.hset(this.name, ImportEnum.ImpState.getValue(), this.impState, 1800L);
            redisService.hset(this.name, ImportEnum.ImpInfo.getValue(), JsonUtil.bean2json(this.impInfo), 1800L);
            return;
        }
        catch (Exception e) {
            this.impState = STATE_ERROR;
            this.errInfo = e.getMessage();
            if (this.isDistributed) {
                try {
                    redisService.hset(this.name, ImportEnum.ImpState.getValue(), this.impState, 1800L);
                    redisService.hset(this.name, ImportEnum.errInfo.getValue(), this.errInfo, 1800L);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (e instanceof ValidateException) return;
            e.printStackTrace();
            return;
        }
        finally {
            try {
                if (!participate) {
                    TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                    SessionFactoryUtils.closeSession((Session)session);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (!this.isDistributed) {
                        Thread.sleep(9000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.container != null) {
                        this.container.remove(this.name);
                        log.info((Object)("container remove; size: " + this.container.size()));
                    }
                }
            }
        }
    }

    @Override
    public ImpInfo imp(DataIterator iterator, HttpSession session) throws Exception {
        this.test = false;
        this.iterator = iterator;
        this.start();
        return this.impInfo;
    }

    @Override
    public ImpInfo test(DataIterator iterator) throws Exception {
        this.test = true;
        this.iterator = iterator;
        this.start();
        return null;
    }

    @Override
    public void template(HttpServletResponse response) throws Exception {
        this.importer.template(response);
    }

    @Override
    public DataIterator getIterator() {
        return this.importer.getIterator();
    }

    @Override
    public void toContainer(Map<String, ImportMonitor> container, String name) {
        this.container = container;
        this.name = name;
        container.put(name, this);
        log.info((Object)("container put; size: " + container.size()));
    }
}

