/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productInfo.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.mdm.productInfo.dao.TmProductInfoDao;
import com.biz.eisp.mdm.productInfo.entity.TmProductInfoEntity;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoService;
import com.biz.eisp.mdm.productInfo.transformer.TmProductInfoEntityToTmProductInfoVo;
import com.biz.eisp.mdm.productInfo.transformer.TmProductInfoVoToTmProductInfoEntity;
import com.biz.eisp.mdm.productInfo.vo.TmProductInfoVo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmProductInfoService")
@Transactional
public class TmProductInfoServiceImpl
extends BaseServiceImpl
implements TmProductInfoService {
    @Autowired
    private TmProductInfoDao tmProductInfoDao;

    @Override
    public String saveOrUpdateProductInfo(TmProductInfoVo ic) {
        UserRedis userRedis = UserUtils.getUser();
        Date date = new Date();
        TmProductInfoEntity icon = null;
        TmProductInfoVoToTmProductInfoEntity transForm = new TmProductInfoVoToTmProductInfoEntity(this);
        icon = transForm.apply(ic);
        if (StringUtil.isEmpty(icon.getId())) {
            icon.setCreateBy(userRedis.getUsername());
            icon.setCreateName(userRedis.getRealname());
            icon.setCreateDate(date);
        }
        icon.setUpdateBy(userRedis.getUsername());
        icon.setUpdateName(userRedis.getRealname());
        icon.setUpdateDate(date);
        this.saveOrUpdate(icon);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @Override
    public TmProductInfoVo getProductInfoById(String id) {
        TmProductInfoEntity ie = this.get(TmProductInfoEntity.class, (Serializable)((Object)id));
        if (ie != null) {
            TmProductInfoEntityToTmProductInfoVo trans = new TmProductInfoEntityToTmProductInfoVo(this);
            return trans.apply(ie);
        }
        return null;
    }

    @Override
    public List<TmProductInfoVo> findProductInfoMainGrid(TmProductInfoVo tmProductInfoVo, Page page) {
        return this.tmProductInfoDao.findTmProductInfoList(tmProductInfoVo, page);
    }

    @Override
    public List<TmProductInfoVo> getTmProductInfoList(TmProductInfoVo tmProductInfoVo) {
        return this.tmProductInfoDao.getTmProductInfoList(tmProductInfoVo);
    }

    @Override
    public AjaxJson delProductInfo(String ids) {
        String[] iconIds;
        AjaxJson j = new AjaxJson();
        for (String id : iconIds = ids.split(",")) {
            TmProductInfoEntity tmProductInfoEntity = this.get(TmProductInfoEntity.class, (Serializable)((Object)id));
            if (tmProductInfoEntity == null) {
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                j.setSuccess(false);
                return j;
            }
            this.delete(tmProductInfoEntity);
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }

    @Override
    public AjaxJson startOrStop(TmProductInfoVo tmProductInfoVo) {
        AjaxJson j = new AjaxJson();
        TmProductInfoEntity tmProductInfoEntity = this.get(TmProductInfoEntity.class, (Serializable)((Object)tmProductInfoVo.getId()));
        if (StringUtil.isNotEmpty(tmProductInfoEntity)) {
            if (tmProductInfoEntity.getEnableStatus().toString().equals(tmProductInfoVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmProductInfoVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmProductInfoEntity.setEnableStatus(tmProductInfoVo.getEnableStatus());
                this.updateEntity(tmProductInfoEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

