-- Create table
create table TA_COMMUNICATE
(
  ID                           VARCHAR2(32) not null,
  BUSINESS_KEY                 VARCHAR2(32),
  PROCESS_INSTANCE_ID          VARCHAR2(32),
  PROCESS_NAME                 VARCHAR2(128),
  PROCESS_KEY                  VARCHAR2(32),
  PROCESS_TITLE                VARCHAR2(100),
  LAUNCH_CODE                  VARCHAR2(50),
  LAUNCH_NAME                  VARCHAR2(50),
  CREATE_DATE                  TIMESTAMP(6),
  CREATE_NAME                  VARCHAR2(50),
  UPDATE_DATE                  TIMESTAMP(6),
  UPDATE_NAME                  VARCHAR2(50),
  CREATE_PROCESS_POSITION_NAME VARCHAR2(50),
  CREATE_PROCESS_POSITION_CODE VARCHAR2(50)
);
-- Add comments to the columns
comment on column TA_COMMUNICATE.ID
  is '逻辑主键';
comment on column TA_COMMUNICATE.BUSINESS_KEY
  is '业务主键';
comment on column TA_COMMUNICATE.PROCESS_INSTANCE_ID
  is '实例主键';
comment on column TA_COMMUNICATE.PROCESS_NAME
  is '流程名称';
comment on column TA_COMMUNICATE.PROCESS_KEY
  is '流程key';
comment on column TA_COMMUNICATE.PROCESS_TITLE
  is '单据名称';
comment on column TA_COMMUNICATE.LAUNCH_CODE
  is '沟通发起人职位编码';
comment on column TA_COMMUNICATE.LAUNCH_NAME
  is '沟通发起人职位名称';
comment on column TA_COMMUNICATE.CREATE_PROCESS_POSITION_NAME
  is '流程创建人职位名称';
comment on column TA_COMMUNICATE.CREATE_PROCESS_POSITION_CODE
  is '流程创建人职位编码';

create table TA_COMMUNICATE_CONTENT
(
  ID                VARCHAR2(32) not null,
  TA_COMMUNICATE_ID VARCHAR2(32),
  CIRCULATION_CODE  VARCHAR2(32),
  CIRCULATION_NAME  VARCHAR2(50),
  CONTENT           VARCHAR2(500),
  RECIVE_CONTENT    VARCHAR2(500),
  VIEW_STATUS       VARCHAR2(5),
  READ_STATUS       VARCHAR2(5),
  IS_REPLY          VARCHAR2(5),
  CREATE_DATE       TIMESTAMP(6),
  CREATE_NAME       VARCHAR2(50),
  UPDATE_DATE       TIMESTAMP(6),
  UPDATE_NAME       VARCHAR2(50)
);
-- Add comments to the columns
comment on column TA_COMMUNICATE_CONTENT.ID
  is '逻辑主键';
comment on column TA_COMMUNICATE_CONTENT.TA_COMMUNICATE_ID
  is '沟通主表';
comment on column TA_COMMUNICATE_CONTENT.CIRCULATION_CODE
  is '沟通接收编码';
comment on column TA_COMMUNICATE_CONTENT.CIRCULATION_NAME
  is '沟通接收名称';
comment on column TA_COMMUNICATE_CONTENT.CONTENT
  is '内容';
comment on column TA_COMMUNICATE_CONTENT.RECIVE_CONTENT
  is '返回内容';
comment on column TA_COMMUNICATE_CONTENT.VIEW_STATUS
  is '查阅状态';
comment on column TA_COMMUNICATE_CONTENT.READ_STATUS
  is '阅读状态';
comment on column TA_COMMUNICATE_CONTENT.IS_REPLY
  is '是否可以回复';

-- Alter table
alter table TA_COMMUNICATE
  storage
  (
    next 1
  )
;
-- Add/modify columns
alter table TA_COMMUNICATE add process_node_key VARCHAR2(50);
alter table TA_COMMUNICATE add task_id VARCHAR2(50);
alter table TA_COMMUNICATE add process_node_name VARCHAR2(200);
alter table TA_COMMUNICATE add task_name VARCHAR2(200);
-- Add comments to the columns
comment on column TA_COMMUNICATE.process_node_key
  is '流程节点key';
comment on column TA_COMMUNICATE.task_id
  is '任务id';
comment on column TA_COMMUNICATE.process_node_name
  is '流程节点名称';
comment on column TA_COMMUNICATE.task_name
  is '任务名称';