/***********************************************************************************/
/***********************************************************************************/
/************************行政区域管理脚本********************************************/
/******************************注意要修改配置数据相关信息*****************************************************/
/***********************************************************************************/

-- 创建表结构
create table TM_ADMINISTRATIVE_AREA
(
  ID            VARCHAR2(32) not null,
  NAME          VARCHAR2(50),
  PARENT_ID     VARCHAR2(32),
  SHORT_NAME    VARCHAR2(50),
  AREA_LEVEL    NUMBER,
  CITY_CODE     VARCHAR2(10),
  ZIP_CODE      VARCHAR2(10),
  REMARK        VARCHAR2(100),
  CREATE_DATE   TIMESTAMP(6),
  CREATE_NAME   VARCHAR2(50),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_NAME   VARCHAR2(50),
  ENABLE_STATUS NUMBER(1) default 0,
  IS_SYSTEM     NUMBER,
  CODE          VARCHAR2(50),
  SUB_CODE      VARCHAR2(50),
  IS_LEAF       NUMBER,
  EXT_CHAR_1    VARCHAR2(100),
  EXT_CHAR_2    VARCHAR2(100),
  EXT_CHAR_3    VARCHAR2(100),
  EXT_CHAR_4    VARCHAR2(100),
  EXT_NUMBER_1  NUMBER,
  EXT_NUMBER_2  NUMBER,
  EXT_NUMBER_3  NUMBER
)
tablespace USERS
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 64
    next 8
    minextents 1
    maxextents unlimited
  );
-- Add comments to the table 
comment on table TM_ADMINISTRATIVE_AREA
  is '业务区域表';
-- Add comments to the columns 
comment on column TM_ADMINISTRATIVE_AREA.ID
  is '逻辑主键ID';
comment on column TM_ADMINISTRATIVE_AREA.NAME
  is '区域名称';
comment on column TM_ADMINISTRATIVE_AREA.PARENT_ID
  is '上级区域ID，对应TM_ADMINISTRATIVE_AREA表id字段';
comment on column TM_ADMINISTRATIVE_AREA.SHORT_NAME
  is '名称简写';
comment on column TM_ADMINISTRATIVE_AREA.AREA_LEVEL
  is '区域层级';
comment on column TM_ADMINISTRATIVE_AREA.CITY_CODE
  is '城市编码';
comment on column TM_ADMINISTRATIVE_AREA.ZIP_CODE
  is '邮编';
comment on column TM_ADMINISTRATIVE_AREA.REMARK
  is '备注说明';
comment on column TM_ADMINISTRATIVE_AREA.CREATE_DATE
  is '创建时间';
comment on column TM_ADMINISTRATIVE_AREA.CREATE_NAME
  is '创建用户账号，对应tm_user表中的username字段值';
comment on column TM_ADMINISTRATIVE_AREA.UPDATE_DATE
  is '修改时间';
comment on column TM_ADMINISTRATIVE_AREA.UPDATE_NAME
  is '修改用户账号，对应tm_user表中的username字段值';
comment on column TM_ADMINISTRATIVE_AREA.ENABLE_STATUS
  is '状态';
comment on column TM_ADMINISTRATIVE_AREA.IS_SYSTEM
  is '系统值，0：是，其他否';
comment on column TM_ADMINISTRATIVE_AREA.CODE
  is '区域编码';
comment on column TM_ADMINISTRATIVE_AREA.SUB_CODE
  is '树形分段编码';
comment on column TM_ADMINISTRATIVE_AREA.IS_LEAF
  is '是否叶子节点0不是，1是';
comment on column TM_ADMINISTRATIVE_AREA.EXT_CHAR_1
  is '字符串类型（length=100）-扩展字段1';
comment on column TM_ADMINISTRATIVE_AREA.EXT_CHAR_2
  is '字符串类型（length=100）-扩展字段2';
comment on column TM_ADMINISTRATIVE_AREA.EXT_CHAR_3
  is '字符串类型（length=100）-扩展字段3';
comment on column TM_ADMINISTRATIVE_AREA.EXT_CHAR_4
  is '字符串类型（length=100）-扩展字段4';
comment on column TM_ADMINISTRATIVE_AREA.EXT_NUMBER_1
  is '数字-扩展字段1';
comment on column TM_ADMINISTRATIVE_AREA.EXT_NUMBER_2
  is '数字-扩展字段2';
comment on column TM_ADMINISTRATIVE_AREA.EXT_NUMBER_3
  is '数字-扩展字段3';
-- Create/Recreate primary, unique and foreign key constraints 
alter table TM_ADMINISTRATIVE_AREA
  add primary key (ID)
  using index 
  tablespace USERS
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
  
  
--建立配置数据
INSERT INTO tm_mdm_table_config (
  ID,
  TABLE_NAME,
  COLUMN_NAME,
  COLUMN_DESC,
  COLUMN_TYPE,
  FIELD,
  JOIN_TABLE,
  ALIAS,
  JOIN_TYPE,
  JOIN_ON,
  JOIN_COLUMN,
  SHOW_COLUMN,
  FIELD_NAME,
  FIELD_PROPERTY,
  IS_HIDDEN,
  FORMAT,
  COLUMN_ORDER,
  QUERY_STATUS,
  QUERY_MODE,
  DICT_TYPE,
  IMPORT_OUT,
  FORM_NAME,
  ADD_SHOW_MODE,
  FORM_TYPE,
  FORM_ORDER,
  FORM_URL,
  DATA_TYPE,
  ERROR_MSG,
  REQUIRED,
  UPDATE_SHOW_MODE,
  IMPORT_FIELD,
  INPUT_MSG,
  FORM_EXTEND,
  FORM_FORMAT
)
SELECT  
  lower(sys_guid()) AS ID,
  'TM_ADMINISTRATIVE_AREA' AS TABLE_NAME,
  COLUMN_NAME,
  COLUMN_DESC,
  COLUMN_TYPE,
  FIELD,
  JOIN_TABLE,
  ALIAS,
  JOIN_TYPE,
  JOIN_ON,
  JOIN_COLUMN,
  SHOW_COLUMN,
  FIELD_NAME,
  FIELD_PROPERTY,
  IS_HIDDEN,
  FORMAT,
  COLUMN_ORDER,
  QUERY_STATUS,
  QUERY_MODE,
  DICT_TYPE,
  IMPORT_OUT,
  FORM_NAME,
  ADD_SHOW_MODE,
  FORM_TYPE,
  FORM_ORDER,
  FORM_URL,
  DATA_TYPE,
  ERROR_MSG,
  REQUIRED,
  UPDATE_SHOW_MODE,
  IMPORT_FIELD,
  INPUT_MSG,
  FORM_EXTEND,
  FORM_FORMAT
FROM tm_mdm_table_config WHERE table_name = 'TM_BUSINESS_AREA';

UPDATE tm_mdm_table_config SET field = 'administrativeAreaCode' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET field = 'administrativeAreaName' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'NAME';
UPDATE tm_mdm_table_config SET join_table = 'tm_administrative_area' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'PARENT_ID';
UPDATE tm_mdm_table_config SET field_property = 'administrativeAreaCode' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET form_url = 'ajaxurl=tmAdministrativeAreaController.do?validateAdministrativeAreaCode#administrativeAreaCode=${administrativeAreaCode}#id=${id}' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET form_url = 'tmAdministrativeAreaController.do?findTmAdministrativeAreaComboTree' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'PARENT_ID';
UPDATE tm_mdm_table_config SET form_url = 'ajaxurl=tmAdministrativeAreaController.do?validateAdministrativeAreaName#administrativeAreaName=${administrativeAreaName}#id=${id}' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'NAME';
UPDATE tm_mdm_table_config SET form_extend = 'ajaxurl=tmAdministrativeAreaController.do?validateAdministrativeAreaName#administrativeAreaName=${administrativeAreaName}#id=${id}' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET form_extend = 'ajaxurl=tmAdministrativeAreaController.do?validateAdministrativeAreaName#administrativeAreaName=${administrativeAreaName}#id=${id}' WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'NAME';

UPDATE tm_mdm_table_config SET form_url = REPLACE(form_url, '#' ,'&') WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET form_url = REPLACE(form_url, '#' ,'&') WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'PARENT_ID';
UPDATE tm_mdm_table_config SET form_url = REPLACE(form_url, '#' ,'&') WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'NAME';
UPDATE tm_mdm_table_config SET form_extend = REPLACE(form_extend, '#' ,'&') WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'CODE';
UPDATE tm_mdm_table_config SET form_extend = REPLACE(form_extend, '#' ,'&') WHERE table_name = 'TM_ADMINISTRATIVE_AREA' AND column_name = 'NAME';


--建立主数据配置
UPDATE tm_dict_data SET dict_value = '业务区域' WHERE dict_code = 'TM_BUSINESS_AREA' AND dict_type_code = 'table_name';
INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'TM_ADMINISTRATIVE_AREA', '行政区域', '行政区域',NULL,'table_name',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

--复制业务区域数据到行政区域数据中
CREATE TABLE tt_temp_business_area AS
SELECT lower(sys_guid()) newid, ID AS oldid FROM TM_BUSINESS_AREA;

INSERT INTO tm_administrative_area (
 ID,
  NAME,
  PARENT_ID,
  SHORT_NAME,
  AREA_LEVEL,
  CITY_CODE,
  ZIP_CODE,
  REMARK,
  CREATE_DATE,
  CREATE_NAME,
  UPDATE_DATE,
  UPDATE_NAME,
  ENABLE_STATUS,
  IS_SYSTEM,
  CODE,
  SUB_CODE,
  IS_LEAF,
  EXT_CHAR_1,
  EXT_CHAR_2,
  EXT_CHAR_3,
  EXT_CHAR_4,
  EXT_NUMBER_1,
  EXT_NUMBER_2,
  EXT_NUMBER_3
)
SELECT 
  t1.newid AS ID,
  NAME,
  PARENT_ID,
  SHORT_NAME,
  AREA_LEVEL,
  CITY_CODE,
  ZIP_CODE,
  REMARK,
  CREATE_DATE,
  CREATE_NAME,
  UPDATE_DATE,
  UPDATE_NAME,
  ENABLE_STATUS,
  IS_SYSTEM,
  CODE,
  SUB_CODE,
  IS_LEAF,
  EXT_CHAR_1,
  EXT_CHAR_2,
  EXT_CHAR_3,
  EXT_CHAR_4,
  EXT_NUMBER_1,
  EXT_NUMBER_2,
  EXT_NUMBER_3
FROM TM_BUSINESS_AREA a
 INNER JOIN tt_temp_business_area t1 ON t1.oldid = a.id;
 

UPDATE tm_administrative_area a SET a.parent_id = (SELECT newid FROM tt_temp_business_area t WHERE t.oldid = a.parent_id)
WHERE EXISTS  (SELECT newid FROM tt_temp_business_area t WHERE t.oldid = a.parent_id);

DROP TABLE tt_temp_business_area;
