/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.iterator;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelDataIterator
implements DataIterator {
    private Sheet sheet;
    private int rows = -1;
    private int index;
    private List<DataField> dataFieldList;

    public ExcelDataIterator(InputStream is, int sheetIndex, List<DataField> dataFieldList) throws Exception {
        this.sheet = Workbook.getWorkbook((InputStream)is).getSheet(sheetIndex);
        this.rows = this.sheet.getRows();
        this.index = 0;
        this.dataFieldList = dataFieldList;
    }

    private void verifySheetRowsNum() {
        for (int i = 0; i < this.sheet.getRows(); ++i) {
            int isEmptyCount = 0;
            for (Cell cc : this.sheet.getRow(i)) {
                if (cc.getContents() != "") continue;
                ++isEmptyCount;
            }
            if (isEmptyCount != this.sheet.getRow(i).length) continue;
            --this.rows;
        }
    }

    public ExcelDataIterator(InputStream is) throws Exception {
        this(is, 0, null);
    }

    public boolean hasNext() {
        return this.index < this.rows;
    }

    public Map<String, Object> next() {
        Cell[] cells = this.sheet.getRow(this.index++);
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        for (int m = 0; m < cells.length; ++m) {
            String dictCode;
            String valueStr;
            String value = cells[m].getContents().trim();
            if (this.dataFieldList.size() <= m) continue;
            DataField dataField = (DataField)this.dataFieldList.get(m);
            String code = dataField.getCode();
            if (StringUtil.isNotEmpty((String)value) && dataField != null && StringUtil.isNotEmpty((String)dataField.getDictCode()) && StringUtil.isNotEmpty((String)(valueStr = DictUtil.getDicDataValByCode((String)(dictCode = dataField.getDictCode()), (String)value)))) {
                value = valueStr;
            }
            if (StringUtil.isNotEmpty((String)dataField.getFormat())) {
                boolean flag = false;
                flag = dataField.getFormat().length() > 10 ? DateUtils.isValidDateTime((String)value) : (dataField.getFormat().length() > 7 ? DateUtils.isValidDate((String)value) : DateUtils.isValidMoth((String)value));
                if (flag) {
                    rowMap.put(code, DateUtils.parse((String)value, (String)dataField.getFormat()));
                    continue;
                }
                rowMap.put(code, value);
                continue;
            }
            rowMap.put(code, value);
        }
        return rowMap;
    }

    public void remove() {
    }

    public int getIndex() {
        return this.index;
    }

    public int getRowNumber() {
        return this.index;
    }

    public int getSize() {
        return this.rows;
    }
}

