/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.service;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TmUserEventHandler
extends ImpEventHandler<TmUserVo> {
    private static String positionCodePartTemp = "positionCodePart";
    private TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");

    public void validate(Map<String, Object> row) throws ValidateException {
        Object positionCodePart;
        List list = (List)DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : list) {
            String hql;
            List result;
            Object fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData((TmMdmTableConfigEntity)tableConfig, (Object)(fieldValue = row.get(tableConfig.getField())), row);
            if (StringUtil.isNotEmpty((String)errorMsg)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
            }
            if (!StringUtil.equals((String)"userName", (String)tableConfig.getField()) || (result = this.tmUserService.findByHql(hql = " from TmUserEntity where userType=0 and userName=?", new Object[]{fieldValue})) == null || result.size() <= 0) continue;
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u767b\u5f55\u8d26\u53f7" + fieldValue + "\u5df2\u5b58\u5728\u6216\u51fa\u73b0\u91cd\u590d");
        }
        Object positionObj = row.get("positionId");
        if (StringUtil.isNotEmpty((Object)positionObj)) {
            String positionId = positionObj.toString();
            Map params = this.getParams();
            if (params.containsKey(positionId)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u548c\u7b2c" + params.get(positionId) + "\u884c\u804c\u4f4d\u91cd\u590d");
            } else {
                params.put(positionId, this.getRowNumber());
            }
            String sql = "SELECT COUNT(1) FROM TM_POSITION WHERE POSITION_CODE=? AND ENABLE_STATUS=?";
            long count = this.tmUserService.getCountForJdbcParam(sql, new Object[]{positionId, Globals.ZERO});
            if (count == 0L) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e3b\u804c\u4f4d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            } else {
                String userSql = "SELECT COUNT(1) FROM TM_R_USER_POSITION WHERE POSITION_ID=?";
                TmPositionEntity entity = (TmPositionEntity)this.tmUserService.findUniqueByProperty(TmPositionEntity.class, "positionCode", (Object)positionId);
                count = this.tmUserService.getCountForJdbcParam(userSql, new Object[]{entity.getId()});
                if (count > 0L) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e3b\u804c\u4f4d\u5df2\u7ecf\u88ab\u4f7f\u7528");
                } else {
                    row.put("positionId", entity.getId());
                }
            }
        }
        if ((positionCodePart = row.get(positionCodePartTemp)) != null && StringUtil.isNotBlank((String)positionCodePart.toString())) {
            if (positionObj != null && StringUtil.isNotBlank((String)positionObj.toString()) && StringUtil.equals((String)positionObj.toString(), (String)positionCodePart.toString())) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e3b\u804c\u4f4d\u4e0e\u517c\u804c\u7f16\u7801\u76f8\u540c");
                row.remove(positionCodePartTemp);
            } else {
                String[] positionCodeParts = positionCodePart.toString().split(",");
                StringBuffer stringBuffer = new StringBuffer();
                for (String codePart : positionCodeParts) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append("'").append(codePart).append("'");
                        continue;
                    }
                    stringBuffer.append(",'").append(codePart).append("'");
                }
                String sqlTemp = " select id,POSITION_CODE from TM_POSITION where POSITION_CODE in (" + stringBuffer.toString() + ") ";
                List positionEntities = this.tmUserService.findBySql(TmPositionEntity.class, sqlTemp, new Object[0]);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntities) && positionEntities.size() != positionCodeParts.length) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c," + positionCodePart.toString() + "\u804c\u4f4d\u4e0d\u5b58\u5728");
                    row.remove(positionCodePartTemp);
                } else {
                    StringBuffer stringBuffer1 = new StringBuffer();
                    positionEntities.forEach(item -> {
                        if (stringBuffer1.length() == 0) {
                            stringBuffer1.append(item.getId());
                        } else {
                            stringBuffer1.append(",").append(item.getId());
                        }
                    });
                    row.put(positionCodePartTemp, stringBuffer1.toString());
                }
            }
        }
    }

    public void endRow(Map<String, Object> row, TmUserVo bean) throws ValidateException {
        try {
            if (StringUtil.isEmpty((String)bean.getPassword())) {
                bean.setPassword("123456");
            }
            bean.setUserType(Globals.ENTERPRISE_USER);
            String mainPositionId = bean.getPositionId();
            if (StringUtil.isNotEmpty((String)mainPositionId)) {
                ArrayList<TmPositionVo> tmUserPositionList = new ArrayList<TmPositionVo>();
                TmPositionVo tmPositionVo = new TmPositionVo();
                tmPositionVo.setId(mainPositionId);
                tmPositionVo.setIsMain("0");
                tmUserPositionList.add(tmPositionVo);
                if (row.containsKey(positionCodePartTemp) && row.get(positionCodePartTemp) != null) {
                    String[] posIds;
                    for (String id : posIds = row.get(positionCodePartTemp).toString().split(",")) {
                        TmPositionVo temp = new TmPositionVo();
                        temp.setId(id);
                        temp.setIsMain("1");
                        tmUserPositionList.add(temp);
                    }
                }
                bean.setPositionJson(JSONArray.toJSONString(tmUserPositionList));
            }
            this.tmUserService.saveTmUser(bean, null);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }
}

