<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="product_info_List" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid actionUrl="tmWarePositionController.do?findWarePositionMainGrid" idField="id" fitColumns="false"
                     name="wareList" queryMode="group">
            <t:dgCol field="positionCode" title="职位编码" sortable="true" query="true"></t:dgCol>
            <t:dgCol field="positionName" title="职位名称"  query="true"></t:dgCol>
            <t:dgCol field="wareCode" title="商品编码" sortable="true" query="true"></t:dgCol>
            <t:dgCol field="wareName" title="商品名称" sortable="true" query="true"></t:dgCol>
            <t:dgCol field="fullname" title="用户名" sortable="true" query="true"></t:dgCol>
            <t:dgCol field="createName" title="创建人" sortable="true" query="true"></t:dgCol>
            <t:dgToolBar title="新增" operationCode="add" url="tmWarePositionController.do?goSaveOrUpdateForm" icon="icon-add" funname="add" width="380" height="200"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" url="tmWarePositionController.do?goSaveOrUpdateForm" icon="icon-edit" funname="update" width="380" height="200"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" url="tmWarePositionController.do?goSaveOrUpdateForm" icon="icon-edit" funname="detail"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmWarePositionController.do?delWarePosition" funname="deleteALLSelect3"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmWarePosition', gridName:'warePositionList'})" ></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmWarePositionController.do?exportXls" funname="excelExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log"  icon="icon-log" url="tmLogController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
        </t:datagrid>

    </div>
</div>
<script>

    //删除
    function deleteALLSelect3(title, url){
        var rowsData = $('#wareList').datagrid('getSelections');
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        var ids = [];
        var rows = $('#wareList').datagrid('getSelections');
        if(rows.length > 0){
            $.dialog.confirm('是否删除选中数据？',function(r){
                if(r){
                    for(var i = 0; i < rows.length; i++){
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url:url,
                        type:'post',
                        data:{
                            ids:ids.join(',')
                        },
                        cache:false,
                        success:function(data){
                            var d = data;
                            var msg = d.msg;
                            if(d.success){
                                tip(msg);
                                for(var i = 0;i<rows.length ;i++){
                                    var index = $('#wareList').datagrid('getRowIndex',rows[i]);
                                    $("#wareList").datagrid('deleteRow',index);
                                }
                                ids='';
                            }else{
                                tip(msg);
                                return;
                            }
                        }
                    });
                }
            });
        }else{
            tip("请选择要删除的数据！");
        }
    }
</script>