/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.transformer.TmFunctionEntityToTmFunctionVo;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/functionController"})
public class TmFunctionController
extends BaseController {
    @Autowired
    private TmFunctionService tmFunctionService;

    @RequestMapping(params={"goFunctionMain"})
    public ModelAndView goFunctionMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/function/functionMain");
    }

    @RequestMapping(params={"goFunctionSelect"})
    public ModelAndView goFunctionSelect(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/function/functionSelect");
    }

    @RequestMapping(params={"goFunctionForm"})
    public ModelAndView goFunctionForm(HttpServletRequest request, TmFunctionEntity tmFunctionEntity) {
        if (StringUtil.isNotEmpty((String)tmFunctionEntity.getId())) {
            TmFunctionVo functionVo = new TmFunctionEntityToTmFunctionVo(this.tmFunctionService).apply(tmFunctionEntity);
            request.setAttribute("function", (Object)functionVo);
        }
        List<KnlDictDataEntity> dictDatas = DictUtil.getDictList("function_module");
        request.setAttribute("moduleList", dictDatas);
        List<TmIconEntity> iconlist = this.tmFunctionService.findByProperty(TmIconEntity.class, "iconType", 10);
        request.setAttribute("iconlist", iconlist);
        return new ModelAndView("com/biz/eisp/mdm/function/functionForm");
    }

    @RequestMapping(params={"functionGrid"})
    @ResponseBody
    public List<TreeGrid> functionGrid(HttpServletRequest request, TreeGrid treegrid) {
        return this.tmFunctionService.getFunctionsList(request, treegrid);
    }

    @RequestMapping(params={"getFunctionTree"})
    @ResponseBody
    public List<ComboTree> getFunctionTree(HttpServletRequest request, ComboTree comboTree) {
        return this.tmFunctionService.getFunctionForComboTree(request, comboTree);
    }

    @RequestMapping(params={"saveFunction"})
    public void saveFunction(HttpServletRequest request, HttpServletResponse response, TmFunctionVo functionVo) {
        try {
            this.tmFunctionService.saveFunction(functionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
        }
        this.sendResponse(response);
    }

    @RequestMapping(params={"deleteFunction"})
    @ResponseBody
    public JSONObject deleteFunction(HttpServletRequest request, HttpServletResponse response, String functionId) {
        try {
            this.tmFunctionService.deleteFunction(functionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
        }
        return this.returnJson();
    }
}

