/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.service.TmTerminalApprovalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalFormExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalMainExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmTerminalController"})
public class TmTerminalController
extends BaseController {
    @Autowired
    private TmTerminalService tmTerminalService;
    @Autowired
    private TmTermCustPostService tmTermCustPostService;
    @Autowired(required=false)
    private TmTerminalFormExtendService tmTerminalFormExtendService;
    @Autowired(required=false)
    private TmTerminalMainExtendService tmTerminalMainExtendService;
    @Autowired(required=false)
    private TmTerminalApprovalExtendService tmTerminalApprovalExtendService;

    @RequestMapping(params={"goTmTerminalMain"})
    public ModelAndView goTmTerminalMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_TERMINAL);
        if (this.tmTerminalMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmTerminalMainExtendService.includeJsp());
        }
        request.setAttribute("clickFunctionId", (Object)request.getParameter("clickFunctionId"));
        return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalMain");
    }

    @RequestMapping(params={"goTerminalSearch"})
    public ModelAndView goTerminalSearch(TmTerminalVo terminalVo, String singleSelect, String searchUrl) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalSearchMain");
        view.addObject("extendTableName", (Object)Globals.TABLE_TERMINAL);
        view.addObject("vo", (Object)terminalVo);
        if (StringUtil.isEmpty((String)searchUrl)) {
            searchUrl = "tmTerminalController.do?findTmTerminalBySearchList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(params={"goTmTerminal"})
    public ModelAndView goTmTerminal(TmTerminalVo terminalVo, HttpServletRequest request, HttpServletResponse response) {
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        if (StringUtil.isNotEmpty((String)terminalVo.getId())) {
            terminalVo = this.tmTerminalService.getTmTerminal(terminalVo, null);
            request.setAttribute(Globals.TABLE_TERMINAL, (Object)terminalVo);
            TmTermCustPostVo tmTermCust = new TmTermCustPostVo();
            tmTermCust.setTerminalId(terminalVo.getId());
            List custPostList = this.tmTermCustPostService.findTmTermCustPostList(tmTermCust, null);
            request.setAttribute("custPostList", (Object)custPostList);
        }
        request.setAttribute("extendTableName", (Object)Globals.TABLE_TERMINAL);
        if (this.tmTerminalFormExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmTerminalFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalForm");
    }

    @RequestMapping(params={"goTerminalCust"})
    public ModelAndView goTerminalCust(HttpServletRequest request) {
        String terminalId = request.getParameter("terminalId");
        request.setAttribute("terminalId", (Object)terminalId);
        return new ModelAndView("com/biz/eisp/mdm/tmTerminal/terminalCust");
    }

    @RequestMapping(params={"findTmTerminalList"})
    @ResponseBody
    public DataGrid findTmTerminalList(TmTerminalVo terminalVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, (Page)page, request.getParameter("clickFunctionId"), Boolean.valueOf(false));
        return new DataGrid(terminalList, (Page)page);
    }

    @RequestMapping(params={"findTmTerminalBySearchList"})
    @ResponseBody
    public DataGrid findTmTerminalBySearchList(TmTerminalVo terminalVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = new ArrayList();
        try {
            if (StringUtil.isNotEmpty((String)terminalVo.getSearchParam())) {
                terminalVo.setTerminalName(terminalVo.getSearchParam());
            }
            terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, (Page)page, "", Boolean.valueOf(false));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7ec8\u7aef\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        return new DataGrid(terminalList, (Page)page);
    }

    @RequestMapping(params={"getTerminalBySearchList"})
    @ResponseBody
    public AjaxJson getTerminalBySearchList(TmTerminalVo terminalVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        EuPage page = new EuPage(request);
        try {
            if (StringUtil.isNotEmpty((String)terminalVo.getSearchParam())) {
                terminalVo.setTerminalName(terminalVo.getSearchParam());
            }
            List terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, (Page)page, "", Boolean.valueOf(false));
            map.put("totle", terminalList.size());
            j.setObj((Object)terminalList);
        }
        catch (Exception e) {
            j.setSuccess(false);
            map.put("totle", 0);
            e.printStackTrace();
        }
        j.setAttributes(map);
        return j;
    }

    @RequestMapping(params={"findTmTerminalByPosList"})
    @ResponseBody
    public DataGrid findTmTerminalByPosList(TmTerminalVo terminalVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List terminalList = this.tmTerminalService.findTmTerminalByPosList(terminalVo, (Page)page);
        return new DataGrid(terminalList, (Page)page);
    }

    @RequestMapping(params={"saveTmTerminal"})
    public void saveTmTerminal(TmTerminalVo terminalVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        this.tmTerminalService.saveTmTerminal(terminalVo, (Page)page);
        super.sendResponse(response);
    }

    @RequestMapping(params={"deleteTmTerminal"})
    @ResponseBody
    public AjaxJson deleteTmTerminal(String ids, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmTerminalService.deleteTmTerminal(ids, (Page)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return ajaxJson;
    }

    @RequestMapping(params={"doApprovalTerminal"})
    @ResponseBody
    public AjaxJson doApprovalTerminal(String ids, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (this.tmTerminalApprovalExtendService != null) {
                this.tmTerminalApprovalExtendService.examineAndApprove(ids);
            } else {
                ajaxJson.setMsg("\u672a\u627e\u5230\u7ec8\u7aef\u5ba1\u6279\u63a5\u53e3tmTerminalApprovalExtendService\u5b9e\u73b0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u63d0\u4ea4\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(params={"findAppravalDetail"})
    @ResponseBody
    public DataGrid findAppravalDetail(String terminalId, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        if (this.tmTerminalApprovalExtendService != null) {
            return this.tmTerminalApprovalExtendService.findAppravalDetail(terminalId, request, (Page)page);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(params={"goAppravalDetail"})
    public ModelAndView goAppravalDetail(String terminalId, HttpServletRequest request) {
        if (this.tmTerminalApprovalExtendService != null) {
            return this.tmTerminalApprovalExtendService.goAppravalDetail(terminalId, request);
        }
        throw new BusinessException("\u672a\u627e\u5230\u7ec8\u7aef\u5ba1\u6279\u63a5\u53e3tmTerminalApprovalExtendService\u5b9e\u73b0");
    }

    @RequestMapping(params={"goTmLogDetailMain"})
    public ModelAndView goTmLogDetailMain(HttpServletRequest request) {
        String businessId = request.getParameter("id");
        request.setAttribute("actionUrl", (Object)("tmTerminalController.do?findTmLogList&businessId=" + businessId));
        return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
    }

    @RequestMapping(params={"findTmLogList"})
    public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List tmLogList = this.tmTerminalService.findTerminalLogList(tmLogVo, (Page)page);
        this.datagridReturn(response, tmLogList, (Page)page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmTerminalVo terminalVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        page.setRows("50000");
        List terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, (Page)page, request.getParameter("clickFunctionId"), Boolean.valueOf(true));
        this.doExportXls(response, request, (Collection)terminalList, TmTerminalVo.class, "\u7ec8\u7aef\u5217\u8868");
    }

    @RequestMapping(params={"validateTerminalName"})
    @ResponseBody
    public ValidForm validateTerminalName(HttpServletRequest request, TmTerminalVo terminalVo) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)terminalVo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"terminalName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)terminalVo.getId());
            List tmTerminals = this.tmTerminalService.findByCriteria(TmTerminalEntity.class, new Criterion[]{cr1, cr2});
            if (!CollectionUtils.isEmpty((Collection)tmTerminals)) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec8\u7aef\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            List tmTerminals = this.tmTerminalService.findByProperty(TmTerminalEntity.class, "terminalName", (Object)param);
            if (!CollectionUtils.isEmpty((Collection)tmTerminals)) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec8\u7aef\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(params={"startOrStop"})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmTerminalVo tmTerminalVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmTerminalService.startOrStop(tmTerminalVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }
}

