<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<style>
	.combo {
		width:auto!important;
		height:auto!important;
		border:.5px solid #d2d2d2!important;
		border-radius: 4px;
	}
    .combo .combo-text{
		width: 96pt!important;
		border: 0!important;
	}
	.combo-arrow{
		height: 24px!important;
		background-color: #e2e2e2;
		background-image: none;
		position: relative;
	}
	.combo-arrow:after{
		position: absolute;
		content: "";
		width: 0;
		height:0;
		border-color: #aaa transparent transparent transparent;
		border-style: solid;
		border-width: 5px;
		top: 10px;
		left: 5px;
	}
</style>

<div id="tmPositionMain" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="tmPositionList" fitColumns="true"   queryMode = "group" extendTableName="${extendTableName }"
	    actionUrl="tmPositionController.do?findTmPositionList&orgId=${orgId }&clickFunctionId=${clickFunctionId}" idField="id">
	    
			<t:dgCol title="上级组织" field="parentOrgName" width="100"  columnOrder="7"></t:dgCol>
			<t:dgCol title="登录账号" field="userName" width="100"  query="true" columnOrder="8"></t:dgCol>
			<t:dgCol title="用户名" field="fullName" width="100"  query="true" columnOrder="8"></t:dgCol>
	        <t:dgCol title="工作流角色" field="workflowRoleNames" width="150"  columnOrder="8"></t:dgCol>
	        <t:dgCol title="权限角色" field="roleNames" width="150"  columnOrder="8"></t:dgCol>
	        
	        <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmPositionController.do?goTmPositionForm&optype=0" funname="addTmPosition"></t:dgToolBar>
	        <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmPositionController.do?goTmPositionForm&optype=1" funname="updateTmPosition"></t:dgToolBar>
	        <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmPositionController.do?deleteTmPosition" funname="deleteALLSelect"></t:dgToolBar>
	        <t:dgToolBar title="启用" operationCode="start"  icon="icon-start" url="tmPositionController.do?startOrStopPosition" funname="startOrStopPosition('009')"></t:dgToolBar>
	        <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmPositionController.do?startOrStopPosition" funname="startOrStopPosition('003')"></t:dgToolBar>
			<t:dgToolBar title="更新全部编码" operationCode="updateAll" icon="icon-edit" url="" funname="updateAll"></t:dgToolBar>
			<t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmPosition', gridName:'tmPositionList'})" ></t:dgToolBar>
			<t:dgToolBar title="导出" operationCode="dataOut"  icon="icon-dataOut" url="tmPositionController.do?exportXls&clickFunctionId=${clickFunctionId}" funname="excelExport"></t:dgToolBar>

			<t:dgToolBar title="关联客户" operationCode="customerRel" icon="icon-stores_group" url="tmCustPostController.do?goCustomerByPosMain" funname="detailTmCustPos"></t:dgToolBar>
			<t:dgToolBar title="关联终端" operationCode="terminalRel" icon="icon-stores_group" url="tmTermCustPostController.do?goTermPosCustMain" funname="detailTmCustPos"></t:dgToolBar>
			<t:dgToolBar title="职位-客户关系维护" operationCode="customerPostRel" icon="icon-stores_group" url="tmCustPostController.do?goCustomerBindPosMain" funname="updateTmCustPos"></t:dgToolBar>
	        <t:dgToolBar title="职位-终端关系维护" operationCode="terminalPostRel" icon="icon-stores_group" url="tmTermCustPostController.do?goTermBindPosMain" funname="updateTmTermPos"></t:dgToolBar>
	      	<t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmPositionController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
	    </t:datagrid>
	</div>
</div>
<c:if test="${not empty includeJSP}">
	<jsp:include page="${includeJSP}" flush="true"></jsp:include>
</c:if>
<script type="text/javascript">

	// $(document).ready(function(){
	// 	$("input[name='orgName']").combotree({
	// 	    url: 'tmOrgController.do?getParentOrg',
	// 	    onSelect : function(node) {
	// 	    	$("input[name='orgName']").val(node.id);
	//         	}
	// 		});
	// });


	$(function () {
		$(".combo input").css("width", "180px");
		$(".combo").css("width", "auto");
		$(".combo").combotree({
			url: 'tmOrgController.do?getParentOrg',
			width: '200',
			onSelect: function (node) {
				$("input[name='orgName']").val(node.text);
			}
		});
	});

	//新增
	function addTmPosition(title, url, gridname) {
		add(title, url, gridname, 380, 300);
	}
	//修改
	function updateTmPosition(title, url, gridname, width, height) {
		update(title, url, gridname, 380, 300);
	}

//关联客户、终端
function detailTmCustPos(title, url, gridname, width, height) {
    var postionTarget = $("#tmPositionList").datagrid("getSelected");
    if(postionTarget==null || postionTarget==""){
        tip("请选择一条要操作的数据");
        return false;
    }
    openwindow(title, url+"&positionId="+postionTarget.id, gridname,600, 500);
}

	//关联客户
	function updateTmCustPos(title, url, gridname, width, height) {
		var postionTarget = $("#tmPositionList").datagrid("getSelected");
		if(postionTarget==null || postionTarget==""){
			tip("请选择一条要操作的数据");
			return false;
		}
		openwindow(title, url+"&positionId="+postionTarget.id+"&businessGroup="+postionTarget.businessGroup, gridname,1000, 700);
	}

	//关联终端
	function updateTmTermPos(title, url, gridname, width, height) {
		var postionTarget = $("#tmPositionList").datagrid("getSelected");
		if(postionTarget==null || postionTarget==""){
			tip("请选择一条要操作的数据");
			return false;
		}
		openwindow(title, url+"&positionId="+postionTarget.id+"&businessGroup="+postionTarget.businessGroup, gridname, 1000, 700);
	}
	//删除
	function deleteTmPosition(title, url, gridname) {
		var rowsData = $('#' + gridname).datagrid('getSelections');
	    if (!rowsData || rowsData.length == 0) {
	        tip('请选择删除项目');
	        return;
	    }
	    url += '&id=' + rowsData[0].id;
		delObj(url, gridname);
	}
	
	//停用启用
	function startOrStopPosition(flag){
		var positionTarget = $("#tmPositionList").datagrid('getSelected');
		if(positionTarget == null){
			tip("请选择一条要操作的数据");
			return;
		}
		var tipmMsg = "";
		if(flag == "009"){
			tipmMsg = "确定要启用该数据吗?"
		}else{
			tipmMsg = "确定要停用该数据吗?"
		}
		$.messager.confirm('操作提示',tipmMsg,function(r){ 
		    if (r){
		    	$.ajax({
		        	type : "POST",
		        	url : "tmPositionController.do?startOrStopPosition",
		        	data : {
		            	"id" : positionTarget.id,
		            	"enableStatus": flag
		        	},
		        	dataType : "json",
		        	success : function(data) {
		        		tip(data.msg);
		        		$("#tmPositionList").datagrid('reload');
		        	},
		        	error:function(){
		        		tip("服务器异常，请稍后再试");
		        	}
			   });
		    }
		});
	}
	
	function updateAll() {
        $.messager.confirm('操作提示',"确认全部更新编码规则吗？",function(r){
            if (r){
                openProgressTop("正在执行操作，可能需要等待几分钟");
                $.post("tmPositionController.do?updateAllCodeRule", {  },
                    function(data){
                        closeProgressTop();
                        tip(data.msg);
                    }, "json");
            }
        });


    }
	
</script>

