<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="product_price_List" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid  name="productPriceList" fitColumns="false" extendTableName="${extendTableName}" idField="id"
                actionUrl="tmProductPriceController.do?findProductPriceMainGrid"  checkbox="true" singleSelect="false" queryMode="group">

            <t:dgCol field="productInfoCode" title="物料编码"  query="true" width="100" columnOrder="5"></t:dgCol>
            <t:dgCol field="productInfoName" title="物料名称"  query="true" width="100" columnOrder="5"></t:dgCol>
            <t:dgCol field="customerName" title="客户"   width="100" columnOrder="8"></t:dgCol>
            <t:dgCol field="terminalName" title="门店"   width="100" columnOrder="8"></t:dgCol>
            <t:dgCol field="beginTime" title="有效期开始"   formatter="yyyy-MM-dd" columnOrder="14"></t:dgCol>
            <t:dgCol field="endTime" title="有效期结束"   formatter="yyyy-MM-dd" columnOrder="14"></t:dgCol>

            <%--<t:dgCol field="id" title="主键" sortable="false" hidden="true"></t:dgCol>
            <t:dgCol field="priceType" title="价格类型" sortable="true" query="true" dictionary="price_type"></t:dgCol>
            <t:dgCol field="priceDimension" title="价格维度" sortable="true" query="true" dictionary="price_dimension"></t:dgCol>
            <t:dgCol field="pricePriority" title="价格优先级" sortable="true" ></t:dgCol>
            <t:dgCol field="productInfoCode" title="产品编码" sortable="true" query="true"></t:dgCol>
            <t:dgCol field="productInfoName" title="产品名称" sortable="true" query="true"></t:dgCol>
            &lt;%&ndash;<t:dgCol field="saleCompany" title="销售公司" sortable="true" dictionary="company_code"></t:dgCol>&ndash;%&gt;
            <t:dgCol field="priceGroup" title="价格组"  sortable="true" dictionary="price_group"></t:dgCol>
            <t:dgCol field="customerName" title="客户"  sortable="true" ></t:dgCol>
            <t:dgCol field="terminalName" title="门店"  sortable="true" ></t:dgCol>
            <t:dgCol field="saleUnit" title="销售单位"  sortable="true" dictionary="sale_unit"></t:dgCol>
            <t:dgCol field="unitPrice" title="单价"  sortable="true" ></t:dgCol>
            <t:dgCol field="priceCurrency" title="价格币种"  sortable="true" dictionary="price_currency"></t:dgCol>
            <t:dgCol field="beginTime" title="有效期开始"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol field="endTime" title="有效期结束"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol field="deleteStatus" title="删除标记"  sortable="true" dictionary = "is_no"></t:dgCol>
            <t:dgCol field="createName" title="创建人"  sortable="true" ></t:dgCol>
            <t:dgCol field="createDate" title="创建时间"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol field="updateBy" title="更新人"  sortable="true" ></t:dgCol>
            <t:dgCol field="updateDate" title="更新时间"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>--%>

            <t:dgToolBar title="新增" operationCode="add" url="tmProductPriceController.do?goSaveOrUpdateForm&optype=0" icon="icon-add" funname="add" ></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" url="tmProductPriceController.do?goSaveOrUpdateForm&optype=1" icon="icon-edit" funname="update" ></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" url="tmProductPriceController.do?goSaveOrUpdateForm&operation=search&optype=1" icon="icon-edit" funname="detail"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmProductPrice', gridName:'productPriceList'})" ></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmProductPriceController.do?delProductPrice" funname="deleteALLSelect3"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log"   url="tmCustomerController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script>

    //删除
    function deleteALLSelect3(title, url) {
        var rowsData = $('#productPriceList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择产品价格');
            return;
        }
        var ids = [];
        if (rowsData.length > 0) {
            $.dialog.confirm('是否删除选中数据？', function (r) {
                if (r) {
                    for (var i = 0; i < rowsData.length; i++) {
                        ids.push(rowsData[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data) {
                            tip(data.msg);
                            if (data.success) {
                                $("#productPriceList").datagrid('reload');
                            }
                        }
                    });
                }
            });
        } else {
            tip("请选择要删除的数据！");
        }
    }
</script>