/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.customer.dao.TmAddressDao;
import com.biz.eisp.mdm.customer.entity.TmAddressEntity;
import com.biz.eisp.mdm.customer.service.TmAddressService;
import com.biz.eisp.mdm.customer.transformer.TmAddressEntityToVo;
import com.biz.eisp.mdm.customer.transformer.TmAddressVoToEntity;
import com.biz.eisp.mdm.customer.vo.TmAddressVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tmAddressService")
public class TmAddressServiceImpl
extends BaseServiceImpl
implements TmAddressService {
    @Autowired
    private TmAddressDao tmAddressDao;

    @Override
    public List<TmAddressVo> findTmAddressList(TmAddressVo tmAddressVo, Page page) {
        return this.tmAddressDao.findTmAddressList(tmAddressVo, page);
    }

    @Override
    public TmAddressVo getTmAddressVoById(String id) {
        TmAddressEntity entity = this.get(TmAddressEntity.class, (Serializable)((Object)id));
        TmAddressEntityToVo trans = new TmAddressEntityToVo();
        TmAddressVo vo = trans.apply(entity);
        return vo;
    }

    @Override
    public void saveTmAddressForm(TmAddressVo tmAddressVo) {
        if (StringUtil.equals(tmAddressVo.getDefaultStatus(), "1")) {
            TmAddressVo tmAddressVoQuery = new TmAddressVo();
            tmAddressVoQuery.setCustomerId(tmAddressVo.getCustomerId());
            List<TmAddressVo> tmAddressVos = this.tmAddressDao.findTmAddressList(tmAddressVoQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmAddressVos)) {
                tmAddressVos.forEach(item -> {
                    TmAddressVoToEntity tans = new TmAddressVoToEntity(this);
                    item.setDefaultStatus("0");
                    TmAddressEntity entity = tans.apply((TmAddressVo)item);
                    this.updateEntity(entity);
                });
            }
        }
        TmAddressVoToEntity tans = new TmAddressVoToEntity(this);
        TmAddressEntity entity = tans.apply(tmAddressVo);
        this.saveOrUpdate(entity);
    }

    @Override
    public void deleteTmAddress(String ids) {
        String[] routeIds;
        AjaxJson j = new AjaxJson();
        for (String id : routeIds = ids.split(",")) {
            TmAddressEntity entity = this.get(TmAddressEntity.class, (Serializable)((Object)id));
            if (!StringUtil.isNotEmpty(entity)) {
                throw new BusinessException("\u5220\u9664\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            this.delete(entity);
        }
        j.setMsg("\u5220\u9664\u6210\u529f");
    }
}

