/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productPrice.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoService;
import com.biz.eisp.mdm.productInfo.vo.TmProductInfoVo;
import com.biz.eisp.mdm.productPrice.service.TmProductPriceMainExtendService;
import com.biz.eisp.mdm.productPrice.service.TmProductPriceService;
import com.biz.eisp.mdm.productPrice.vo.TmProductPriceVo;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmProductPriceController"})
public class TmProductPriceController
extends BaseController {
    @Autowired
    private TmProductPriceService tmProductPriceService;
    @Autowired
    private TmProductInfoService tmProductInfoService;
    @Autowired
    private TmCustOrgService tmCustOrgService;
    @Autowired
    private TmCustomerService tmCustomerService;
    @Autowired
    private TmTerminalService tmTerminalService;
    @Autowired(required=false)
    private TmProductPriceMainExtendService tmProductPriceMainExtendService;

    @RequestMapping(params={"goProductPriceList"})
    public ModelAndView goProductPriceList(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_PRODUCT_PRICE);
        if (this.tmProductPriceMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmProductPriceMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductPriceMain");
    }

    @RequestMapping(params={"findProductPriceMainGrid"})
    @ResponseBody
    public DataGrid findProductPriceMainGrid(HttpServletRequest req, TmProductPriceVo queryVo) {
        this.page = new EuPage(req);
        List<TmProductPriceVo> icons = this.tmProductPriceService.findProductPriceMainGrid(queryVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmProductPriceVo productPriceVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        page.setRows("50000");
        List<TmProductPriceVo> result = this.tmProductPriceService.findProductPriceMainGrid(productPriceVo, page);
        this.doExportXls(response, request, result, TmProductPriceVo.class, "\u5bfc\u51fa\u5217\u8868" + DateUtils.getDataString(DateUtils.yyyymmddhhmmss));
    }

    @RequestMapping(params={"addOrUpdate"})
    @ResponseBody
    public AjaxJson addOrUpdateIcon(TmProductPriceVo tmProductPriceVo, HttpServletRequest req) {
        String result = this.tmProductPriceService.saveOrUpdateProductPrice(tmProductPriceVo);
        AjaxJson msg = new AjaxJson();
        msg.setMsg(result);
        return msg;
    }

    @RequestMapping(params={"goSaveOrUpdateForm"})
    public ModelAndView goSaveOrUpdateForm(TmProductPriceVo ic, String operation, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)ic.getId())) {
            TmProductPriceVo vo = this.tmProductPriceService.getProductPriceById(ic.getId());
            request.setAttribute("vo", (Object)vo);
        }
        if (StringUtil.isNotEmpty((String)operation) && "search".equals(operation)) {
            request.setAttribute("view", (Object)true);
        } else {
            request.setAttribute("view", (Object)false);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_PRODUCT_PRICE);
        if (this.tmProductPriceMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmProductPriceMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductPriceForm");
    }

    @RequestMapping(params={"delProductPrice"})
    @ResponseBody
    public AjaxJson delProductPrice(String ids) {
        AjaxJson j = this.tmProductPriceService.delProductPrice(ids);
        return j;
    }

    @RequestMapping(params={"goTmProductInfoMain"})
    public ModelAndView goTmProductInfoMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductInfoMain");
    }

    @RequestMapping(params={"findTmProductInfoList"})
    @ResponseBody
    public DataGrid findTmProductInfoList(HttpServletRequest request, TmProductInfoVo productVo) {
        this.page = new EuPage(request);
        List<TmProductInfoVo> icons = this.tmProductInfoService.findProductInfoMainGrid(productVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"goTmProductOrgMain"})
    public ModelAndView goTmProductOrgMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmProductOrgMain");
    }

    @RequestMapping(params={"findTmProductOrgList"})
    @ResponseBody
    public DataGrid findTmProductOrgList(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        this.page = new EuPage(request);
        List<TmCustomerOrgVo> icons = this.tmCustOrgService.findTmCustomerOrgPageList(custOrgVo, this.page);
        return new DataGrid(icons, this.page);
    }

    @RequestMapping(params={"goTmCustomerMain"})
    public ModelAndView goTmCustomerMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmCustomerListMain");
    }

    @RequestMapping(params={"findTmCustomerList"})
    @ResponseBody
    public DataGrid findTmCustomerList(TmCustomerVo customerVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmCustomerVo> customerList = this.tmCustomerService.findTmCustomerList(customerVo, page, "");
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"goTmTerminaMain"})
    public ModelAndView goTmTerminaMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProductPrice/tmTerminaListMain");
    }

    @RequestMapping(params={"findTmTerminalList"})
    @ResponseBody
    public DataGrid findTmTerminalList(TmTerminalVo terminalVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TmTerminalVo> terminalList = this.tmTerminalService.findTmTerminalList(terminalVo, page, request.getParameter("clickFunctionId"), false);
        return new DataGrid(terminalList, page);
    }

    @RequestMapping(params={"getPricePriority"})
    @ResponseBody
    public AjaxJson getPricePriority(String priceDimension, HttpServletRequest request) {
        AjaxJson ajaxJson = new AjaxJson();
        Object priority = null;
        List<KnlDictDataEntity> list = DictUtil.getDictList("price_dimension");
        for (KnlDictDataEntity knlDictDataEntity : list) {
            Map<String, Object> extendMap;
            if (!StringUtil.equals(knlDictDataEntity.getDictCode(), priceDimension) || (extendMap = knlDictDataEntity.getExtendMap()).isEmpty()) continue;
            priority = extendMap.get("priority");
        }
        ajaxJson.setObj(priority);
        return ajaxJson;
    }
}

