/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.timeTask.util;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.text.ParseException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzManagerUtil {
    private static Logger logger = Logger.getLogger(QuartzManagerUtil.class);

    public static void changeCronExpByName(String triggerName, String cronExpression) {
        try {
            StdScheduler schedulerFactory = (StdScheduler)ApplicationContextUtils.getContext().getBean("schedulerFactory");
            Set triggerKeys = schedulerFactory.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"DEFAULT"));
            for (TriggerKey triggerKey : triggerKeys) {
                if (!triggerKey.getName().equals(triggerName)) continue;
                CronTrigger trigger = (CronTrigger)schedulerFactory.getTrigger(triggerKey);
                CronExpression.validateExpression((String)cronExpression);
                CronTrigger reTrigger = (CronTrigger)TriggerBuilder.newTrigger().forJob(trigger.getJobKey()).withIdentity(triggerName, "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                schedulerFactory.rescheduleJob(triggerKey, (Trigger)reTrigger);
                break;
            }
        }
        catch (SchedulerException exp) {
            logger.error((Object)("Fail to reschedule. " + (Object)((Object)exp)));
            exp.printStackTrace();
        }
        catch (ParseException exp) {
            logger.error((Object)("The new cronExpression - " + cronExpression + " not conform to the standard. " + exp));
            exp.printStackTrace();
        }
    }
}

