SELECT U.*,
UC.CUSTNAME,
UC.CUSTCODE,
UC.CUSTID,
UR.ROLENAMES,
UR.ROLECODES,
UR.ROLEIDS
FROM TM_USER U
LEFT JOIN (
    SELECT DISTINCT TUC.USER_ID,group_concat(TC.ID separator ',') AS CUSTID ,
    group_concat(TC.CUSTOMER_NAME separator ',') AS CUSTNAME,
    group_concat(TC.CUSTOMER_CODE separator ',') AS CUSTCODE
    FROM TM_R_USER_CUSTOMER TUC
    JOIN TM_CUSTOMER TC ON TC.ID=TUC.CUSTOMER_ID
    GROUP BY TUC.USER_ID
) UC ON UC.USER_ID = U.ID
LEFT JOIN (
  SELECT DISTINCT TMR.USER_ID,group_concat(TE.ROLE_NAME separator ',') AS ROLENAMES,
  group_concat(TE.ROLE_CODE separator ',') AS ROLECODES,
  group_concat(TE.ID separator ',') AS ROLEIDS
  FROM TM_R_USER_ROLE TMR
  JOIN TM_ROLE TE ON TE.ID=TMR.ROLE_ID
  GROUP BY TMR.USER_ID
) UR ON UR.USER_ID = U.ID
WHERE 1=1 AND U.USER_TYPE=1
<#if tmUserVo.id ?exists&&tmUserVo.id ?length gt 0>
	AND U.ID = '${tmUserVo.id}'
</#if>
<#if tmUserVo.userName ?exists&&tmUserVo.userName ?length gt 0>
	AND U.USERNAME LIKE '%${tmUserVo.userName}%'
</#if>
<#if tmUserVo.fullName ?exists&&tmUserVo.fullName ?length gt 0>
	AND U.FULLNAME LIKE '%${tmUserVo.fullName}%'
</#if>
<#if tmUserVo.enableStatus ?exists&&tmUserVo.enableStatus ?length gt 0>
	AND U.ENABLE_STATUS = '${tmUserVo.enableStatus}'
</#if>
<#if tmUserVo.custName ?exists&&tmUserVo.custName ?length gt 0>
	AND UC.CUSTNAME LIKE '%${tmUserVo.custName}%'
</#if>
<#if tmUserVo.custId ?exists&&tmUserVo.custId ?length gt 0>
	AND UC.CUSTID LIKE '%${tmUserVo.custId}%'
</#if>
ORDER BY U.CREATE_DATE DESC