/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.org.service.impl;

import com.biz.eisp.api.TmMqSerivce;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgExtendService;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.transform.TmOrgVoTransFormPo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.util.PosAndOrgCodeRuleUtil;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.system.service.InitListenerService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmOrgService")
@Transactional
public class TmOrgServiceImpl
extends BaseServiceImpl
implements TmOrgService {
    @Autowired
    private TmOrgDao tmOrgDao;
    @Autowired(required=false)
    private TmOrgExtendService tmOrgExtendService;
    @Autowired
    private InitListenerService initListenerService;
    @Autowired(required=false)
    private TmMqSerivce tmMqSerivce;

    @Override
    public List<TreeGrid> findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo tmOrgVo) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        SimpleExpression cr1 = null;
        SimpleExpression cr2 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<Object> orgList = new ArrayList();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName()) || StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
            String hql = "select t from TmOrgEntity t where 1 = 1 and t.enableStatus = ? ";
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName())) {
                hql = hql + " and t.orgName like '%" + tmOrgVo.getOrgName() + "%'";
            }
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
                hql = hql + " and t.orgCode like '%" + tmOrgVo.getOrgCode() + "%'";
            }
            List temp = this.findByHql(hql, Globals.ZERO);
            for (TmOrgEntity tmOrgEntity : temp) {
                orgList.add(tmOrgEntity);
                this.addParentsEntity(tmOrgEntity, orgList);
            }
        } else {
            if (StringUtil.isNotEmpty((String)treeGrid.getId())) {
                cr1 = Restrictions.eq((String)"tmOrg.id", (Object)treeGrid.getId());
            }
            if (StringUtil.isEmpty(treeGrid.getId())) {
                cr1 = Restrictions.isNull((String)"tmOrg");
            }
            orgList = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2});
        }
        ArrayList<TmOrgVo> orgVoList = new ArrayList<TmOrgVo>();
        TmOrgEntityToTmOrgVo orgTransForm = new TmOrgEntityToTmOrgVo(this);
        for (TmOrgEntity tmOrgEntity : orgList) {
            orgVoList.add(orgTransForm.apply(tmOrgEntity));
        }
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgName");
        treeGridModel.setParentText("tmOrg_orgName");
        treeGridModel.setParentId("tmOrg_id");
        treeGridModel.setSrc("orgDesc");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmOrgList");
        treeGridModel.setCode("orgCode");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.addField(hashMap, TmOrgVo.class);
        treeGridModel.setFieldMap(hashMap);
        treeGrids = this.treegrid(orgVoList, treeGridModel);
        return treeGrids;
    }

    private void addField(Map<String, Object> fieldMap, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (StringUtil.equals("tmOrgList", fieldName)) continue;
            fieldMap.put(fieldName, fieldName);
        }
    }

    private void addParentsEntity(TmOrgEntity tt, List<TmOrgEntity> orgList) {
        String parent_id;
        TmOrgEntity tempEntity;
        String sql = "select parent_id from tm_org where id=?";
        Map<String, Object> map = this.findForMap(sql, tt.getId());
        if (StringUtil.isNotEmpty(map.get("parent_id")) && (tempEntity = super.get(TmOrgEntity.class, (Serializable)((Object)(parent_id = (String)map.get("parent_id"))))) != null) {
            if (!orgList.contains(tempEntity)) {
                orgList.add(tempEntity);
            }
            this.addParentsEntity(tempEntity, orgList);
        }
    }

    @Override
    public List<TmOrgVo> findOrgSelectGrid(TmOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgList(tmOrgVo, page);
    }

    @Override
    public List<TmCustomerOrgVo> findOrgCustSelectGrid(TmCustomerOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgCustList(tmOrgVo, page);
    }

    @Override
    public List<ComboTree> getParentOrg(TmOrgVo orgVo, ComboTree comboTree, HttpServletRequest request) {
        List<Object> tmOrgList = new ArrayList();
        SimpleExpression cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId) && StringUtil.isEmpty(comboTree.getId())) {
            tmOrgList = this.findByProperty(TmOrgEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)orgVo.getOrgId())) {
            cr1 = Restrictions.ne((String)"id", (Object)orgVo.getOrgId());
        }
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmOrg.id", (Object)comboTree.getId());
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr2, cr4}));
            }
        } else {
            SimpleExpression cr3 = null;
            if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
                cr3 = Restrictions.eq((String)"id", (Object)orgVo.getPid());
            } else if (StringUtil.isEmpty(selfId)) {
                cr3 = Restrictions.isNull((String)"tmOrg.id");
            }
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3, cr4}));
            } else if (StringUtil.isEmpty(selfId)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}));
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
        List<ComboTree> comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, true);
        return comboTrees;
    }

    @Override
    public List<ComboTree> getParentOrgCode(TmOrgVo orgVo, ComboTree comboTree, HttpServletRequest request) {
        List<Object> tmOrgList = new ArrayList();
        SimpleExpression cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId) && StringUtil.isEmpty(comboTree.getId())) {
            tmOrgList = this.findByProperty(TmOrgEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)orgVo.getOrgId())) {
            cr1 = Restrictions.ne((String)"id", (Object)orgVo.getOrgId());
        }
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmOrg.id", (Object)comboTree.getId());
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr2, cr4}));
            }
        } else {
            SimpleExpression cr3 = null;
            if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
                cr3 = Restrictions.eq((String)"id", (Object)orgVo.getPid());
            } else if (StringUtil.isEmpty(selfId)) {
                cr3 = Restrictions.isNull((String)"tmOrg.id");
            }
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3, cr4}));
            } else if (StringUtil.isEmpty(selfId)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}));
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("orgCode", "orgName", "tmOrgList");
        List<ComboTree> comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, true);
        return comboTrees;
    }

    private boolean checkIsUpdateCodeRule(TmOrgVo orgVo) {
        String id = orgVo.getId();
        if (StringUtil.isBlank((String)id)) {
            return true;
        }
        String sql = " select id,code_rule,PARENT_ID from tm_org where id=? ";
        List<TmOrgVo> orgs = this.findBySql(TmOrgVo.class, sql, id);
        TmOrgVo vo = orgs.get(0);
        String parentId = vo.getParentId();
        parentId = parentId == null ? "" : parentId;
        String newParentId = orgVo.getParentId();
        String string = newParentId = newParentId == null ? "" : newParentId;
        return !newParentId.equals(parentId);
    }

    @Override
    public void saveOrUpdateOrg(TmOrgVo tmOrgVo, Page page) {
        boolean flag = false;
        flag = this.checkIsUpdateCodeRule(tmOrgVo);
        TmOrgEntity tmOrgEntity = null;
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            try {
                this.tmOrgExtendService.validate(tmOrgVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgVo, page);
        }
        if (StringUtil.isEmpty(tmOrgEntity)) {
            TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
            tmOrgEntity = formPo.apply(tmOrgVo);
        }
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgEntity, tmOrgVo, page);
        }
        tmOrgEntity.setIsLeaf(1);
        if (StringUtil.isEmpty(tmOrgEntity.getId())) {
            tmOrgEntity.setCodeRule(UUID.randomUUID().toString());
        }
        this.saveOrUpdate(tmOrgEntity);
        if (StringUtil.isNotEmpty(this.tmMqSerivce)) {
            this.tmMqSerivce.orgCallBack(tmOrgEntity.getId(), tmOrgEntity.getTmOrg().getId(), tmOrgEntity.getOrgName(), 2);
        } else {
            this.initListenerService.refleshDepart(tmOrgEntity.getId(), StringUtil.isNotEmpty(tmOrgEntity.getTmOrg()) ? tmOrgEntity.getTmOrg().getId() : null, tmOrgEntity.getOrgName(), 2);
        }
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.savePost(tmOrgEntity, tmOrgVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmOrgVo.getId())) {
            String oldParnetId;
            String id = tmOrgEntity.getId();
            TmOrgEntity oldOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)id));
            String string = oldParnetId = StringUtil.isNotEmpty(oldOrgEntity.getTmOrg()) ? oldOrgEntity.getTmOrg().getId() : null;
            if (StringUtil.isEmpty(oldParnetId) || !oldParnetId.equals(tmOrgVo.getPid())) {
                // empty if block
            }
        }
        if (flag) {
            this.updatePosCodeRule(tmOrgVo, tmOrgEntity);
        }
    }

    private void updateAllCodeRuleForCode(String ruelCode, String id, TmOrgEntity entity) {
        entity.setCodeRule(ruelCode);
        this.saveOrUpdate(entity);
        this.updateChild(id, ruelCode);
    }

    private void updatePosCodeRule(TmOrgVo orgVo, TmOrgEntity orgEntity) {
        String parentId = orgVo.getParentId();
        if (StringUtil.isBlank((String)parentId)) {
            String hql = "select max(code_rule) as code_rule from tm_org where  id <> ? and  ( PARENT_ID is null or  PARENT_ID = '') order by id desc";
            List<TmOrgEntity> orgVos = this.findBySql(TmOrgEntity.class, hql, orgEntity.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(orgVos) && StringUtil.isNotBlank((String)orgVos.get(0).getCodeRule())) {
                String codeTemp = orgVos.get(0).getCodeRule();
                String code = codeTemp.substring(0, 4);
                code = code.replaceAll("^(0+)", "");
                int codeNum = Integer.valueOf(code);
                code = PosAndOrgCodeRuleUtil.createCodeRule("", codeNum + 1);
                this.updateAllCodeRuleForCode(code, orgEntity.getId(), orgEntity);
            } else {
                this.updateAllCodeRuleForCode("0001", orgEntity.getId(), orgEntity);
            }
        } else {
            String hql = "select max(code_rule) as code_rule from tm_org where PARENT_ID=? and id <> ? order by id desc";
            List<TmOrgEntity> orgVoSelf = this.findBySql(TmOrgEntity.class, hql, parentId, orgEntity.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(orgVoSelf) && StringUtil.isNotBlank((String)orgVoSelf.get(0).getCodeRule())) {
                String codeTemp = orgVoSelf.get(0).getCodeRule();
                String code = codeTemp.substring(codeTemp.length() - 4, codeTemp.length());
                code = code.replaceAll("^(0+)", "");
                int codeNum = Integer.valueOf(code);
                code = PosAndOrgCodeRuleUtil.createCodeRule(codeTemp.substring(0, codeTemp.length() - 4), codeNum + 1);
                this.updateAllCodeRuleForCode(code, orgEntity.getId(), orgEntity);
            } else {
                TmOrgEntity tmOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)parentId));
                this.updateChild(tmOrgEntity.getId(), tmOrgEntity.getCodeRule());
            }
        }
    }

    @Override
    public AjaxJson delOrg(String ids) {
        String[] orgIds;
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        j.setMsg("\u5220\u9664\u6210\u529f");
        for (String id : orgIds = ids.split(",")) {
            TmOrgEntity orgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)id));
            if (CollectionUtils.isEmpty(orgEntity.getTmOrgList())) {
                List<TmPositionEntity> positions = this.findByProperty(TmPositionEntity.class, "tmOrg.id", id);
                if (!CollectionUtils.isEmpty(positions)) {
                    j.setErrorMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u6709\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u5220\u9664\uff01");
                    return j;
                }
            } else {
                j.setErrorMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u5220\u9664\uff01");
                return j;
            }
            orgEntity.setEnableStatus(Globals.ONE);
            orgEntity.setStatus(Globals.ONE);
            this.updateEntity(orgEntity);
            this.initListenerService.refleshDepart(orgEntity.getId(), orgEntity.getTmOrg().getId(), orgEntity.getOrgName(), 3);
        }
        return j;
    }

    @Override
    public AjaxJson startOrStopTmuser(TmOrgVo orgVo) {
        TmOrgEntity orgEntity;
        AjaxJson j = new AjaxJson();
        String mag = "\u505c\u7528";
        if (Globals.ZERO.equals(orgVo.getEnableStatus())) {
            mag = "\u542f\u7528";
        }
        if (null == (orgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)orgVo.getId())))) {
            j.setSuccess(false);
            j.setMsg("\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u4fe1\u606f.");
        }
        if (Globals.ONE.equals(orgVo.getEnableStatus())) {
            TmOrgEntity tmOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)orgVo.getId()));
            List<TmPositionEntity> positions = this.tmOrgDao.findOrgIDComboTreeByPos(tmOrgEntity.getOrgCode());
            if (!CollectionUtils.isEmpty(positions)) {
                j.setMsg("\u5f53\u524d" + mag + "\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011,\u6216\u4e0b\u7ea7\u7ec4\u7ec7,\u6709\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd" + mag + "\uff01");
                j.setSuccess(false);
                return j;
            }
            this.tmOrgDao.upDateOrderEnableStatus(tmOrgEntity.getOrgCode(), orgVo.getEnableStatus());
        } else {
            orgEntity.setEnableStatus(orgVo.getEnableStatus());
            this.updateEntity(orgEntity);
        }
        j.setMsg(mag + "\u6210\u529f");
        return j;
    }

    @Override
    public TmOrgVo getTmOrgByPostionId(String postionId) {
        String sql = "select t1.* from tm_org t1 where t1.id = (select t2.org_id from tm_position t2 where t2.id = ?)";
        TmOrgEntity org = this.getUniqueBySql(TmOrgEntity.class, sql, postionId);
        TmOrgVo result = new TmOrgEntityToTmOrgVo(this).apply(org);
        return result;
    }

    @Override
    public void importOrg(TmOrgVo tmOrgVo) {
        TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
        TmOrgEntity tmOrgEntity = formPo.apply(tmOrgVo);
        this.saveOrUpdate(tmOrgEntity);
    }

    @Override
    public List<TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgByAllPossible(queryTmOrgVo, page);
    }

    @Override
    public List<TmOrgVo> findAllOrg() {
        List<TmOrgEntity> orgs = super.findByCriteria(TmOrgEntity.class, new Criterion[0]);
        return Lists.transform(orgs, (Function)new TmOrgEntityToTmOrgVo(this));
    }

    @Override
    public List<TmOrgVo> findOrgMainList(TmOrgVo tmOrgVo) {
        KnlDictDataEntity tagerEntity;
        KnlDictDataEntity knlDictDataEntity;
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, tmOrgVo);
        String orderSql = "";
        if (StringUtil.isNotBlank((String)tmOrgVo.getSort()) && StringUtil.isNotBlank((String)tmOrgVo.getOrder()) && (knlDictDataEntity = DictUtil.getDicData(Globals.mdm_table, Globals.TABLE_ORG + "_")) != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode(knlDictDataEntity.getId(), tmOrgVo.getSort())).getDictValue())) {
            String c = tagerEntity.getDictValue();
            orderSql = " order by " + c + " " + tmOrgVo.getOrder();
        }
        sql = sql + orderSql;
        List<TmOrgVo> tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, tmOrgVo)) {
            tmOrgList = this.findQueryCustomerOrgList(tmOrgVo, tmOrgList, sql);
        }
        return tmOrgList;
    }

    private List<TmOrgVo> findQueryCustomerOrgList(TmOrgVo tmOrgVo, List<TmOrgVo> voList, String sql) {
        if (tmOrgVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
        List<TmOrgVo> parents = this.findParents(allQueryVolist, sql);
        if (parents.size() == 0) {
            return allQueryVolist;
        }
        parents.addAll(allQueryVolist);
        allQueryVolist = TreeGridUtil.buildTreeGrid(parents);
        return allQueryVolist;
    }

    private List<TmOrgVo> findParents(List<TmOrgVo> allQueryVolist, String sql) {
        Set<String> codes = allQueryVolist.stream().map(TmOrgVo::getCodeRule).collect(Collectors.toSet());
        if (codes.size() == 0) {
            return Lists.newArrayList();
        }
        HashSet parentCodes = Sets.newHashSet();
        for (String code : codes) {
            parentCodes.addAll(this.resolveParentCode(code, codes));
        }
        if (parentCodes.size() == 0) {
            return Lists.newArrayList();
        }
        String where = parentCodes.stream().collect(Collectors.joining(",", " t.code_rule in (", ")"));
        sql = sql.substring(0, sql.lastIndexOf("WHERE") + 5);
        sql = sql + where;
        List<TmOrgVo> tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
        return tmOrgList;
    }

    private Set<String> resolveParentCode(String code, Set<String> parentCodes) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        int len = code.length();
        int codeNum = len / 4;
        HashSet codeRules = Sets.newHashSet();
        for (int i = 1; i < codeNum; ++i) {
            String s = code.substring(0, i * 4);
            if (parentCodes.contains(s)) continue;
            codeRules.add(s);
        }
        return codeRules;
    }

    private boolean hasQueryValue(TmOrgVo tmOrgVo) {
        return !StringUtil.isEmpty(tmOrgVo.getOrgCode()) || !StringUtil.isEmpty(tmOrgVo.getOrgName()) || !StringUtil.isEmpty(tmOrgVo.getOrgDesc()) || !StringUtil.isEmpty(tmOrgVo.getOrgType()) || !StringUtil.isEmpty(tmOrgVo.getHeadString()) || !StringUtil.isEmpty(tmOrgVo.getExtChar1()) || !StringUtil.isEmpty(tmOrgVo.getExtChar2()) || !StringUtil.isEmpty(tmOrgVo.getExtChar3()) || !StringUtil.isEmpty(tmOrgVo.getExtChar4()) || !StringUtil.isEmpty(tmOrgVo.getExtChar5()) || tmOrgVo.getExtDate1() != null || tmOrgVo.getExtDate2() != null || tmOrgVo.getExtNumber1() != null || tmOrgVo.getExtNumber2() != null || tmOrgVo.getExtNumber3() != null || tmOrgVo.getEnableStatus() != null;
    }

    @Override
    public List<ComboBox> getSalesArae(TmOrgVo orgVo) {
        String sql = "select id value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = sql + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    @Override
    public List<TmOrgVo> getOrgByOrgLevel(TmOrgVo orgVo) {
        String sql = "select org_code as orgCode,org_name as orgName from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        return this.findBySql(TmOrgVo.class, sql, new Object[0]);
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        SimpleExpression cr3 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr3});
        } else {
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    @Override
    public List<ComboBox> getSalesAraeOrgCode(TmOrgVo orgVo) {
        String sql = "select org_code value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = sql + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    @Override
    public List<TmOrgVo> findOptionalOrgSelectList(TmOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findOptionalOrgSelectList(tmOrgVo, page);
    }

    @Override
    public List<TmOrgVo> findOptionalOrgAlreadyList(TmOrgVo tmOrgVo) {
        if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgCodes())) {
            String codes = "";
            for (String orgCode : tmOrgVo.getOrgCodes().split(",")) {
                if (StringUtil.isNotEmpty((String)codes)) {
                    codes = codes + ",";
                }
                codes = codes + "'" + orgCode + "'";
            }
            tmOrgVo.setOrgCodes(codes);
        } else {
            tmOrgVo.setOrgCodes("'-1'");
        }
        return this.tmOrgDao.findOptionalOrgAlreadyList(tmOrgVo);
    }

    @Override
    public List<TmOrgEntity> findBelowOrgByOrgCode(String orgCode) {
        return this.tmOrgDao.findBelowOrgByOrgCode(orgCode);
    }

    @Override
    public List<TmOrgVo> findOrgExportList(TmOrgVo tmOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, tmOrgVo);
        List<Object> tmOrgList = Lists.newArrayList();
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, tmOrgVo)) {
            tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
            tmOrgList.forEach(e -> e.setOrgName(e.getText()));
        } else {
            tmOrgList = this.tmOrgDao.findTmOrgVoList(tmOrgVo);
        }
        return tmOrgList;
    }

    @Override
    public List<ComboBox> findOrgCodeCombobox() {
        String sql = "SELECT DISTINCT CUST_ORG_CODE value,CUST_ORG_CODE text  FROM tm_customer_org";
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    @Override
    public List<String> findOrgListDowm(String orgId) {
        String sql = " select id,parent_id from tm_org where id=? ";
        List<TmOrgVo> orgVos = this.findBySql(TmOrgVo.class, sql, orgId);
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(orgVos.get(0).getId());
        this.getOrgListChirld(parentIds, orgVos);
        return parentIds;
    }

    public void getOrgListChirld(List<String> parentIds, List<TmOrgVo> orgEntities) {
        if (CollectionUtil.listEmpty(orgEntities)) {
            return;
        }
        List<String> list = orgEntities.stream().map(TmOrgVo::getId).collect(Collectors.toList());
        String sql = " select id,parent_id from tm_org where 1=1 ";
        String sqls = SqlUtil.setSqlIn(list.toArray(new String[list.size()]), "parent_id", true, null);
        List<TmOrgVo> orgVos = this.findBySql(TmOrgVo.class, sql = sql + sqls, new Object[0]);
        if (CollectionUtil.listNotEmptyNotSizeZero(orgVos)) {
            List listTemp = orgVos.stream().map(TmOrgVo::getId).collect(Collectors.toList());
            parentIds.addAll(listTemp);
            this.getOrgListChirld(parentIds, orgVos);
        }
    }

    @Override
    public void updateAllCodeRule() {
        String updateSqlAll = " update tm_org set code_rule = id ";
        this.executeSql(updateSqlAll, new Object[0]);
        String sql = " select id,code_rule from tm_org where PARENT_ID='' or PARENT_ID is null order by id ";
        List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, new Object[0]);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            for (int i = 0; i < positionVos.size(); ++i) {
                String id = positionVos.get(i).getId();
                String codeRule = PosAndOrgCodeRuleUtil.createCodeRule("", i + 1);
                String updateSql = " update tm_org set code_rule = ? where id=? ";
                this.executeSql(updateSql, codeRule, id);
                this.updateChild(id, codeRule);
            }
        }
    }

    public void updateChild(String parentId, String parentCodeRule) {
        String sql = " select id,code_rule from tm_org where PARENT_ID=? order by id";
        List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, parentId);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            for (int i = 0; i < positionVos.size(); ++i) {
                String id = positionVos.get(i).getId();
                String codeRule = PosAndOrgCodeRuleUtil.createCodeRule(parentCodeRule, i + 1);
                String updateSql = " update tm_org set code_rule = ? where id=? ";
                this.executeSql(updateSql, codeRule, id);
                this.updateChild(id, codeRule);
            }
        }
    }
}

