/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.identity.IdInitEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.pojo.glob.entity.ActIdUserEntity;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.util.SendActivitiUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.dao.TmPositionDao;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionExtendService;
import com.biz.eisp.mdm.position.service.TmPositionSearchExtendService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.transformer.TmPositionEntityToTmPositionVo;
import com.biz.eisp.mdm.position.transformer.TmPositionVoToTmPositionEntity;
import com.biz.eisp.mdm.position.util.PosAndOrgCodeRuleUtil;
import com.biz.eisp.mdm.position.vo.MembershipActivitiVo;
import com.biz.eisp.mdm.position.vo.QueryTmpositionVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserPositionEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmPositionService")
@Transactional
public class TmPositionServiceImpl
extends BaseServiceImpl
implements TmPositionService {
    private static final String saveActIdUser = ResourceUtil.getSysConfigProperty("springbootUrl") + "/activiti/activitiConfigApiController/saveActIdUser";
    @Autowired
    private TmPositionDao tmPositionDao;
    @Autowired(required=false)
    private TmPositionExtendService tmPositionExtendService;
    @Autowired(required=false)
    private TmPositionSearchExtendService tmPositionSearchExtendService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private TaRoleService taRoleService;
    @Autowired
    private TmOrgService tmOrgService;

    @Override
    public List<TmPositionVo> findTmPositionList(TmPositionVo tmPositionVo, Page page, String clickFunctionId) {
        List<TmPositionVo> voList;
        String sqlvew;
        List<TmFunAuthEntity> funAuthEntities;
        String sql = "";
        if (this.tmPositionSearchExtendService != null) {
            sql = this.tmPositionSearchExtendService.buildSearchSql(tmPositionVo);
            if (StringUtil.isEmpty(sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, tmPositionVo);
                sql = this.tmPositionSearchExtendService.extendSearchSql(tmPositionVo, sql);
            }
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_POSITION, tmPositionVo);
            sql = this.appendPositionCondition(sql, tmPositionVo, Globals.TABLE_POSITION);
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg())) {
            List<String> list2 = this.tmOrgService.findOrgListDowm(tmPositionVo.getCurentOrg());
            tmPositionVo.setOrgIds(StringUtil.getInSqlStr(list2));
        }
        UserRedis userRedis = UserUtils.getUser();
        String dataBase = ResourceUtil.getSysConfigProperty("dataBase");
        if (Globals.MYSQL.equals(dataBase) && StringUtil.isNotBlank((String)clickFunctionId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero(funAuthEntities = this.findBySql(TmFunAuthEntity.class, sqlvew = "select authobj from tm_r_function_authobj where fun_code =? and function_id=? ", Globals.VIEW, clickFunctionId))) {
            String sqlval = " select distinct tmrrfa.AUTHOBJ,tmrrfa.AUTHOBJ_VALUE as authobjValue from tm_user tmu join tm_r_user_position tmrup on tmu.id = tmrup.USER_ID join tm_position tmp on tmp.id = tmrup.POSITION_ID join tm_r_position_role tmrp on tmrp.POSITION_ID = tmp.id join tm_role tmrole on  tmrole.id = tmrp.role_id join tm_r_role_function tmrrf on (tmrrf.role_id = tmrole.id and tmrrf.function_id =?   ) join tm_r_role_func_authobj tmrrfa on tmrrfa.role_function_id = tmrrf.id where tmu.id=? and tmrrfa.fun_code = ? ";
            List<TmRoleFuncAuthobjEntity> valList = this.findBySql(TmRoleFuncAuthobjEntity.class, sqlval, clickFunctionId, userRedis.getId(), Globals.VIEW);
            if (CollectionUtil.listNotEmptyNotSizeZero(valList)) {
                Map<Object, Object> auValMap;
                List items;
                HashMap auMap = new HashMap();
                valList.stream().collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put(parentId, list));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" 1=1 and ( ");
                boolean flagOr = true;
                if (auMap.containsKey("position")) {
                    items = (List)auMap.get("position");
                    auValMap = new HashMap();
                    auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                    if (auValMap.containsKey("10")) {
                        stringBuffer.append("1=1");
                    } else if (auValMap.containsKey("40")) {
                        stringBuffer.append(" t.code_rule like '" + userRedis.getPoscoderule() + "%' ");
                    } else if (auValMap.containsKey("50")) {
                        stringBuffer.append(" t.id = '" + userRedis.getPosId() + "' ");
                    }
                } else {
                    flagOr = false;
                }
                if (auMap.containsKey("org")) {
                    if (flagOr) {
                        stringBuffer.append(" or ");
                    }
                    items = (List)auMap.get("org");
                    auValMap = new HashMap();
                    auValMap = items.stream().collect(Collectors.toMap(TmRoleFuncAuthobjEntity::getAuthobjValue, item -> item));
                    if (auValMap.containsKey("10")) {
                        stringBuffer.append("1=1");
                    } else if (auValMap.containsKey("20")) {
                        stringBuffer.append(" t1.code_rule like '" + userRedis.getOrgcoderule() + "%' ");
                    } else if (auValMap.containsKey("30")) {
                        stringBuffer.append(" t1.id = '" + userRedis.getOrgId() + "' ");
                    }
                } else {
                    flagOr = false;
                }
                stringBuffer.append(" ) ");
                sql = sql.replace("1=1", stringBuffer.toString());
            } else {
                sql = sql + " 1=2 ";
            }
        }
        if (!CollectionUtils.isEmpty(voList = this.tmPositionDao.findTmPositionList(tmPositionVo, page, sql))) {
            for (TmPositionVo tmPositionVo2 : voList) {
                this.HandleRoleName(tmPositionVo2);
            }
        }
        return voList;
    }

    @Override
    public List<TmPositionVo> findNoAnyRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findNoAnyRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findNoAnyActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findNoAnyActRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findNoThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findNoThisRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findNoThisActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findNoThisActRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findThisRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findThisRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findThisActRolePositionList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> voList = this.tmPositionDao.findThisActRolePositionList(tmPositionVo, page);
        return voList;
    }

    @Override
    public List<TmPositionVo> findTmPositionByOrgSelectList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> list = this.tmPositionDao.findTmPositionByOrgSelectList(tmPositionVo, page);
        return list;
    }

    @Override
    public List<TmPositionVo> findTmPositionQuerySelectList(TmPositionVo tmPositionVo, Page page) {
        List<TmPositionVo> list = this.tmPositionDao.findTmPositionQuerySelectList(tmPositionVo, page);
        return list;
    }

    public String appendPositionCondition(String sql, Object paramObj, String table) {
        TmPositionVo tmPositionVo = new TmPositionVo();
        if (paramObj != null) {
            tmPositionVo = (TmPositionVo)paramObj;
        }
        String isRoleSerchSql = "";
        if (StringUtil.isNotBlank((String)tmPositionVo.getRoleIds())) {
            isRoleSerchSql = ",trpr.role_id";
        }
        String joinSql = "select p.id newId,o.org_name,o.id org_id, tmo.org_name AS parentOrgName,pp.position_code AS parentCode " + isRoleSerchSql;
        joinSql = joinSql + " ,trup.is_main AS isMain,trup.user_id,tu.username AS userName,tu.fullname AS fullName, ptu.fullname AS parentUserName,trup.id AS tmRPositionUserId ";
        joinSql = joinSql + " FROM tm_position p LEFT JOIN tm_org o ON o.id = p.org_id LEFT JOIN tm_r_user_position trup ON trup.position_id=p.id LEFT JOIN tm_user tu ON tu.id = trup.user_id LEFT JOIN tm_position pp ON pp.id = p.parent_id LEFT JOIN tm_org tmo ON pp.org_id = tmo.id LEFT JOIN tm_r_user_position ptup ON pp.id=ptup.position_id LEFT JOIN tm_user ptu ON ptu.id=ptup.user_id";
        String onSql = "t1.newId=t.id";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            sql = sql + " and t.id='" + tmPositionVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg()) && StringUtil.isEmpty(tmPositionVo.getId())) {
            String posId = ResourceUtil.getString("position");
            if (StringUtil.isEmpty(posId)) {
                posId = ResourceUtil.getCurrPosition().getId();
            }
            if (StringUtil.isNotEmpty((String)posId)) {
                sql = sql + " and t.id <>'" + posId + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFlag())) {
            String excludeId = StringUtil.isNotEmpty((String)tmPositionVo.getExcludeId()) ? tmPositionVo.getExcludeId() : "'-1'";
            sqlWhere = sqlWhere + " AND t.id not in (select position_id from tm_r_user_position WHERE user_id is not null AND position_id not in (" + excludeId + "))";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getNotInId())) {
            sqlWhere = sqlWhere + " AND t.id not in (" + tmPositionVo.getNotInId() + ")";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getRoleIds())) {
            joinSql = joinSql + " LEFT JOIN tm_r_position_role trpr ON p.id=trpr.position_id";
            sqlWhere = sqlWhere + " AND t1.role_id ='" + tmPositionVo.getRoleIds() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getParentUserName())) {
            sqlWhere = sqlWhere + " AND t1.parentUserName like '%" + tmPositionVo.getParentUserName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getParentName())) {
            sqlWhere = sqlWhere + " AND t.parentName like '%" + tmPositionVo.getParentName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getFullName())) {
            sqlWhere = sqlWhere + " AND t1.fullname like '%" + tmPositionVo.getFullName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserName())) {
            sqlWhere = sqlWhere + " AND t1.username like '%" + tmPositionVo.getUserName() + "%'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getUserId())) {
            sqlWhere = sqlWhere + " AND t1.user_id ='" + tmPositionVo.getUserId() + "'";
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getCurentOrg())) {
            sqlWhere = sqlWhere + " AND t.orgId in (select id from tm_org )";
            if (StringUtil.isNotBlank((String)tmPositionVo.getCurentId())) {
                sqlWhere = sqlWhere + " AND t.id <>'" + tmPositionVo.getCurentId() + "'";
            }
        }
        if (StringUtil.isNotEmpty((String)tmPositionVo.getOrgId())) {
            sqlWhere = sqlWhere + " AND t.orgId ='" + tmPositionVo.getOrgId() + "'";
        }
        String orderSql = "";
        if (StringUtil.isNotBlank((String)tmPositionVo.getSort()) && StringUtil.isNotBlank((String)tmPositionVo.getOrder())) {
            KnlDictDataEntity tagerEntity;
            KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData(Globals.mdm_table, table + "_");
            if (knlDictDataEntity != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode(knlDictDataEntity.getId(), tmPositionVo.getSort())).getDictValue())) {
                String c = tagerEntity.getDictValue();
                orderSql = " order by " + c + " " + tmPositionVo.getOrder();
            }
        } else {
            orderSql = " order by t.updateDate desc";
        }
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, onSql, sqlWhere, orderSql);
    }

    private void HandleRoleName(TmPositionVo positionVo) {
        List<TmRoleEntity> roles = this.tmPositionDao.findTmRoleByPosition(positionVo);
        StringBuffer bufferNames = new StringBuffer();
        StringBuffer bufferIds = new StringBuffer();
        if (!CollectionUtils.isEmpty(roles)) {
            for (TmRoleEntity tmRoleEntity : roles) {
                if (bufferNames.length() > 0) {
                    bufferNames.append(",");
                    bufferIds.append(",");
                }
                bufferNames.append(tmRoleEntity.getRoleName());
                bufferIds.append(tmRoleEntity.getId());
            }
            positionVo.setRoleNames(bufferNames.toString());
            positionVo.setRoleIds(bufferIds.toString());
        }
        StringBuffer actRoleBufferNames = new StringBuffer();
        StringBuffer actRoleBufferIds = new StringBuffer();
        List<TmActRoleEntity> actRoles = this.tmPositionDao.findTmActRoleByPosition(positionVo);
        if (!CollectionUtils.isEmpty(actRoles)) {
            for (TmActRoleEntity actRole : actRoles) {
                if (actRoleBufferNames.length() > 0) {
                    actRoleBufferNames.append(",");
                    actRoleBufferIds.append(",");
                }
                actRoleBufferNames.append(actRole.getRoleName());
                actRoleBufferIds.append(actRole.getId());
            }
            positionVo.setWorkflowRoleNames(actRoleBufferNames.toString());
            positionVo.setWorkflowRoleIds(actRoleBufferIds.toString());
        }
    }

    private boolean checkIsUpdateCodeRule(TmPositionVo tmPositionVo) {
        String id = tmPositionVo.getId();
        if (StringUtil.isBlank((String)id)) {
            return true;
        }
        String sql = " select id,code_rule,PARENT_ID from tm_position where id=? ";
        List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, id);
        TmPositionVo vo = positionVos.get(0);
        String parentId = vo.getParentId();
        parentId = parentId == null ? "" : parentId;
        String newParentId = tmPositionVo.getParentId();
        String string = newParentId = newParentId == null ? "" : newParentId;
        return !newParentId.equals(parentId);
    }

    @Override
    public void saveTmPosition(TmPositionVo tmPositionVo, Page page) {
        boolean flag = false;
        flag = this.checkIsUpdateCodeRule(tmPositionVo);
        IdInitEntity tmPositionEntity = null;
        String positionId = "";
        if (this.tmPositionExtendService != null) {
            try {
                this.tmPositionExtendService.validate(tmPositionVo, page);
            }
            catch (BusinessException e) {
                throw new BusinessException("\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7" + e.getMessage());
            }
            tmPositionEntity = this.tmPositionExtendService.saveBefore(tmPositionVo, page);
        }
        if (tmPositionEntity == null) {
            tmPositionEntity = new TmPositionVoToTmPositionEntity(this).apply(tmPositionVo);
        }
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.saveBefore((TmPositionEntity)tmPositionEntity, tmPositionVo, page);
        }
        if (StringUtil.isEmpty(tmPositionEntity.getId())) {
            ((TmPositionEntity)tmPositionEntity).setCodeRule("-1000");
        }
        this.saveOrUpdate(tmPositionEntity);
        positionId = tmPositionEntity.getId();
        if (this.tmPositionExtendService != null) {
            tmPositionEntity = this.tmPositionExtendService.savePost((TmPositionEntity)tmPositionEntity, tmPositionVo, page);
            this.tmPositionExtendService.saveActIdUserBefore((TmPositionEntity)tmPositionEntity, tmPositionVo, page);
        }
        this.saveActIdUser((TmPositionEntity)tmPositionEntity);
        String sendActiviti = ResourceUtil.getSysConfigProperty("sendActiviti");
        if (StringUtil.equals(sendActiviti, "Y")) {
            String[] role_ids;
            ArrayList<MembershipActivitiVo> membershipActivitiVos;
            SendActivitiUtil.activitiSaveUser(tmPositionVo.getPositionCode(), tmPositionVo.getPositionName());
            if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
                String[] role_ids2;
                TmPositionVo vo;
                String workflowRoleIds;
                membershipActivitiVos = new ArrayList<MembershipActivitiVo>();
                TmPositionVo query = new TmPositionVo();
                query.setId(tmPositionVo.getId());
                List<TmPositionVo> tmPositionVoList = this.findTmPositionList(tmPositionVo, null, "");
                if (tmPositionVoList != null && tmPositionVoList.size() > 0 && StringUtil.isNotBlank((String)(workflowRoleIds = (vo = tmPositionVoList.get(0)).getWorkflowRoleIds())) && (role_ids2 = workflowRoleIds.split(",")) != null && role_ids2.length > 0) {
                    for (int i = 0; i < role_ids2.length; ++i) {
                        TaActRoleEntity taActRoleEntity = this.taRoleService.get(TaActRoleEntity.class, (Serializable)((Object)role_ids2[i]));
                        MembershipActivitiVo membershipActivitiVo = new MembershipActivitiVo();
                        membershipActivitiVo.setPosCode(vo.getPositionCode());
                        membershipActivitiVo.setRoleCode(taActRoleEntity.getRoleCode());
                        membershipActivitiVos.add(membershipActivitiVo);
                    }
                    AjaxJson ajaxJson = SendActivitiUtil.activitiDeleteMembership(membershipActivitiVos);
                    if (!ajaxJson.isSuccess()) {
                        throw new BusinessException("\u540c\u6b65\u5de5\u4f5c\u6d41\u5931\u8d25");
                    }
                }
            }
            membershipActivitiVos = new ArrayList();
            if (StringUtil.isNotEmpty((String)tmPositionVo.getWorkflowRoleIds()) && (role_ids = tmPositionVo.getWorkflowRoleIds().split(",")) != null && role_ids.length > 0) {
                for (int i = 0; i < role_ids.length; ++i) {
                    TaActRoleEntity taActRoleEntity = this.taRoleService.get(TaActRoleEntity.class, (Serializable)((Object)role_ids[i]));
                    MembershipActivitiVo membershipActivitiVo = new MembershipActivitiVo();
                    membershipActivitiVo.setPosCode(tmPositionVo.getPositionCode());
                    membershipActivitiVo.setRoleCode(taActRoleEntity.getRoleCode());
                    membershipActivitiVos.add(membershipActivitiVo);
                }
                AjaxJson ajaxJson = SendActivitiUtil.activitiSaveMembership(membershipActivitiVos);
                if (!ajaxJson.isSuccess()) {
                    throw new BusinessException("\u540c\u6b65\u5de5\u4f5c\u6d41\u5931\u8d25");
                }
            }
        }
        String hql = "FROM TmRPositionRoleEntity where tmPosition.id is null";
        List list = this.findByHql(hql, new Object[0]);
        for (TmRPositionRoleEntity prole : list) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
        String hql1 = "FROM TmRPositionActRoleEntity where tmPosition.id is null";
        List list1 = this.findByHql(hql1, new Object[0]);
        for (TmRPositionActRoleEntity prole : list1) {
            String proleId = prole.getId();
            super.addLogAndRemoveInvalidInfo(proleId, prole, positionId, null);
        }
        this.executeSql("DELETE FROM TM_R_POSITION_ACT_ROLE WHERE POSITION_ID IS NULL", new Object[0]);
        if (flag) {
            this.updatePosCodeRule(tmPositionVo, (TmPositionEntity)tmPositionEntity);
        }
    }

    private void updatePosCodeRule(TmPositionVo tmPositionVo, TmPositionEntity tmPositionEntity) {
        String parentId = tmPositionVo.getParentId();
        if (StringUtil.isBlank((String)parentId)) {
            String sql = " select max(code_rule) as code_rule from tm_position where id <>? and IFNULL(parent_id,'')='' ";
            List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, tmPositionEntity.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionVos) && StringUtil.isNotBlank((String)positionVos.get(0).getCodeRule())) {
                String codeTemp = positionVos.get(0).getCodeRule();
                String code = codeTemp.substring(0, 4);
                code = code.replaceAll("^(0+)", "");
                int codeNum = Integer.valueOf(code);
                code = PosAndOrgCodeRuleUtil.createCodeRule("", codeNum + 1);
                this.updateAllCodeRuleForCode(code, tmPositionEntity.getId(), tmPositionEntity);
            } else {
                this.updateAllCodeRuleForCode("0001", tmPositionEntity.getId(), tmPositionEntity);
            }
        } else {
            String sqlSelf = " select max(code_rule) as code_rule from tm_position where PARENT_ID=? and id <> ? ";
            List<TmPositionVo> positionVoSelf = this.findBySql(TmPositionVo.class, sqlSelf, parentId, tmPositionEntity.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionVoSelf) && StringUtil.isNotBlank((String)positionVoSelf.get(0).getCodeRule())) {
                String codeTemp = positionVoSelf.get(0).getCodeRule();
                String code = codeTemp.substring(codeTemp.length() - 4, codeTemp.length());
                code = code.replaceAll("^(0+)", "");
                int codeNum = Integer.valueOf(code);
                code = PosAndOrgCodeRuleUtil.createCodeRule(codeTemp.substring(0, codeTemp.length() - 4), codeNum + 1);
                this.updateAllCodeRuleForCode(code, tmPositionEntity.getId(), tmPositionEntity);
            } else {
                String sql = " select id,code_rule from tm_position where id=? ";
                List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, parentId);
                TmPositionVo vo = positionVos.get(0);
                this.updateChild(vo.getId(), vo.getCodeRule());
            }
        }
    }

    private void saveActIdUser(TmPositionEntity tmPositionEntity) {
        ActIdUserEntity actIdUserEntity = new ActIdUserEntity();
        if (!StringUtil.isNotEmpty(actIdUserEntity)) {
            actIdUserEntity = new ActIdUserEntity();
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
        } else {
            actIdUserEntity.setId(tmPositionEntity.getPositionCode());
            actIdUserEntity.setRev(Globals.REV);
            actIdUserEntity.setLast(tmPositionEntity.getPositionName());
        }
        this.saveOrUpdate(actIdUserEntity);
    }

    @Override
    public void deleteTmPosition(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] positionIds;
            for (String positionId : positionIds = ids.split(",")) {
                TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                if (tmPositionEntity == null || !StringUtil.isNotEmpty((String)tmPositionEntity.getId())) continue;
                if (CollectionUtil.listNotEmptyNotSizeZero(tmPositionEntity.getTmPositionList())) {
                    throw new BusinessException("\u5305\u542b\u4e0b\u7ea7\u804c\u4f4d,\u65e0\u6cd5\u5220\u9664");
                }
                List<TmUserPositionEntity> list = this.findByProperty(TmUserPositionEntity.class, "tmPosition.id", tmPositionEntity.getId());
                for (TmUserPositionEntity userPosition : list) {
                    userPosition.setTmUser(this.get(TmUserEntity.class, (Serializable)((Object)userPosition.getTmUser().getId())));
                }
                this.deleteAllEntity(list);
                this.delete(tmPositionEntity);
                String sendActiviti = ResourceUtil.getSysConfigProperty("sendActiviti");
                if (!StringUtil.equals(sendActiviti, "Y")) continue;
                SendActivitiUtil.activitiDeleteUser(tmPositionEntity.getPositionCode());
            }
        }
    }

    @Override
    public AjaxJson startOrStopPosition(TmPositionVo tmPositionVo) {
        AjaxJson j = new AjaxJson();
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)tmPositionVo.getId()));
        if (StringUtil.isNotEmpty(positionEntity)) {
            if (positionEntity.getEnableStatus().equals(tmPositionVo.getEnableStatus())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmPositionVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                positionEntity.setEnableStatus(tmPositionVo.getEnableStatus());
                this.updateEntity(positionEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    @Override
    public ValidForm validateTmposition(TmPositionVo tmPositionVo, String param) {
        ValidForm validForm = new ValidForm();
        String hql = "";
        if (StringUtil.isNotEmpty((String)tmPositionVo.getId())) {
            if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
                List list;
                if (StringUtil.equals("0", tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionCode=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
                    if (!CollectionUtils.isEmpty(list)) {
                        validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
                if (StringUtil.equals("1", tmPositionVo.getType())) {
                    hql = "from TmPositionEntity where positionName=? and id<>? and enableStatus=?";
                    list = this.findByHql(hql, param, tmPositionVo.getId(), Globals.ZERO);
                    if (!CollectionUtils.isEmpty(list)) {
                        validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                        validForm.setStatus("n");
                    }
                }
            }
        } else if (StringUtil.isNotEmpty((String)tmPositionVo.getType())) {
            if (StringUtil.equals("0", tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionCode=? and enableStatus=?";
                List list = this.findByHql(hql, param, Globals.ZERO);
                if (!CollectionUtils.isEmpty(list)) {
                    validForm.setInfo("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.equals("1", tmPositionVo.getType())) {
                hql = "from TmPositionEntity where positionName=? and enableStatus=?";
                List nameList = this.findByHql(hql, param, Globals.ZERO);
                if (!CollectionUtils.isEmpty(nameList)) {
                    validForm.setInfo("\u804c\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    @Override
    public List<ComboTree> getPositionForComboTree(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        List<Object> positionList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            positionList = this.findByProperty(TmPositionEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            positionList = this.findByProperty(TmPositionEntity.class, "tmPosition.id", comboTree.getId());
        } else {
            Criterion cr = Restrictions.isNull((String)"tmPosition.id");
            positionList = this.findByCriteria(TmPositionEntity.class, cr);
        }
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "positionName", "positions");
        comboTrees = this.comboTree(positionList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public AjaxJson changePositionForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getPositionIds())) {
            String[] posIds;
            TmPositionEntity tmPositionEntity = null;
            TmOrgEntity tmOrgEntity = null;
            for (String posId : posIds = tmOrgVo.getPositionIds().split(",")) {
                tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)posId));
                if (!StringUtil.isNotEmpty(tmPositionEntity)) continue;
                tmOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)tmOrgVo.getOrgId()));
                tmPositionEntity.setTmOrg(tmOrgEntity);
                tmPositionEntity.setTmPosition(null);
                this.saveOrUpdate(tmPositionEntity);
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }

    @Override
    public void changeTmPosition(TmPositionVo tmPositionVo) {
        String hql = " from TmUserPositionEntity up where up.tmUser.id=? ";
        List userPositionEntities = this.findByHql(hql, tmPositionVo.getUserId());
        TmPositionEntity pos = new TmPositionEntity();
        if (CollectionUtil.listNotEmptyNotSizeZero(userPositionEntities)) {
            for (TmUserPositionEntity entity : userPositionEntities) {
                if (tmPositionVo.getId().equals(entity.getTmPosition().getId())) {
                    pos = entity.getTmPosition();
                    entity.setIsMain("0");
                } else {
                    entity.setIsMain("1");
                }
                this.updateEntity(entity);
            }
        } else {
            return;
        }
        ResourceUtil.addString("position", tmPositionVo.getId());
        String key = AppcenterUtil.getUserKey();
        UserRedis userRedis = UserUtils.getUser();
        userRedis.setPosCode(pos.getPositionCode());
        userRedis.setPosId(pos.getId());
        userRedis.setPosName(pos.getPositionName());
        userRedis.setPoscoderule(pos.getCodeRule());
        userRedis.setOrgId(pos.getTmOrg().getId());
        userRedis.setOrgcoderule(pos.getTmOrg().getCodeRule());
        userRedis.setOrgCode(pos.getTmOrg().getOrgCode());
        String value = JsonUtil.bean2json(userRedis);
        this.redisService.setSeconds("LOGIN_SUCCESS_" + key, value, 86400L);
    }

    @Override
    public List<TmPositionVo> findPositionListByOrgId(String orgId) {
        String hql = "from TmPositionEntity pe where tmOrg.id = ?";
        List entityList = this.findByHql(hql, orgId);
        List list = Lists.transform(entityList, (Function)new TmPositionEntityToTmPositionVo());
        return list;
    }

    @Override
    public List<TmPositionVo> findOtherTmUserInfo() {
        String userId = ResourceUtil.getSessionTmUserVo().getId();
        TmPositionVo tmPositionVo = new TmPositionVo();
        tmPositionVo.setUserId(userId);
        return this.tmPositionDao.findOtherTmUserInfo(tmPositionVo);
    }

    @Override
    public List<TmPositionVo> findPositionByConditions(TmPositionVo query, Page page) {
        List<TmPositionVo> list = this.tmPositionDao.findTmPositionParentByCondition(query, page);
        return list;
    }

    @Override
    public List<TmPositionVo> findTmPositionByAllPossible(QueryTmpositionVo queryTmpositionVo, Page page) {
        return this.tmPositionDao.findTmPositionByAllPossible(queryTmpositionVo, page);
    }

    @Override
    public List<TmLogVo> findPositionLogList(TmLogVo tmLogVo, Page page) {
        return this.tmPositionDao.findPositionLogList(tmLogVo, page);
    }

    @Override
    public long isMainPosition(String posId) {
        String sql = "select count(1) from tm_r_user_position where position_id=? and is_main=?";
        long count = this.getCountForJdbcParam(sql, posId, Globals.Main_Position_Type);
        return count;
    }

    @Override
    public void updatePositionIsMain(String userId, String mainPosId) {
        String sql1 = " update tm_r_user_position set is_main = ? where user_id=? ";
        this.executeSql(sql1, Globals.PartTime_Position_Type, userId);
        String sql2 = " update tm_r_user_position set is_main = ? where position_id=? ";
        this.executeSql(sql2, Globals.Main_Position_Type, mainPosId);
    }

    @Override
    public void addPositionRoleRelation(String positionIds, String roleId) {
        String[] positionIdArr;
        for (String positionId : positionIdArr = positionIds.split(",")) {
            this.addPositionRoleRelationItem(positionId, roleId);
        }
    }

    @Override
    public void addPositionActRoleRelation(String positionIds, String roleId) {
        String[] positionIdArr;
        for (String positionId : positionIdArr = positionIds.split(",")) {
            this.addPositionActRoleRelationItem(positionId, roleId);
        }
    }

    private void addPositionRoleRelationItem(String positionId, String roleId) {
        String hql = "from TmRPositionRoleEntity where tmRole.id = ? and tmPosition.id = ?";
        List rPositionRoleEntityList = this.findByHql(hql, roleId, positionId);
        if (CollectionUtil.listNotEmptyNotSizeZero(rPositionRoleEntityList)) {
            throw new BusinessException("\u5df2\u7ecf\u5173\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        TmRPositionRoleEntity rPositionRoleEntity = new TmRPositionRoleEntity();
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        if (positionEntity == null) {
            throw new BusinessException("\u804c\u4f4dId\u503c\u4e0d\u5b58\u5728");
        }
        TmRoleEntity roleEntity = this.get(TmRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        rPositionRoleEntity.setTmPosition(positionEntity);
        rPositionRoleEntity.setTmRole(roleEntity);
        this.save(rPositionRoleEntity);
    }

    private void addPositionActRoleRelationItem(String positionId, String roleId) {
        String hql = "from TmRPositionActRoleEntity where tmActRole.id = ? and tmPosition.id = ?";
        List rPositionActRoleEntityList = this.findByHql(hql, roleId, positionId);
        if (CollectionUtil.listNotEmptyNotSizeZero(rPositionActRoleEntityList)) {
            throw new BusinessException("\u5df2\u7ecf\u5173\u8054\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        TmRPositionActRoleEntity rPositionActRoleEntity = new TmRPositionActRoleEntity();
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        if (positionEntity == null) {
            throw new BusinessException("\u804c\u4f4dId\u503c\u4e0d\u5b58\u5728");
        }
        TmActRoleEntity roleEntity = this.get(TmActRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        rPositionActRoleEntity.setTmPosition(positionEntity);
        rPositionActRoleEntity.setTmActRole(roleEntity);
        this.save(rPositionActRoleEntity);
    }

    @Override
    public void deletePositionRoleRelation(String relationIds) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            TmRPositionRoleEntity rPositionRoleEntity = this.get(TmRPositionRoleEntity.class, (Serializable)((Object)relationId));
            this.addDeletePositionRoleRelationLog(rPositionRoleEntity);
            this.delete(rPositionRoleEntity);
        }
    }

    @Override
    public void deletePositionActRoleRelation(String relationIds) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            TmRPositionActRoleEntity rPositionActRoleEntity = this.get(TmRPositionActRoleEntity.class, (Serializable)((Object)relationId));
            this.addDeletePositionActRoleRelationLog(rPositionActRoleEntity);
            this.delete(rPositionActRoleEntity);
        }
    }

    private void addDeletePositionRoleRelationLog(TmRPositionRoleEntity rPositionRoleEntity) {
        String logContent = "\u53d6\u6d88\u5173\u8054\u89d2\u8272[" + rPositionRoleEntity.getTmRole().getRoleCode() + "-" + rPositionRoleEntity.getTmRole().getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(), logContent);
    }

    private void addDeletePositionActRoleRelationLog(TmRPositionActRoleEntity rPositionActRoleEntity) {
        String logContent = "\u53d6\u6d88\u5173\u8054\u89d2\u8272[" + rPositionActRoleEntity.getTmActRole().getRoleCode() + "-" + rPositionActRoleEntity.getTmActRole().getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionActRoleEntity.getId(), rPositionActRoleEntity, rPositionActRoleEntity.getTmPosition().getId(), logContent);
    }

    @Override
    public void updatePositionRoleRelation(String relationIds, String roleId) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            this.updatePositionRoleRelationItem(relationId, roleId);
        }
    }

    @Override
    public void updatePositionActRoleRelation(String relationIds, String roleId) {
        String[] relationIdArr;
        for (String relationId : relationIdArr = relationIds.split(",")) {
            this.updatePositionActRoleRelationItem(relationId, roleId);
        }
    }

    @Override
    public List<TmPositionEntity> findBelowPosIdByPosId(String posId) {
        return this.tmPositionDao.findBelowPosIdByPosId(posId);
    }

    private void updatePositionRoleRelationItem(String relationId, String roleId) {
        TmRPositionRoleEntity rPositionRoleEntity = this.get(TmRPositionRoleEntity.class, (Serializable)((Object)relationId));
        TmRoleEntity roleEntity = this.get(TmRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        this.addUpdatePositionRoleRelationItemLog(rPositionRoleEntity, roleEntity);
        rPositionRoleEntity.setTmRole(roleEntity);
        this.updateEntity(rPositionRoleEntity);
    }

    private void updatePositionActRoleRelationItem(String relationId, String roleId) {
        TmRPositionActRoleEntity rPositionActRoleEntity = this.get(TmRPositionActRoleEntity.class, (Serializable)((Object)relationId));
        TmActRoleEntity roleEntity = this.get(TmActRoleEntity.class, (Serializable)((Object)roleId));
        if (roleEntity == null) {
            throw new BusinessException("\u89d2\u8272Id\u503c\u4e0d\u5b58\u5728");
        }
        this.addUpdatePositionActRoleRelationItemLog(rPositionActRoleEntity, roleEntity);
        rPositionActRoleEntity.setTmActRole(roleEntity);
        this.updateEntity(rPositionActRoleEntity);
    }

    private void addUpdatePositionRoleRelationItemLog(TmRPositionRoleEntity rPositionRoleEntity, TmRoleEntity newRoleEntity) {
        String logContent = "\u66ff\u6362\u89d2\u8272[" + rPositionRoleEntity.getTmRole().getRoleCode() + "-" + rPositionRoleEntity.getTmRole().getRoleName() + "]\u4e3a[" + newRoleEntity.getRoleCode() + "-" + newRoleEntity.getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionRoleEntity.getId(), rPositionRoleEntity, rPositionRoleEntity.getTmPosition().getId(), logContent, "UPDATE");
    }

    private void addUpdatePositionActRoleRelationItemLog(TmRPositionActRoleEntity rPositionActRoleEntity, TmActRoleEntity newRoleEntity) {
        String logContent = "\u66ff\u6362\u89d2\u8272[" + rPositionActRoleEntity.getTmActRole().getRoleCode() + "-" + rPositionActRoleEntity.getTmActRole().getRoleName() + "]\u4e3a[" + newRoleEntity.getRoleCode() + "-" + newRoleEntity.getRoleName() + "]";
        super.addLogAndRemoveInvalidInfo(rPositionActRoleEntity.getId(), rPositionActRoleEntity, rPositionActRoleEntity.getTmPosition().getId(), logContent, "UPDATE");
    }

    @Override
    public void updateAllCodeRule() {
        String updateSqlALl = " update  tm_position set code_rule = id ";
        this.updateBySql(updateSqlALl, new Object[0]);
        String sql = " select id,code_rule from tm_position where PARENT_ID='' or PARENT_ID is null order by id ";
        List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, new Object[0]);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            for (int i = 0; i < positionVos.size(); ++i) {
                String id = positionVos.get(i).getId();
                String codeRule = PosAndOrgCodeRuleUtil.createCodeRule("", i + 1);
                String updateSql = " update tm_position set code_rule = ? where id=? ";
                this.executeSql(updateSql, codeRule, id);
                this.updateChild(id, codeRule);
            }
        }
    }

    private void updateAllCodeRuleForCode(String ruelCode, String id, TmPositionEntity tmPositionEntity) {
        tmPositionEntity.setCodeRule(ruelCode);
        String updateSlq = " update tm_position set code_rule = '" + ruelCode + "' where id = '" + tmPositionEntity.getId() + "' ";
        this.executeSql(updateSlq, new Object[0]);
        this.updateChild(id, ruelCode);
    }

    public void updateChild(String parentId, String parentCodeRule) {
        String sql = " select id,code_rule from tm_position where PARENT_ID=? order by id";
        List<TmPositionVo> positionVos = this.findBySql(TmPositionVo.class, sql, parentId);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            for (int i = 0; i < positionVos.size(); ++i) {
                String id = positionVos.get(i).getId();
                String codeRule = PosAndOrgCodeRuleUtil.createCodeRule(parentCodeRule, i + 1);
                String updateSql = " update tm_position set code_rule = ? where id=? ";
                this.executeSql(updateSql, codeRule, id);
                this.updateChild(id, codeRule);
            }
        }
    }
}

