/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.role.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.role.dao.TmRoleDao;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleExtendService;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.transform.TmRoleEntityToTmRoleVo;
import com.biz.eisp.mdm.role.transform.TmRoleVoToTmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="roleService")
@Transactional
public class TmRoleServiceImpl
extends BaseServiceImpl
implements TmRoleService {
    @Autowired
    private TmRoleDao tmRoleDao;
    @Autowired(required=false)
    private TmRoleExtendService tmRoleExtendService;
    private static final int VALIDATE_ROLECODE = 0;
    private static final int VALIDATE_ROLENAME = 1;

    @Override
    public List<TmRoleEntity> getRoleListByCurrentPosId(TmRoleVo tmRole, Page page) throws BusinessException {
        return this.tmRoleDao.getRoleListByCurrentPosId(tmRole, page);
    }

    @Override
    public List<TmRoleEntity> findRoleList(TmRoleVo tmRole, Page page) throws BusinessException {
        return this.tmRoleDao.findRoleList(tmRole, page);
    }

    @Override
    public List<TmRoleEntity> findPage(Page page, TmRoleEntity tmRole) {
        StringBuffer hql = new StringBuffer("from TmRoleEntity t");
        List<TmRoleEntity> list = null;
        if (tmRole == null) {
            list = this.findByHql(hql.toString(), page, new Object[0]);
        } else {
            hql.append(" where t.roleCode like ? and t.roleName like ?");
            String code = tmRole.getRoleCode();
            String name = tmRole.getRoleName();
            Object[] obj = new Object[]{code != null && !code.equals("undefind") ? "%" + tmRole.getRoleCode().trim() + "%" : "%%", name != null && !name.equals("undefind") ? "%" + tmRole.getRoleName().trim() + "%" : "%%"};
            list = this.findByHql(hql.toString(), page, obj);
        }
        return list;
    }

    @Override
    public void createTmRole(TmRoleVo tmRoleVo, Page page) {
        TmRoleEntity tmRoleEntity = null;
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            try {
                this.tmRoleExtendService.validate(tmRoleVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmRoleEntity = this.tmRoleExtendService.saveBefore(tmRoleVo, page);
        }
        if (StringUtil.isEmpty(tmRoleEntity)) {
            tmRoleEntity = new TmRoleVoToTmRoleEntity(this).apply(tmRoleVo);
        }
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            tmRoleEntity = this.tmRoleExtendService.saveBefore(tmRoleEntity, tmRoleVo, page);
        }
        this.saveOrUpdate(tmRoleEntity);
        if (StringUtil.isNotEmpty(this.tmRoleExtendService)) {
            tmRoleEntity = this.tmRoleExtendService.savePost(tmRoleEntity, tmRoleVo, page);
        }
    }

    @Override
    public AjaxJson startOrStopRole(TmRoleVo tmRoleVo) {
        AjaxJson j = new AjaxJson();
        TmRoleEntity roleEntity = this.get(TmRoleEntity.class, (Serializable)((Object)tmRoleVo.getId()));
        if (StringUtil.isNotEmpty(roleEntity)) {
            if (roleEntity.getEnableStatus().equals(tmRoleVo.getEnableStatus())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmRoleVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                roleEntity.setEnableStatus(tmRoleVo.getEnableStatus());
                this.updateEntity(roleEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }

    @Override
    public boolean deleteTmRole(String id) {
        TmRoleEntity roleEntity = this.get(TmRoleEntity.class, (Serializable)((Object)id));
        if (StringUtil.isNotEmpty(roleEntity)) {
            if (Globals.Admin_Name.equalsIgnoreCase(roleEntity.getRoleName())) {
                return false;
            }
        } else {
            return false;
        }
        this.deleteRelationData(id);
        super.deleteEntityById(TmRoleEntity.class, (Serializable)((Object)id));
        return true;
    }

    private void deleteRelationData(String roleId) {
        this.deleteRelationFunctionAuth(roleId);
        this.deleteRelationFunction(roleId);
        this.deleteRelationPosition(roleId);
    }

    private void deleteRelationPosition(String roleId) {
        String sql = "delete from tm_r_position_role where role_id = ?";
        this.executeSql(sql, roleId);
    }

    private void deleteRelationFunctionAuth(String roleId) {
        String sql = "DELETE from tm_r_role_func_authobj WHERE role_function_id IN (SELECT ID FROM tm_r_role_function WHERE role_id = ? )";
        this.executeSql(sql, roleId);
    }

    private void deleteRelationFunction(String roleId) {
        String sql = "delete from tm_r_role_function where role_id = ?";
        this.executeSql(sql, roleId);
    }

    @Override
    public Map<String, String> updateTmRole(TmRoleEntity tmRole) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<TmRoleEntity> li1 = this.validate(0, tmRole.getRoleCode());
        if (li1.size() == 0 || li1.get(0).getId().equals(tmRole.getId())) {
            li1 = this.validate(1, tmRole.getRoleName());
            if (li1.size() == 0 || li1.get(0).getId().equals(tmRole.getId())) {
                TmRoleEntity role = super.get(TmRoleEntity.class, (Serializable)((Object)tmRole.getId()));
                role.setRoleCode(tmRole.getRoleCode());
                role.setRoleName(tmRole.getRoleName());
                role.setUpdateDate(new Date());
                Client client = ResourceUtil.getClient();
                String name = client.getUser().getUserName();
                role.setUpdateName(name);
                super.updateEntity(role);
                map.put("success", "true");
            } else {
                map.put("success", "false");
                map.put("msg", "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
            }
        } else {
            map.put("success", "false");
            map.put("msg", "\u89d2\u8272\u7f16\u7801\u91cd\u590d");
        }
        return map;
    }

    public List<TmRoleEntity> validate(int flag, String str) {
        String hql = null;
        Object[] obj = new Object[]{str};
        if (flag == 1) {
            hql = "from TmRoleEntity t where t.roleName = ?";
        } else if (flag == 0) {
            hql = "from TmRoleEntity t where t.roleCode = ?";
        }
        return super.findByHql(hql, obj);
    }

    @Override
    public ValidForm validateTmRoleForm(TmRoleEntity tmRole) {
        ValidForm validForm = new ValidForm();
        String hql = null;
        if (StringUtil.isEmpty(tmRole.getId())) {
            if (StringUtil.isNotEmpty((String)tmRole.getRoleCode())) {
                hql = "from TmRoleEntity t where t.roleCode = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleCode()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)tmRole.getRoleName())) {
                hql = "from TmRoleEntity t where t.roleName = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleName()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        } else {
            if (StringUtil.isNotEmpty((String)tmRole.getRoleCode())) {
                hql = "from TmRoleEntity t where t.roleCode = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleCode(), tmRole.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)tmRole.getRoleName())) {
                hql = "from TmRoleEntity t where t.roleName = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, tmRole.getRoleName(), tmRole.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    @Override
    public List<TmRoleVo> findTmRoleByPostionId(String positionId) {
        String sql = "select t1.* from tm_role t1 where t1.id in (select t2.role_id from tm_r_position_role t2 where t2.position_id = ?)";
        List<TmRoleEntity> roles = this.findBySql(TmRoleEntity.class, sql, positionId);
        ArrayList<TmRoleVo> result = new ArrayList<TmRoleVo>();
        for (TmRoleEntity e : roles) {
            TmRoleVo v = new TmRoleEntityToTmRoleVo().apply(e);
            result.add(v);
        }
        return result;
    }

    @Override
    public List<TmRoleVo> findTmRoleByUserId(String userId) {
        String sql = "select t1.* from tm_role t1 where t1.id in (select t2.role_id from tm_r_position_role t2 where t2.position_id  in (select position_id from tm_r_user_position where user_id=? and sysdate between  start_date and end_date))";
        List<TmRoleEntity> roles = this.findBySql(TmRoleEntity.class, sql, userId);
        ArrayList<TmRoleVo> result = new ArrayList<TmRoleVo>();
        for (TmRoleEntity e : roles) {
            TmRoleVo v = new TmRoleEntityToTmRoleVo().apply(e);
            result.add(v);
        }
        return result;
    }

    @Override
    public List<TmRoleVo> findTmRoleByUsername(String username) {
        String sql = " select a1.*  from TM_ROLE a1  where a1.ID in (  select b1.role_id  from tm_r_position_role b1  where b1.position_id  in (select c1.position_id  from tm_r_user_position c1  where c1.USER_ID = (  select d1.id  from tm_user d1  where d1.USERNAME = ?)  and SYSDATE() between c1.start_date and c1.end_date)) ";
        List<TmRoleEntity> roles = this.findBySql(TmRoleEntity.class, sql, username);
        ArrayList<TmRoleVo> result = new ArrayList<TmRoleVo>();
        for (TmRoleEntity e : roles) {
            TmRoleVo v = new TmRoleEntityToTmRoleVo().apply(e);
            result.add(v);
        }
        return result;
    }

    @Override
    public boolean checkRoleAu(String userId) {
        boolean b = false;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            List<KnlDictDataEntity> datas;
            List<TmRoleVo> roleusers = this.findTmRoleByUserId(userId);
            HashSet<String> set = new HashSet<String>();
            if (roleusers != null) {
                for (TmRoleVo ru : roleusers) {
                    if (!StringUtils.isBlank((CharSequence)ru.getRoleCode())) continue;
                    set.add(ru.getRoleCode());
                }
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(datas = DictUtil.getDictList("role_au"))) {
                for (KnlDictDataEntity dt : datas) {
                    if (!set.contains(dt.getDictCode())) continue;
                    b = true;
                    break;
                }
            }
        }
        return b;
    }

    @Override
    public List<TmRoleVo> findNoSelfRoleList(TmRoleVo tmRoleVo, String selfRoleId, Page page) {
        List<TmRoleVo> voList = this.tmRoleDao.findNoSelfRoleList(tmRoleVo, selfRoleId, page);
        return voList;
    }

    @Override
    public List<TmRoleInfoExportVo> findExportRoleInfoList(TmRoleInfoExportVo tmRoleInfoExportVo) {
        List<TmRoleInfoExportVo> voList = this.tmRoleDao.findExportRoleInfoList(tmRoleInfoExportVo);
        return voList;
    }
}

