/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.login.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.vo.BaseVo;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.login.entity.TmSysLoginLogEntity;
import com.biz.eisp.login.service.JumpMainExtendService;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.utils.LoginParamUtils;
import com.biz.eisp.login.utils.Snippet;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.util.SysParamUtil;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.AppLoginVo;
import com.biz.eisp.mdm.user.vo.LoginUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import com.biz.eisp.mdm.web.system.service.MutiLangServiceI;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/loginController"})
public class LoginController
extends BaseController {
    private Logger log = Logger.getLogger(LoginController.class);
    @Autowired
    private LoginService loginService;
    @Autowired
    private MenuPermissionService menuPermissionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private JumpMainExtendService jumpMainExtendService;
    @Autowired
    private MutiLangServiceI mutiLangService;
    @Autowired
    private TmFunctionService tmFunctionService;

    @RequestMapping(params={"upLangCode"})
    @ResponseBody
    public AjaxJson upLangCode(String langCode, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        j.setMsg("\u9a8c\u8bc1\u6210\u529f");
        this.mutiLangService.setLangCode(langCode);
        return j;
    }

    @RequestMapping(params={"findLangCode"})
    @ResponseBody
    public AjaxJson findLangCode(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String langCode = "";
        HttpSession session = ContextHolderUtils.getSession();
        if (null != session) {
            String key;
            String sessionId = session.getId();
            RedisService redisService = RedisUtils.getRedisService();
            Object object = redisService.get(key = "LANG_CODE_" + sessionId);
            if (object != null) {
                langCode = object.toString();
            } else {
                langCode = ResourceUtil.getSysConfigProperty((String)"defaultMutiLang");
                redisService.setDays(key, (Object)langCode, 30L);
            }
        }
        if (StringUtil.isEmpty((String)langCode)) {
            langCode = ResourceUtil.getSysConfigProperty((String)"defaultMutiLang");
        }
        j.setObj((Object)langCode);
        return j;
    }

    @RequestMapping(params={"validateUser"})
    @ResponseBody
    public AjaxJson validateUser(TmUserEntity tmUserEntity, HttpServletRequest request, HttpServletResponse response) {
        boolean flag;
        AjaxJson j = new AjaxJson();
        j.setMsg("\u9a8c\u8bc1\u6210\u529f");
        String langCode = tmUserEntity.getLangCode();
        if (StringUtil.isEmpty((String)langCode)) {
            langCode = "zh_cn";
            tmUserEntity.setLangCode(langCode);
        }
        if (!(flag = this.swithPassWord(tmUserEntity, request))) {
            j.setMsg("\u5bc6\u7801\u89e3\u7801\u9519\u8bef");
            j.setSuccess(false);
            return j;
        }
        try {
            UserRedis user = UserUtils.getUser();
            if (user != null && StringUtil.isNotBlank((String)user.getUsername()) && !user.getUsername().equals(tmUserEntity.getUserName())) {
                j.setSuccess(false);
                if (StringUtil.isEmpty((String)user.getUsername())) {
                    j.setMsg("\u8be5\u6d4f\u89c8\u5668\u5df2\u7ecf\u767b\u5f55\u8fc7\u8d26\u53f7:" + user.getCustcode() + "\u672a\u6b63\u5e38\u9000\u51fa,\u8bf7\u5148\u9000\u51fa\u518d\u767b\u5f55");
                } else {
                    j.setMsg("\u8be5\u6d4f\u89c8\u5668\u5df2\u7ecf\u767b\u5f55\u8fc7\u8d26\u53f7:" + user.getUsername() + "\u672a\u6b63\u5e38\u9000\u51fa,\u8bf7\u5148\u9000\u51fa\u518d\u767b\u5f55");
                }
                return j;
            }
            j = this.loginService.validateUser(tmUserEntity, Globals.N, Globals.N, request, response);
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg("\u767b\u5f55\u8ba4\u8bc1\u7f13\u5b58\u5931\u8d25\u8bf7\u91cd\u65b0\u5c1d\u8bd5!");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u670d\u52a1\u5668\u5f02\u5e38");
            e.printStackTrace();
            throw new BusinessException("\u767b\u5f55\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return j;
    }

    @RequestMapping(params={"login"})
    public ModelAndView login(TmUserEntity tmUserEntity, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        try {
            AjaxJson j;
            if (StringUtils.isEmpty((String)tmUserEntity.getUserName()) || StringUtils.isEmpty((String)tmUserEntity.getPassword())) {
                modelAndView.setViewName("login/login");
                return modelAndView;
            }
            String langCode = tmUserEntity.getLangCode();
            if (StringUtil.isEmpty((String)langCode)) {
                langCode = "zh_cn";
                tmUserEntity.setLangCode(langCode);
            }
            if ((j = this.loginService.validateUser(tmUserEntity, Globals.Y, Globals.N, request, response)).isSuccess()) {
                HttpSession session = ContextHolderUtils.getSession();
                request.getSession().setAttribute("sessionId", (Object)session.getId());
                TmUserVo userVo = new TmUserVo();
                userVo.setUserName(tmUserEntity.getUserName());
                userVo = this.tmUserService.getTmUser(userVo);
                if (this.hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
                    modelAndView.setViewName("login/loginFirst");
                    modelAndView.addObject("tmUserVo", (Object)userVo);
                    return modelAndView;
                }
                String webSeparate = ResourceUtil.getSysConfigProperty((String)"webSeparate");
                if (webSeparate.equals("N") && userVo.getUserType().equals(Globals.CUST_USER)) {
                    String crmMainPort = ResourceUtil.getSysConfigProperty((String)"crmMainPort");
                    if (StringUtils.isNotBlank((String)userVo.getCustCode())) {
                        KnlParameterManageEntity knlParameterManageEntity = SysParamUtil.getPatamByCode((String)"dms_page_url");
                        String url = knlParameterManageEntity == null ? "" : knlParameterManageEntity.getParameterValue();
                        String requestPath = request.getScheme() + "://" + request.getServerName() + ":" + crmMainPort + url;
                        response.sendRedirect(requestPath);
                        return null;
                    }
                    modelAndView.setViewName("login/login");
                } else {
                    String title;
                    if (StringUtil.isNotEmpty((Object)this.jumpMainExtendService)) {
                        this.jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
                    }
                    request.setAttribute("title", (Object)(StringUtils.isNotBlank((String)(title = DictUtil.getDicDataCodeByVal((String)"main_title", (String)"title"))) ? title : "\u535a\u667a\u4fe1\u606f"));
                    String maintitle = DictUtil.getDicDataCodeByVal((String)"main_title", (String)"maintitle");
                    request.setAttribute("maintitle", (Object)(StringUtils.isNotBlank((String)maintitle) ? maintitle : "EISP\u8425\u9500\u4e2d\u53f0"));
                    request.setAttribute("userVo", (Object)userVo);
                    String url = ResourceUtil.getSysConfigProperty((String)"websocketUrl");
                    String sid = UUID.randomUUID().toString();
                    String userKey = AppcenterUtil.getUserKey();
                    RedisService redisService = RedisUtils.getRedisService();
                    redisService.setSeconds("WEBSOCKT_KEY_" + sid, (Object)userKey, 86400L);
                    url = url + "user/" + sid;
                    request.setAttribute("userWebsocketUrl", (Object)url);
                    modelAndView.setViewName("main/main");
                }
                return modelAndView;
            }
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
        catch (BusinessException e) {
            modelAndView.setViewName("login/login");
            request.setAttribute("showError", (Object)e.getMessage());
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
    }

    @RequestMapping(params={"loginPc"})
    @ResponseBody
    public AjaxJson loginPc(@RequestBody LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (loginUserVo == null || StringUtil.isEmpty((String)loginUserVo.getPassword()) || StringUtil.isEmpty((String)loginUserVo.getUsername())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
                return ajaxJson;
            }
            String userName = Snippet.aesDecrypt((String)loginUserVo.getUsername(), (String)LoginParamUtils.getEncryptKey());
            String password = Snippet.aesDecrypt((String)loginUserVo.getPassword(), (String)LoginParamUtils.getEncryptKey());
            loginUserVo.setUsername(userName);
            loginUserVo.setPassword(password);
            ajaxJson = this.loginService.validateUserPc(loginUserVo, request, response);
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"loginApp"})
    @ResponseBody
    public AjaxJson loginApp(@RequestBody LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (loginUserVo == null || StringUtil.isEmpty((String)loginUserVo.getPassword()) || StringUtil.isEmpty((String)loginUserVo.getUsername())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            }
            if (!(ajaxJson = this.loginService.validateUserApp(loginUserVo, request, response)).isSuccess()) {
                return ajaxJson;
            }
            AppLoginVo appLoginVo = new AppLoginVo();
            List list = this.tmFunctionService.findMobileTerminalMenuList(1, loginUserVo.getUsername());
            appLoginVo.setMenuList(list);
            UserRedis userRedis = (UserRedis)ajaxJson.getObj();
            appLoginVo.setUsername(userRedis.getUsername());
            appLoginVo.setStaffcode(userRedis.getStaffcode());
            appLoginVo.setRealName(userRedis.getRealname());
            appLoginVo.setPostId(userRedis.getPosId());
            appLoginVo.setPostName(userRedis.getPosName());
            appLoginVo.setOrgCode(userRedis.getOrgCode());
            appLoginVo.setPosCode(userRedis.getPosCode());
            appLoginVo.setToken(ajaxJson.getFlagId());
            appLoginVo.setPhoneNumber(userRedis.getPhoneNumber());
            appLoginVo.setOrgName(userRedis.getOrgName());
            ajaxJson.setObj((Object)appLoginVo);
            KnlParameterManageEntity parameterManageEntity = SysParamUtil.getPatamByCode((String)Globals.SFA_BIND_PHONE);
            if (parameterManageEntity != null) {
                if (StringUtil.isNotEmpty((String)loginUserVo.getImei())) {
                    this.loginService.bindPhone(loginUserVo, parameterManageEntity);
                } else {
                    ajaxJson.setSuccess(false);
                    ajaxJson.setMsg("\u6ca1\u6709\u4f20\u624b\u673aIMEI\uff01");
                }
            }
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"loginWx"})
    @ResponseBody
    public AjaxJson loginWx(@RequestBody LoginUserVo loginUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (loginUserVo == null || StringUtil.isEmpty((String)loginUserVo.getPassword()) || StringUtil.isEmpty((String)loginUserVo.getUsername()) || StringUtil.isEmpty((String)loginUserVo.getCode())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            }
            if (!(ajaxJson = this.loginService.validateUserWx(loginUserVo, request, response)).isSuccess()) {
                return ajaxJson;
            }
            AppLoginVo appLoginVo = new AppLoginVo();
            List list = null;
            int userType = this.tmUserService.getUserTypeByUserName(loginUserVo.getUsername());
            if (userType == Globals.DISTRIBUTOR_AGENT) {
                list = this.tmFunctionService.findMobileTerminalMenuList(2, loginUserVo.getUsername());
            }
            appLoginVo.setMenuList(list);
            UserRedis userRedis = (UserRedis)ajaxJson.getObj();
            appLoginVo.setRealName(userRedis.getRealname());
            appLoginVo.setPostId(userRedis.getPosId());
            appLoginVo.setPostName(userRedis.getPosName());
            appLoginVo.setToken(ajaxJson.getFlagId());
            BaseVo vo = ajaxJson.getVo();
            if (vo != null) {
                appLoginVo.setCustItemId(vo.getId());
                appLoginVo.setUserType(vo.getUserType());
            }
            ajaxJson.setObj((Object)appLoginVo);
        }
        catch (BusinessException be) {
            be.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(be.getMessage());
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"apiLogin"})
    public ModelAndView apiLogin(TmUserEntity tmUserEntity, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        ModelAndView modelAndView = new ModelAndView();
        String isEncryption = OConvertUtils.getString((String)request.getParameter("isEncryption"));
        if (StringUtil.isEmpty((String)isEncryption)) {
            isEncryption = Globals.N;
        }
        try {
            if (StringUtils.isEmpty((String)tmUserEntity.getUserName()) || StringUtils.isEmpty((String)tmUserEntity.getPassword())) {
                modelAndView.setViewName("login/login");
                return modelAndView;
            }
            j = this.loginService.validateUser(tmUserEntity, Globals.Y, isEncryption, request, response);
            if (j.isSuccess()) {
                HttpSession session = ContextHolderUtils.getSession();
                request.getSession().setAttribute("sessionId", (Object)session.getId());
                TmUserVo userVo = new TmUserVo();
                userVo.setUserName(tmUserEntity.getUserName());
                userVo = this.tmUserService.getTmUser(userVo);
                if (this.hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
                    modelAndView.setViewName("login/loginFirst");
                    modelAndView.addObject("tmUserVo", (Object)userVo);
                    return modelAndView;
                }
                if (userVo.getUserType() == Globals.CUST_USER) {
                    if (StringUtils.isNotBlank((String)userVo.getCustCode())) {
                        TmCustomerEntity customerEntity = new TmCustomerEntity();
                        customerEntity.setId(userVo.getCustId());
                        customerEntity.setCustomerCode(userVo.getCustCode());
                        customerEntity.setErpCode(userVo.getErpCode());
                        customerEntity.setCustomerName(userVo.getCustName());
                        Client client = ResourceUtil.getClient();
                        client.setCustomerEntity(customerEntity);
                        ResourceUtil.setClient((Client)client);
                        String customerIndexPage = ResourceUtil.getSysConfigProperty((String)"customerIndexPage");
                        request.setAttribute("customer", (Object)customerEntity);
                        modelAndView.setViewName(StringUtils.isNotBlank((String)customerIndexPage) ? customerIndexPage : "login/errorCustomerIndex");
                    } else {
                        modelAndView.setViewName("login/login");
                    }
                } else {
                    if (StringUtil.isNotEmpty((Object)this.jumpMainExtendService)) {
                        this.jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
                    }
                    request.setAttribute("userVo", (Object)userVo);
                    modelAndView.setViewName("main/main");
                }
                return modelAndView;
            }
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
        catch (Exception e) {
            modelAndView.setViewName("login/login");
            return modelAndView;
        }
    }

    private boolean hasFirstChangePwdView(TmUserVo tmUserVo) {
        String hasFirstTimeChange;
        KnlParameterManageEntity knlParameterManageEntity = SysParamUtil.getPatamByCode((String)"passwd_change_1st_login");
        String string = hasFirstTimeChange = knlParameterManageEntity == null ? "N" : knlParameterManageEntity.getParameterValue();
        return StringUtil.isNotEmpty((String)hasFirstTimeChange) && hasFirstTimeChange.equalsIgnoreCase("Y") && (StringUtil.isEmpty((Object)tmUserVo.getHasFirstTime()) || StringUtil.isNotEmpty((Object)tmUserVo.getHasFirstTime()) && tmUserVo.getHasFirstTime() == 1);
    }

    @RequestMapping(params={"left"})
    public ModelAndView left(HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        Client client = ResourceUtil.getClient();
        TmUserEntity tmUserEntity = client.getUser();
        ModelAndView modelAndView = new ModelAndView();
        if (tmUserEntity.getId() == null) {
            session.removeAttribute(Globals.USER_SESSION);
            modelAndView.setViewName("login/login");
        } else {
            request.setAttribute("menuPermissionMap", (Object)this.getFunctionLevelMap(tmUserEntity));
            modelAndView.setViewName("main/left");
        }
        return modelAndView;
    }

    private Map<Integer, List<TmFunctionVo>> getFunctionLevelMap(TmUserEntity tmUserEntity) {
        HashMap<Integer, List<TmFunctionVo>> functionMap = new HashMap<Integer, List<TmFunctionVo>>();
        Map functionsMap = this.getFucntionsByUser(tmUserEntity);
        if (functionsMap.size() > 0) {
            Collection allFunctions = functionsMap.values();
            for (TmFunctionVo function : allFunctions) {
                if (!functionMap.containsKey(function.getFunctionLevel() + 0)) {
                    functionMap.put(function.getFunctionLevel() + 0, new ArrayList());
                }
                ((List)functionMap.get(function.getFunctionLevel() + 0)).add(function);
            }
            Collection tmFunction = functionMap.values();
            for (List list : tmFunction) {
                this.setFunctionUrl(list);
                Collections.sort(list);
            }
        }
        return functionMap;
    }

    private void setFunctionUrl(List<TmFunctionVo> tmFunctionVos) {
        if (CollectionUtil.listNotEmptyNotSizeZero(tmFunctionVos)) {
            for (TmFunctionVo tmFunctionVo : tmFunctionVos) {
                if (!StringUtil.isNotEmpty((String)tmFunctionVo.getFunctionModule()) || !StringUtil.isNotEmpty((String)tmFunctionVo.getFunctionUrl())) continue;
                tmFunctionVo.setFunctionUrl("/" + tmFunctionVo.getFunctionModule() + "/" + tmFunctionVo.getFunctionUrl());
            }
        }
    }

    private Map<String, TmFunctionVo> getFucntionsByUser(TmUserEntity tmUserEntity) {
        HashMap<String, TmFunctionVo> map = new HashMap<String, TmFunctionVo>();
        Client client = ResourceUtil.getClient();
        if (client.getFunctions() != null && client.getFunctions().size() > 0) {
            map.putAll(client.getFunctions());
        } else {
            List tmFunctions = this.menuPermissionService.getFunctionsByUser(tmUserEntity);
            if (tmFunctions.size() > 0) {
                for (TmFunctionVo tmFunctionVo : tmFunctions) {
                    map.put(tmFunctionVo.getId(), tmFunctionVo);
                }
            }
        }
        return map;
    }

    @RequestMapping(params={"home"})
    public ModelAndView home(HttpServletRequest request) {
        return new ModelAndView("main/home");
    }

    @RequestMapping(params={"noPermisson"})
    public ModelAndView noPermisson(HttpServletRequest request) {
        return new ModelAndView("common/noPermisson");
    }

    @RequestMapping(params={"nonLoginAccess"})
    public ModelAndView nonLoginAccess(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        TmUserEntity tmUserEntity = new TmUserEntity();
        tmUserEntity.setUserName("admin");
        tmUserEntity.setPassword("123456");
        AjaxJson j = this.loginService.validateUser(tmUserEntity, Globals.Y, Globals.N, request, response);
        HttpSession session = ContextHolderUtils.getSession();
        request.getSession().setAttribute("sessionId", (Object)session.getId());
        TmUserVo userVo = new TmUserVo();
        userVo.setUserName(tmUserEntity.getUserName());
        userVo = this.tmUserService.getTmUser(userVo);
        request.setAttribute("userVo", (Object)userVo);
        modelAndView.setViewName("main/main");
        return modelAndView;
    }

    @RequestMapping(params={"logout"})
    public ModelAndView logout(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        HttpSession session = ContextHolderUtils.getSession();
        ResourceUtil.setClient((Client)new Client());
        session.removeAttribute(session.getId());
        for (Cookie cookie : cookies = request.getCookies()) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        return new ModelAndView("login/login");
    }

    public boolean swithPassWord(TmUserEntity tmUserEntity, HttpServletRequest req) {
        String key = LoginParamUtils.getEncryptKey();
        try {
            String userName = Snippet.aesDecrypt((String)tmUserEntity.getUserName(), (String)key);
            String password = Snippet.aesDecrypt((String)tmUserEntity.getPassword(), (String)key);
            tmUserEntity.setUserName(userName);
            tmUserEntity.setPassword(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)"\u5bc6\u7801\u89e3\u7801\u9519\u8bef", (Throwable)e);
            return false;
        }
        return true;
    }

    @ResponseBody
    @RequestMapping(params={"signOut"})
    public AjaxJson signOut() {
        AjaxJson j = new AjaxJson();
        try {
            j = this.loginService.signOut();
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @RequestMapping(params={"goTmSysLogList"})
    public ModelAndView goTmSysLogList(HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("login/tmSysLogList");
        return modelAndView;
    }

    @RequestMapping(params={"findTmSysLogList"})
    public void findTmSysLogList(TmSysLoginLogEntity sysLogin, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List loginLogEntities = this.loginService.findTmSysLogList(sysLogin, (Page)page);
        this.datagridReturn(response, loginLogEntities, (Page)page);
    }
}

