/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.dao.TmCustOrgDao;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgEntityToTmCustomerOrgVo;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgVoToTmCustomerEntity;
import com.biz.eisp.mdm.custorg.vo.QueryTmCustOrgVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmCustOrgService")
@Transactional
public class TmCustOrgServiceImpl
extends BaseServiceImpl
implements TmCustOrgService {
    @Autowired
    private TmCustOrgDao tmCustOrgDao;
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private TmCustOrgExtendService tmCustOrgExtendService;

    public TmCustomerOrgVo getTmCustOrg(String id) {
        TmCustomerOrgEntity entity = (TmCustomerOrgEntity)this.get(TmCustomerOrgEntity.class, (Serializable)((Object)id));
        TmCustomerOrgVo tmCustOrgVo = new TmCustomerOrgEntityToTmCustomerOrgVo((TmCustOrgService)this).apply(entity);
        return tmCustOrgVo;
    }

    public List<ComboTree> getParentCustOrg(HttpServletRequest request, ComboTree comboTree) {
        String selfId = request.getParameter("selfId");
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List tmCustOrgList = new ArrayList();
        if (StringUtil.isNotEmpty((String)selfId)) {
            tmCustOrgList = this.findByProperty(TmCustomerOrgEntity.class, "id", (Object)selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmCustOrg.id", (Object)comboTree.getId());
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr2});
        } else {
            Criterion cr3 = Restrictions.isNull((String)"tmCustOrg.id");
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
        List comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
        return comboTrees;
    }

    public void saveOrUpdateCustOrg(TmCustomerOrgVo custOrgVo, Page page) {
        TmCustomerOrgEntity tmCustOrg = null;
        if (StringUtil.isNotEmpty((Object)this.tmCustOrgExtendService)) {
            try {
                this.tmCustOrgExtendService.validate(custOrgVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustOrg = this.tmCustOrgExtendService.saveBefore(custOrgVo, page);
        }
        if (StringUtil.isEmpty(tmCustOrg)) {
            tmCustOrg = new TmCustomerOrgVoToTmCustomerEntity((TmCustOrgService)this).apply(custOrgVo);
        }
        if (StringUtil.isNotEmpty((Object)this.tmCustOrgExtendService)) {
            tmCustOrg = this.tmCustOrgExtendService.saveBefore(tmCustOrg, custOrgVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmCustOrg.getId())) {
            List subCustOrg = this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", (Object)tmCustOrg.getId());
            this.updateSubCustOrg(subCustOrg, tmCustOrg);
        }
        this.saveOrUpdate((Object)tmCustOrg);
        if (StringUtil.isNotEmpty((Object)this.tmCustOrgExtendService)) {
            tmCustOrg = this.tmCustOrgExtendService.savePost(tmCustOrg, custOrgVo, page);
        }
    }

    private void updateSubCustOrg(List<TmCustomerOrgEntity> subCustOrg, TmCustomerOrgEntity parent) {
        if (subCustOrg.size() == 0) {
            return;
        }
        for (TmCustomerOrgEntity custOrg : subCustOrg) {
            custOrg.setCustOrgLevel(Integer.valueOf(parent.getCustOrgLevel() + 1 + ""));
            this.saveOrUpdate((Object)custOrg);
            List subFunction1 = this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", (Object)custOrg.getId());
            this.updateSubCustOrg(subFunction1, custOrg);
        }
    }

    public AjaxJson delCustOrg(String ids) {
        String[] custOrgIds;
        AjaxJson j = new AjaxJson();
        for (String id : custOrgIds = ids.split(",")) {
            TmCustomerOrgEntity entitie = this.getEntity(id, null);
            this.delete((Object)entitie);
        }
        j.setMsg("\u5220\u9664\u6210\u529f!");
        return j;
    }

    public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo, Page page) {
        List custorgcustvos = this.tmCustOrgDao.findTmCustomerByCustOrg(tmCustOrgCustomerVo, page);
        Iterator iterator = custorgcustvos.iterator();
        while (iterator.hasNext()) {
            String sql = "select position_id from TM_R_CUST_POS_BG t where t.customer_id = ?";
            TmCustOrgCustomerVo tto = (TmCustOrgCustomerVo)iterator.next();
            List positionList = this.findForMapList(sql, new Object[]{tto.getId()});
            if (CollectionUtil.listEmpty((List)positionList)) continue;
            for (int i = 0; i < positionList.size(); ++i) {
                if (!StringUtil.isNotEmpty(((Map)positionList.get(i)).get("position_id"))) continue;
                String positionId = (String)((Map)positionList.get(i)).get("position_id");
                TmPositionEntity tmPositionEntity = (TmPositionEntity)this.tmPositionService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                tto.setPositionName((StringUtil.isNotEmpty((String)tto.getPositionName()) ? tto.getPositionName() + "," : "") + tmPositionEntity.getPositionName());
                String sql2 = "select user_id from TM_R_USER_POSITION t where t.position_id = ?";
                List userList = this.findForMapList(sql2, new Object[]{positionId});
                if (CollectionUtil.listEmpty((List)userList)) continue;
                for (int j = 0; j < userList.size(); ++j) {
                    if (!StringUtil.isNotEmpty(((Map)userList.get(j)).get("user_id"))) continue;
                    String userID = (String)((Map)userList.get(j)).get("user_id");
                    TmUserEntity tmUserEntity = (TmUserEntity)this.tmUserService.get(TmUserEntity.class, (Serializable)((Object)userID));
                    tto.setUsername((StringUtil.isNotEmpty((String)tto.getUsername()) ? tto.getUsername() + "," : "") + tmUserEntity.getFullName());
                }
            }
        }
        return custorgcustvos;
    }

    public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo, Page page) {
        return this.tmCustOrgDao.findTmTerminalByCustOrgNew(tmCustOrgTerminalVo, page);
    }

    public List<TmCustOrgBusinessVo> findNotRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo, Page page) {
        return this.tmCustOrgDao.findNotRefBusinessGrid(tmCustOrgBusinessVo, page);
    }

    public List<TmCustOrgBusinessVo> findRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo) {
        return this.tmCustOrgDao.findRefBusinessGrid(tmCustOrgBusinessVo);
    }

    public List<ComboTree> getParentCustOrgs(HttpServletRequest request, ComboTree comboTree) {
        ComboTreeModel comboTreeModel;
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List tmCustOrgList = new ArrayList();
        Object cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId)) {
            tmCustOrgList = this.findByProperty(TmCustomerOrgEntity.class, "id", (Object)selfId);
        } else if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmCustOrg.id", (Object)comboTree.getId());
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr2});
        } else {
            Criterion cr3 = Restrictions.isNull((String)"tmCustOrg.id");
            tmCustOrgList = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
        }
        if (StringUtil.isNotEmpty((String)selfId)) {
            comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
            List comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
            return comboTrees;
        }
        comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
        List comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
        return comboTrees;
    }

    public AjaxJson removeCustOrgBusiness(String id, String custOrgId) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isNotEmpty((String)custOrgId)) {
            TmCustomerOrgEntity tmCustomerOrgEntity = null;
            tmCustomerOrgEntity = (TmCustomerOrgEntity)this.get(TmCustomerOrgEntity.class, (Serializable)((Object)custOrgId));
            if (StringUtil.isNotEmpty((Object)tmCustomerOrgEntity)) {
                tmCustomerOrgEntity.setPositionId(null);
                this.saveOrUpdate((Object)tmCustomerOrgEntity);
            } else {
                j.setMsg("\u79fb\u9664\u5931\u8d25");
                j.setSuccess(false);
            }
        } else {
            j.setMsg("\u79fb\u9664\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }

    public AjaxJson addCustOrgBusiness(String id, String custOrgId) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isNotEmpty((String)custOrgId)) {
            TmCustomerOrgEntity tmCustomerOrgEntity = null;
            tmCustomerOrgEntity = (TmCustomerOrgEntity)this.get(TmCustomerOrgEntity.class, (Serializable)((Object)custOrgId));
            if (StringUtil.isNotEmpty((Object)tmCustomerOrgEntity)) {
                tmCustomerOrgEntity.setPositionId(id);
                this.saveOrUpdate((Object)tmCustomerOrgEntity);
            } else {
                j.setMsg("\u6dfb\u52a0\u5931\u8d25");
                j.setSuccess(false);
            }
        } else {
            j.setMsg("\u6dfb\u52a0\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }

    public List<TmCustomerOrgVo> findTmCustOrgByAllPossible(QueryTmCustOrgVo queryTmCustOrgVo, Page page) {
        return this.tmCustOrgDao.findTmCustOrgByAllPossible(queryTmCustOrgVo, page);
    }

    public List<TmCustomerOrgVo> findTmCustomerOrgList(TmCustomerOrgVo custOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_CUSTOMER_ORG, (Object)custOrgVo);
        sql = sql + " order by t.cust_org_code asc,length(t.cust_org_code) asc";
        List voList = this.findBySql(TmCustomerOrgVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_CUSTOMER_ORG, (Object)custOrgVo)) {
            voList = this.findQueryCustomerOrgList(custOrgVo, voList);
        }
        return voList;
    }

    public List<TmCustomerOrgVo> findTmCustomerOrgPageList(TmCustomerOrgVo custOrgVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_CUSTOMER_ORG, (Object)custOrgVo);
        sql = sql + " order by t.cust_org_code asc,length(t.cust_org_code) asc";
        List voList = new ArrayList();
        voList = StringUtil.isNotEmpty((String)custOrgVo.getId()) ? this.findBySql(TmCustomerOrgVo.class, sql, new Object[0]) : this.findBySql(TmCustomerOrgVo.class, sql, page, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_CUSTOMER_ORG, (Object)custOrgVo)) {
            voList = this.findQueryCustomerOrgList(custOrgVo, voList);
        }
        return voList;
    }

    private List<TmCustomerOrgVo> findQueryCustomerOrgList(TmCustomerOrgVo custOrgVo, List<TmCustomerOrgVo> voList) {
        if (custOrgVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVolist;
    }

    private boolean hasQueryValue(TmCustomerOrgVo custOrgVo) {
        return !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgCode()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustomerOrgName()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgType()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgDesc()) || !StringUtils.isBlank((CharSequence)custOrgVo.getCustOrgType()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar1()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar2()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar3()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar4()) || !StringUtils.isBlank((CharSequence)custOrgVo.getExtChar5()) || custOrgVo.getExtNumber1() != null || custOrgVo.getExtNumber2() != null || custOrgVo.getExtNumber3() != null;
    }

    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    public List<TmCustomerOrgEntity> findBelowCustOrgByOrgCode(String custOrgCode) {
        return this.tmCustOrgDao.findBelowCustOrgByOrgCode(custOrgCode);
    }

    public List<TmCustomerOrgEntity> findAllById(String id, String orgCode) {
        ArrayList<TmCustomerOrgEntity> listAll = new ArrayList<TmCustomerOrgEntity>();
        if (StringUtil.isBlank((String)id) && StringUtil.isBlank((String)orgCode)) {
            return listAll;
        }
        TmCustomerOrgEntity entity = this.getEntity(id, orgCode);
        if (entity == null) {
            return listAll;
        }
        listAll.add(entity);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(entity.getId());
        this.findAllByIdChild(ids, listAll);
        return listAll;
    }

    public void findAllByIdChild(List<String> parentIds, List<TmCustomerOrgEntity> listAll) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(parentIds)) {
            return;
        }
        List entities = this.tmCustOrgDao.findAllByIdChild(parentIds);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entities)) {
            listAll.addAll(entities);
        }
    }

    public TmCustomerOrgEntity getEntity(String id, String orgCode) {
        String hql;
        List entities;
        TmCustomerOrgEntity entity = null;
        if (StringUtil.isBlank((String)id) && StringUtil.isBlank((String)orgCode)) {
            return entity;
        }
        if (StringUtil.isNotEmpty((String)id)) {
            entity = (TmCustomerOrgEntity)this.get(TmCustomerOrgEntity.class, (Serializable)((Object)id));
            return entity;
        }
        if (StringUtil.isNotEmpty((String)orgCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(entities = this.findByHql(hql = " from TmCustomerOrgEntity a where a.custOrgCode = ? ", new Object[]{orgCode})))) {
            return (TmCustomerOrgEntity)entities.get(0);
        }
        return entity;
    }
}

