#####流程检测功能#####

CREATE TABLE ta_process_check_batch (
  id VARCHAR2(32) NOT NULL ,
  record_id VARCHAR2(32) DEFAULT NULL ,
  user_name VARCHAR2(20) DEFAULT NULL ,
  json_data VARCHAR2(4000) ,
  first_create_date timestamp NULL ,
  last_update_date timestamp NULL,
  PRIMARY KEY (id)
);

comment on table ta_process_check_batch IS '流程检测报告实体';
comment on column ta_process_check_batch.record_id is '记录ID';
comment on column ta_process_check_batch.user_name is '用户名';
comment on column ta_process_check_batch.json_data is '检查详情';


CREATE TABLE ta_process_check_detail (
  id VARCHAR2(32) NOT NULL,
  record_id VARCHAR2(32) DEFAULT NULL ,
  node_key VARCHAR2(255) DEFAULT NULL ,
  node_name VARCHAR2(255) DEFAULT NULL ,
  check_time VARCHAR2(20) DEFAULT NULL ,
  check_result VARCHAR2(4000) ,
  state VARCHAR2(10) DEFAULT NULL,
  check_type VARCHAR2(10) DEFAULT NULL,
  process_ins_id VARCHAR2(32) DEFAULT NULL,
  next_node VARCHAR2(255) DEFAULT NULL,
  user_name VARCHAR2(100) DEFAULT NULL,
  first_create_date timestamp NULL,
  last_update_date timestamp NULL,
  PRIMARY KEY (id)
);

comment on table ta_process_check_detail IS '流程检测报告详情实体';
comment on column ta_process_check_detail.record_id is '报告ID';
comment on column ta_process_check_detail.node_key is '节点KEY';
comment on column ta_process_check_detail.node_name is '节点名称';
comment on column ta_process_check_detail.check_time is '检测时间';
comment on column ta_process_check_detail.check_result is '检测结果';
comment on column ta_process_check_detail.state is '检测状态（0未检测，1成功，2失败）';
comment on column ta_process_check_detail.check_type is '检测类型';
comment on column ta_process_check_detail.process_ins_id is '流程实例ID';
comment on column ta_process_check_detail.next_node is '下一个检测节点key';
comment on column ta_process_check_detail.user_name is '执行用户名';



CREATE TABLE ta_process_check_record (
  id VARCHAR2(32) NOT NULL,
  process_id VARCHAR2(32) DEFAULT NULL,
  check_time VARCHAR2(20) DEFAULT NULL,
  title VARCHAR2(255) DEFAULT NULL,
  state VARCHAR2(10) DEFAULT NULL,
  ck_params VARCHAR2(4000),
  result_remark VARCHAR2(500) DEFAULT NULL,
  is_batch_user NUMBER(1) DEFAULT '0',
  first_create_date timestamp NULL,
  last_update_date timestamp NULL,
  PRIMARY KEY (id)
);

comment on table ta_process_check_record IS '流程检测报告实体';
comment on column ta_process_check_record.process_id is '流程实体ID';
comment on column ta_process_check_record.check_time is '检测时间';
comment on column ta_process_check_record.title is '检测标题';
comment on column ta_process_check_record.state is '状态（0未完成，1成功，2失败）';
comment on column ta_process_check_record.ck_params is '检测的参数JSON';
comment on column ta_process_check_record.result_remark is '检测结果描述';
comment on column ta_process_check_record.is_batch_user is '是否为批量';




################流程按钮权限##################
CREATE TABLE ta_process_node_auth
(
    id VARCHAR2(32) PRIMARY KEY,
    process_node_id VARCHAR2(32),
    process_id VARCHAR2(32),
    btn1 VARCHAR2(2),
    btn2 VARCHAR2(2),
    btn3 VARCHAR2(2),
    btn4 VARCHAR2(2),
    btn5 VARCHAR2(2),
    btn6 VARCHAR2(2),
    btn7 VARCHAR2(2),
    btn8 VARCHAR2(2),
    btn9 VARCHAR2(2),
    btn10 VARCHAR2(2)
);
COMMENT ON COLUMN ta_process_node_auth.id IS '逻辑主键ID';
COMMENT ON COLUMN ta_process_node_auth.process_node_id IS '流程节点ID，外键对应ta_process_node的id字段';
COMMENT ON COLUMN ta_process_node_auth.process_id IS '流程ID，冗余字段，对应ta_process的ID字段';
COMMENT ON COLUMN ta_process_node_auth.btn1 IS '第1个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn2 IS '第2个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn3 IS '第3个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn4 IS '第4个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn5 IS '第5个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn6 IS '第6个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn7 IS '第7个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn8 IS '第8个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn9 IS '第9个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON COLUMN ta_process_node_auth.btn10 IS '第10个按钮权限：Y 有按钮权限 N 没有按钮权限';
COMMENT ON TABLE ta_process_node_auth IS '流程节点权限，按钮权限配置'


--建立主数据配置
DELETE FROM tm_dict_type WHERE dict_type_code = 'tm_process_node_auth';
DELETE FROM tm_dict_data WHERE dict_type_code = 'tm_process_node_auth';

INSERT INTO tm_dict_type(id,dict_type_code,dict_type_name,dict_desc,create_date,create_name,update_date,update_name,is_system)
VALUES (lower(sys_guid()), 'tm_process_node_auth', '默认流程节点权限配置', '默认流程节点权限配置', sysdate, '系统初始化', sysdate, '系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn1', 'Y', '审批通过',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn2', 'Y', '沟通',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn3', 'N', '委派',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn4', 'Y', '传阅',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn5', 'N', '意见隐藏',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn6', 'Y', '是否返回本节点',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn7', 'Y', '驳回',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);

INSERT INTO tm_dict_data(ID, dict_code,dict_value,dict_desc,parent_id,dict_type_code,create_date,create_name,update_date,update_name,is_system)
VALUES(lower(sys_guid()), 'btn8', 'Y', '驳回发起人',NULL,'tm_process_node_auth',SYSDATE,'系统初始化',SYSDATE,'系统初始化',0);
--自动更新旧流程数据
INSERT INTO ta_process_node_auth
 select RAWTOHEX(sys_guid()),a.ID,a.process_id,b.btn1,b.btn2
 ,b.btn3,b.btn4,b.btn5,b.btn6,b.btn7,b.btn8,'Y','Y'
 from
            ( select id, process_id,process_node_name,process_node_code from ta_process_node where id
            not in(select process_node_id from ta_process_node_auth)) a,
          ( select * from (select dict_value btn1 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn1'),
       (select dict_value btn2 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn2'),
       (select dict_value btn3 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn3'),
       (select dict_value btn4 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn4'),
       (select dict_value btn5 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn5'),
       (select dict_value btn6 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn6'),
       (select dict_value btn7 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn7'),
       (select dict_value btn8 from tm_dict_data where dict_type_code='tm_process_node_auth' and dict_code = 'btn8')
       )b
       ;

ALTER TABLE TA_PROCESS_NODE ADD null_jump_node VARCHAR2(2) NULL;
COMMENT ON COLUMN TA_PROCESS_NODE.null_jump_node IS '空节点自动跳过';
ALTER TABLE TA_PROCESS_NODE ADD duplicate_jump_node VARCHAR2(2) NULL;
COMMENT ON COLUMN TA_PROCESS_NODE.duplicate_jump_node IS '重复节点自动跳过';
