<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="tmAreaRange" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="tmAreaRangeList"
                    actionUrl="tmAreaRangeController.do?findAreaRangeList"
                    idField="id" fit="true" pagination="false" fitColumns="false" queryMode="group">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="大区编码" field="parentCode" query="true"></t:dgCol>
            <t:dgCol title="大区名称" field="parentName" query="true"></t:dgCol>
            <t:dgCol title="省编码" field="code" query="true"></t:dgCol>
            <t:dgCol title="省名称" field="name" query="true"></t:dgCol>

            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmAreaRangeController.do?goAreaRangeForm" funname="add"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="update" icon="icon-edit" url="tmAreaRangeController.do?goAreaRangeForm" funname="update"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="delete" icon="icon-remove" url="tmAreaRangeController.do?deleteAreaRangeByIds" funname="deleteSelections"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="export" icon="icon-dataOut" url="tmAreaRangeController.do?exportXls" funname="excelExport"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>

    //批量删除
    function deleteSelections(title, url, grid, width, height) {
        var rows = $("#" + grid).datagrid("getSelections");
        if (rows.length <= 0) {
            tip("请先选择数据");
            return;
        }

        var idArray = [];
        for (var i = 0; i < rows.length; i++) {
            idArray.push(rows[i].id);
        }
        var ids = idArray.join(",");
        $.messager.confirm('操作提示', '该操作不可逆，确定要删除所选择的数据吗？', function (r) {
            if (r) {
                $.ajax({
                    url: url,
                    data: {
                        ids: ids
                    },
                    success: function (data) {
                        var d = data;
                        if (d.success) {
                            tip(d.msg);
                            $("#" + grid).datagrid("reload");
                        } else {
                            tip(d.msg, "error");
                        }
                    },
                    error: function () {
                        tip("操作失败", "error");
                    }
                });
            }
        });
    }

</script>
