/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class NumberUtils {
    private NumberUtils() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).doubleValue();
    }

    public static double subtract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double multiply(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static double multiply(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).setScale(scale, 4).doubleValue();
    }

    public static double divide(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2).doubleValue();
    }

    public static double divide(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return b.setScale(scale, 4).doubleValue();
    }

    public static String format(Double v, String pattern) {
        if (v == null) {
            v = 0.0;
        }
        try {
            return new DecimalFormat(pattern).format(v);
        }
        catch (Exception exception) {
            return v.toString();
        }
    }

    public static void main(String[] args) {
        String num = NumberUtils.format((Double)1.2234234234253E8, (String)"0.00");
        System.out.println(num);
    }

    public static String format(Long v, String pattern) {
        if (v == null) {
            v = 0L;
        }
        try {
            return new DecimalFormat(pattern).format(v);
        }
        catch (Exception exception) {
            return v.toString();
        }
    }

    public static String format(Integer v, String pattern) {
        if (v == null) {
            v = 0;
        }
        try {
            return new DecimalFormat(pattern).format(v);
        }
        catch (Exception exception) {
            return v.toString();
        }
    }

    public static Double parseToDouble(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        return (Double)value;
    }

    public static String getPattern(int decimalPrecision) {
        if (decimalPrecision == 0) {
            return "#";
        }
        String pattern = "#.";
        for (int i = 0; i < decimalPrecision; ++i) {
            pattern = pattern + "#";
        }
        return pattern;
    }
}

