/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.role.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tMroleController"})
public class TmRoleController
extends BaseController {
    @Autowired
    private TmFunctionService functionService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private TmRoleService tmRoleService;
    @Autowired
    private TmFunAuthService tmFunAuthService;

    @RequestMapping(params={"goRoleList"})
    public ModelAndView goRoleList(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ROLE);
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleMain");
    }

    @RequestMapping(params={"goTmRoleCheckedMain"})
    public ModelAndView goTmRoleCheckedMain(TmRoleVo tmRoleVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmRoleVo.getPosId())) {
            request.setAttribute("posId", (Object)tmRoleVo.getPosId());
        } else {
            request.setAttribute("posId", (Object)"-1");
        }
        if (StringUtil.isNotEmpty((String)tmRoleVo.getUserId())) {
            request.setAttribute("userId", (Object)tmRoleVo.getUserId());
        } else {
            request.setAttribute("userId", (Object)"-1");
        }
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleCheckedMain");
    }

    @RequestMapping(params={"findRoleList"})
    public void findRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
        String pagination = OConvertUtils.getString((String)request.getParameter("pagination"));
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)pagination)) {
            page = null;
        }
        List roles = this.tmRoleService.findRoleList(tmRoleVo, (Page)page);
        if (StringUtil.isNotEmpty((String)pagination)) {
            this.datagridReturn(response, roles);
        } else {
            this.datagridReturn(response, roles, (Page)page);
        }
    }

    @RequestMapping(params={"getRoleListByUserPost"})
    public void getRoleListByUserPost(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
        String pagination = OConvertUtils.getString((String)request.getParameter("pagination"));
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)pagination)) {
            page = null;
        }
        List roles = this.tmRoleService.getRoleListByCurrentPosId(tmRoleVo, (Page)page);
        if (StringUtil.isNotEmpty((String)pagination)) {
            this.datagridReturn(response, roles);
        } else {
            this.datagridReturn(response, roles, (Page)page);
        }
    }

    @RequestMapping(params={"goRoleForm"})
    public ModelAndView goRoleForm(HttpServletRequest request) {
        String id = OConvertUtils.getString((String)request.getParameter("id"));
        if (StringUtil.isNotEmpty((String)id)) {
            TmRoleEntity roleEntity = (TmRoleEntity)this.tmRoleService.get(TmRoleEntity.class, (Serializable)((Object)id));
            request.setAttribute("role", (Object)roleEntity);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ROLE);
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleForm");
    }

    @RequestMapping(params={"validFormRoleForm"})
    @ResponseBody
    public ValidForm validFormRoleForm(HttpServletRequest request, TmRoleEntity tmRoleEntity) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        String flag = OConvertUtils.getString((String)request.getParameter("flag"));
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleName")) {
            tmRoleEntity.setRoleName(param);
        }
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleCode")) {
            tmRoleEntity.setRoleCode(param);
        }
        return this.tmRoleService.validateTmRoleForm(tmRoleEntity);
    }

    @RequestMapping(params={"saveRoleForm"})
    @ResponseBody
    public AjaxJson saveRoleForm(HttpServletRequest request, TmRoleVo tmRoleVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmRoleService.createTmRole(tmRoleVo, (Page)page);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u89d2\u8272\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delete"})
    @ResponseBody
    public AjaxJson delete(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (this.tmRoleService.deleteTmRole(id)) {
                j.setMsg("\u5220\u9664\u89d2\u8272\u6210\u529f");
            } else {
                j.setSuccess(false);
                j.setMsg("\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u80fd\u88ab\u5220\u9664");
            }
        }
        catch (Exception e1) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25,\u8be5\u89d2\u8272\u5df2\u7ecf\u5173\u8054\u5176\u4ed6\u6570\u636e");
            e1.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"update"})
    @ResponseBody
    public Map<String, Object> update(TmRoleEntity tmRole) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map map = this.tmRoleService.updateTmRole(tmRole);
        if ("true".equals(map.get("success"))) {
            model.put("success", true);
        } else {
            model.put("success", false);
            model.put("msg", map.get("msg"));
        }
        return model;
    }

    @RequestMapping(params={"startOrStopRole"})
    @ResponseBody
    public AjaxJson startOrStopRole(TmRoleVo tmRoleVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmRoleService.startOrStopRole(tmRoleVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"goPermSetting"})
    public ModelAndView goPermSetting(HttpServletRequest request) {
        String roleId = OConvertUtils.getString((String)request.getParameter("roleId"));
        request.setAttribute("roleId", (Object)roleId);
        return new ModelAndView("com/biz/eisp/mdm/role/permSetting");
    }

    @RequestMapping(params={"getMenuInfoTreeByRole"})
    @ResponseBody
    public List<ComboTree> getMenuInfoTreeByRole(HttpServletRequest request, ComboTree comboTree) {
        String roleId = request.getParameter("roleId");
        List trees = this.functionService.getAllFuncAndHandleCheck(request, comboTree, roleId);
        return trees;
    }

    @RequestMapping(params={"getOpetateInfoByRoleFunc"})
    public void getOpetateInfoByRoleFunc(HttpServletRequest request, HttpServletResponse response, String roleId, String functionId) {
        try {
            List operations = this.functionService.getOptByRoleFunc(roleId, functionId);
            JSONArray operationsJson = JSONArray.parseArray((String)JSONObject.toJSONString((Object)operations));
            this.sendResponseState(response, true, (Object)operationsJson);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6309\u94ae\u4fe1\u606f\u5931\u8d25";
            e.printStackTrace();
            this.sendResponseState(response, false, null);
        }
    }

    @RequestMapping(params={"findFunButtonList"})
    @ResponseBody
    public List<TmOperationEntity> findFunButtonList(String funId) {
        String sql = " select id,operation_code,operation_name from tm_operation where function_id = ? ";
        List operationEntities = this.functionService.findBySql(TmOperationEntity.class, sql, new Object[]{funId});
        operationEntities = operationEntities == null ? new ArrayList() : operationEntities;
        return operationEntities;
    }

    @RequestMapping(params={"findFunButtonValList"})
    @ResponseBody
    public List<TmOperationEntity> findFunButtonValList(String funId, String roleId) {
        String operation;
        ArrayList<TmOperationEntity> operationEntities = new ArrayList<TmOperationEntity>();
        String sql = " select operation from TM_R_ROLE_FUNCTION  where FUNCTION_id=? and role_id=?";
        List roleFunctionEntities = this.functionService.findBySql(TmRoleFunctionEntity.class, sql, new Object[]{funId, roleId});
        if (CollectionUtil.listNotEmptyNotSizeZero((List)roleFunctionEntities) && StringUtil.isNotBlank((String)(operation = ((TmRoleFunctionEntity)roleFunctionEntities.get(0)).getOperation()))) {
            String[] ids;
            for (String id : ids = operation.split(",")) {
                if (StringUtil.isBlank((String)id)) continue;
                TmOperationEntity temp = new TmOperationEntity();
                temp.setId(id);
                operationEntities.add(temp);
            }
        }
        operationEntities = operationEntities == null ? new ArrayList<TmOperationEntity>() : operationEntities;
        return operationEntities;
    }

    @RequestMapping(params={"setFuncRole"})
    @ResponseBody
    public AjaxJson setFuncRole(HttpServletResponse response, String roleId, String funcIds) {
        AjaxJson j = new AjaxJson();
        try {
            this.functionService.delExistFuncRole(roleId, funcIds);
            this.functionService.setFuncRole(roleId, funcIds);
        }
        catch (Exception e) {
            j.setMsg("\u4fee\u6539\u83dc\u5355\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"setOperateByFuncRole"})
    @ResponseBody
    public AjaxJson setOperateByFuncRole(HttpServletResponse response, String opretionIds, String roleId, String funcId) {
        AjaxJson j = new AjaxJson();
        try {
            this.functionService.setOperateByFuncRole(opretionIds, roleId, funcId);
            this.redisService.set("NO_OPERATION_VERSION_", (Object)UUID.randomUUID().toString().replaceAll("-", ""));
        }
        catch (Exception e) {
            j.setMsg("\u4fee\u6539\u6309\u94ae\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"getAuthObj"})
    public void getAuthObj(HttpServletResponse response, String roleId, String funcId) {
        try {
            List authVos = this.functionService.getAuthObjByFunc(roleId, funcId);
            JSONArray obj = JSONArray.parseArray((String)JSONObject.toJSONString((Object)authVos));
            this.sendResponseState(response, true, (Object)obj);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u5931\u8d25";
            this.sendResponseState(response, false, null);
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"getAuthObjValue"})
    public void getAuthObjValue(HttpServletResponse response, String roleId, String funcId, String authObj) {
        try {
            List dataVos = this.tmFunAuthService.getTmFunAuthValueByRoleFunc(roleId, funcId, authObj);
            JSONArray obj = JSONArray.parseArray((String)JSONObject.toJSONString((Object)dataVos));
            this.sendResponseState(response, true, (Object)obj);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u503c\u5931\u8d25";
            this.sendResponseState(response, false, null);
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"setAuthObjValue"})
    @ResponseBody
    public AjaxJson setAuthObjValue(String roleId, String funcId, String authObj, String authCodes, String funCode) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmFunAuthService.saveFunAuthValue(roleId, funcId, authObj, authCodes, funCode);
        }
        catch (Exception e) {
            ajaxJson.setMsg("\u8bbe\u7f6e\u6743\u9650\u503c\u5931\u8d25");
            ajaxJson.setSuccess(false);
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(params={"goNoSelfRoleMain"})
    public ModelAndView goNoSelfRoleMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/role/noSelfRoleMain");
    }

    @RequestMapping(params={"findNoSelfRoleList"})
    @ResponseBody
    public DataGrid findNoSelfRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, String selfRoleId) {
        EuPage page = new EuPage(request);
        List voList = this.tmRoleService.findNoSelfRoleList(tmRoleVo, selfRoleId, (Page)page);
        return new DataGrid(voList, (Page)page);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmRoleInfoExportVo tmRoleInfoExportVo, HttpServletRequest request, HttpServletResponse response) {
        List voList = this.tmRoleService.findExportRoleInfoList(tmRoleInfoExportVo);
        this.doExportXls(response, request, (Collection)voList, TmRoleInfoExportVo.class, "\u6743\u9650\u89d2\u8272\u5217\u8868");
    }
}

