<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<div id="system_org_orgList" class="easyui-layout" fit="true">
<div region="center">
    <t:datagrid name="orgSelectList" title="组织列表" actionUrl="${empty pagination || !pagination ? 'tmOrgController.do?findOrgMainList' : 'tmOrgController.do?findOrgMainPageList'}"
    		 idField="id" treegrid="true" fit="true"  fitColumns="false" pagination="${empty pagination ? false : pagination}">
        <t:dgCol title="主键" field="id" treefield="id" hidden="true"></t:dgCol>
        <t:dgCol title="组织名称" field="orgName" treefield="text"></t:dgCol>
        <t:dgCol title="组织编码" field="orgCode" treefield="orgCode"></t:dgCol>
        <t:dgCol title="组织描述" field="orgDesc" treefield="orgDesc"></t:dgCol>
        <t:dgCol title="组织类型" field="orgType" treefield="orgType" dictionary="org_type"></t:dgCol>
        <t:dgToolBar title="调整" icon="icon-add" url="tmOrgController.do?goOrgAddForm" funname="selectOrgTOposition"></t:dgToolBar>
    </t:datagrid>
</div>
</div>

<script type="text/javascript">

    $(function (){
        $('#orgSelectList').treegrid('options').onBeforeLoad = function (row, param) {
            //treegrid分页问题解决
            if(!row){
                param.id = '';
            }
        }
    });

	function selectOrgTOposition(){
		var selectTarget = $("#orgSelectList").datagrid('getSelected');
		var orgId = '${orgId}';
		var positionIds = '${positionIds}';
		if(selectTarget==null || selectTarget==""){
			tip("请选择一个需要调整的组织");
			return false
		}
		if(selectTarget.id == orgId){
			tip("当前需要调整的职位已经属于该组织");
			return false;
		}

        getSafeJq().dialog.confirm("调整组织会清空上级职位，是否继续", function() {
            $.ajax({
                type : "POST",
                url : "tmPositionController.do?changePositionForOrg",
                data : {
                    "positionIds" : positionIds,
                    "orgId": selectTarget.id
                },
                dataType : "json",
                success : function(data) {
                    var windowapi = frameElement ? frameElement.api : undefined;
                    if (typeof (windowapi) != 'undefined') {
                        var W = windowapi.opener;
                        W.tip(data.msg);
                    }
                    windowapi.close();
                    W.reloadTable();
                },
                error:function(){
                    tip("服务器异常，请稍后再试");
                }
            });
        });
	}
</script>

