/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.MenuPermissionExtendsService;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="menuPermissionService")
@Transactional
public class MenuPermissionServiceImpl
extends BaseServiceImpl
implements MenuPermissionService {
    @Autowired(required=false)
    private MenuPermissionExtendsService menuPermissionExtendsService;

    public List<TmFunctionVo> getFunctionsByUser(TmUserEntity tmUserEntity) {
        boolean b = false;
        String useType = ResourceUtil.getSysConfigProperty((String)"useType");
        if (StringUtils.isNotBlank((String)useType) && useType.equals("Y")) {
            b = true;
        }
        ArrayList<TmFunctionVo> returnFunctions = new ArrayList<TmFunctionVo>();
        if (Globals.ENTERPRISE_USER.intValue() == tmUserEntity.getUserType().intValue()) {
            List tmFunctions = this.enterPriseTmFunctions(tmUserEntity);
            returnFunctions.addAll(tmFunctions);
        } else if (Globals.CUST_USER.intValue() == tmUserEntity.getUserType().intValue() && !b) {
            List tmFunctions = this.custTmFunctions(tmUserEntity);
            returnFunctions.addAll(tmFunctions);
        } else if (Globals.DISTRIBUTOR_AGENT.intValue() == tmUserEntity.getUserType().intValue() && !b) {
            List tmFunctions = this.custYdTmFunctions(tmUserEntity);
            returnFunctions.addAll(tmFunctions);
        } else if (Globals.OTHER_USER.intValue() == tmUserEntity.getUserType().intValue() || b) {
            if (this.menuPermissionExtendsService != null) {
                List tmFunctions = this.menuPermissionExtendsService.findFunctionList(tmUserEntity);
                returnFunctions.addAll(tmFunctions);
            }
        } else {
            return returnFunctions;
        }
        return returnFunctions;
    }

    private List<TmFunctionVo> custTmFunctions(TmUserEntity tmUserEntity) {
        String roleSql = "  SELECT DISTINCT TM.* FROM TM_USER TU JOIN TM_R_USER_ROLE TUR ON TU.ID=TUR.USER_ID  JOIN TM_ROLE TM ON TUR.ROLE_ID=TM.ID WHERE  TU.ID=? ";
        List roles = super.findBySql(TmRoleEntity.class, roleSql, new Object[]{tmUserEntity.getId()});
        List tfs = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)roles)) {
            String custFunctionsSql = "SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL FROM TM_USER TU JOIN TM_R_USER_ROLE TUR ON TU.ID=TUR.USER_ID JOIN TM_ROLE TM ON TUR.ROLE_ID=TM.ID JOIN TM_R_ROLE_FUNCTION TRF ON TRF.ROLE_ID=TM.ID JOIN TM_FUNCTION TF ON TF.ID=TRF.FUNCTION_ID LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID WHERE TF.is_system = 2 and TU.ID=? ORDER BY TF.FUNCTION_LEVEL ASC";
            tfs = super.findBySql(TmFunctionVo.class, custFunctionsSql, new Object[]{tmUserEntity.getId()});
        } else {
            String custFunctionsSql = " SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL\n FROM TM_FUNCTION TF  LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID  WHERE TF.is_system=2  ORDER BY TF.FUNCTION_LEVEL ASC ";
            tfs = super.findBySql(TmFunctionVo.class, custFunctionsSql, new Object[0]);
        }
        return tfs;
    }

    private List<TmFunctionVo> custYdTmFunctions(TmUserEntity tmUserEntity) {
        String custFunctionsSql = "SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL FROM TM_USER TU JOIN TM_R_USER_ROLE TUR ON TU.ID=TUR.USER_ID JOIN TM_ROLE TM ON TUR.ROLE_ID=TM.ID JOIN TM_R_ROLE_FUNCTION TRF ON TRF.ROLE_ID=TM.ID JOIN TM_FUNCTION TF ON TF.ID=TRF.FUNCTION_ID LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID WHERE TF.is_system = 2 and TU.ID=? ORDER BY TF.FUNCTION_LEVEL ASC";
        List tfs = super.findBySql(TmFunctionVo.class, custFunctionsSql, new Object[]{tmUserEntity.getId()});
        return tfs;
    }

    private List<TmFunctionVo> enterPriseTmFunctions(TmUserEntity tmUserEntity) {
        String menuSql = "SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID JOIN TM_R_USER_POSITION TUP ON TUP.IS_MAIN = 0 AND TUP.POSITION_ID=TRPR.POSITION_ID JOIN TM_USER TU ON TUP.USER_ID=TU.ID LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID WHERE TF.is_system<>1 and TU.ID=? ORDER BY TF.FUNCTION_LEVEL ASC";
        List tfs = super.findBySql(TmFunctionVo.class, menuSql, new Object[]{tmUserEntity.getId()});
        return tfs;
    }

    private void packageMenu(List<TmFunctionVo> nodeList, List<TmFunctionVo> tfs) {
        if (CollectionUtil.listNotEmptyNotSizeZero(tfs)) {
            for (TmFunctionVo node : tfs) {
                this.recursiveSub(nodeList, node);
                if (!StringUtil.isEmpty((String)node.getParentId())) continue;
                nodeList.add(node);
            }
        }
    }

    private void recursiveSub(List<TmFunctionVo> nodeList, TmFunctionVo handleFunction) {
        boolean mark = false;
        for (TmFunctionVo tmFunctionVo : nodeList) {
            if (!StringUtil.isNotEmpty((String)handleFunction.getParentId()) || !handleFunction.getParentId().equals(tmFunctionVo.getId())) continue;
            if (CollectionUtil.listEmpty((List)tmFunctionVo.getFunctionVos())) {
                tmFunctionVo.setFunctionVos(new ArrayList());
            }
            tmFunctionVo.getFunctionVos().add(handleFunction);
            mark = true;
            break;
        }
        for (TmFunctionVo tmFunctionVo : nodeList) {
            if (mark || !StringUtil.isNotEmpty((String)handleFunction.getParentId()) || !CollectionUtil.listNotEmptyNotSizeZero((List)tmFunctionVo.getFunctionVos())) continue;
            this.recursiveSub(tmFunctionVo.getFunctionVos(), handleFunction);
        }
    }

    public boolean getFunctionsByRequest(HttpServletRequest request, TmUserEntity tmUserEntity) {
        boolean isPermission = true;
        String reqUrl = ResourceUtil.getRequestPath((HttpServletRequest)request);
        reqUrl = "'" + reqUrl + "%'";
        String isExistSql = "SELECT COUNT(1) FROM TM_FUNCTION WHERE FUNCTION_URL LIKE " + reqUrl;
        long isExistCount = this.getCountForJdbcParam(isExistSql, new Object[0]);
        if (isExistCount > 0L) {
            String isPermissionSql = "SELECT COUNT(1) FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID JOIN TM_R_USER_POSITION TUP ON TUP.POSITION_ID=TRPR.POSITION_ID JOIN TM_USER TU ON TUP.USER_ID=TU.ID WHERE TF.FUNCTION_URL LIKE " + reqUrl + " AND TU.ID=?";
            long isPermissionCount = this.getCountForJdbcParam(isPermissionSql, new Object[]{tmUserEntity.getId()});
            if (isPermissionCount == 0L) {
                isPermission = false;
            }
        }
        return isPermission;
    }

    public List<TmRoleFunctionVo> getOperationsByRequest(HttpServletRequest request, TmUserEntity tmUserEntity) {
        String reqUrl = ResourceUtil.getRequestPath((HttpServletRequest)request);
        String sql = "SELECT TRF.FUNCTION_ID functionId,TRF.ROLE_ID roleId, trf.operation FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID JOIN TM_R_USER_POSITION TUP ON TUP.POSITION_ID=TRPR.POSITION_ID AND tup.is_main = 0 JOIN TM_USER TU ON TUP.USER_ID=TU.ID WHERE TF.FUNCTION_URL LIKE '" + reqUrl + "%' AND TU.ID=? GROUP BY TRF.FUNCTION_ID,TRF.ROLE_ID,trf.operation";
        List tmRoleFunctions = super.findBySql(TmRoleFunctionVo.class, sql, new Object[]{tmUserEntity.getId()});
        if (tmRoleFunctions != null && tmRoleFunctions.size() > 0) {
            StringBuffer operateIdBuffer = new StringBuffer();
            TmRoleFunctionVo roleFunctionVo = (TmRoleFunctionVo)tmRoleFunctions.get(0);
            String operateIds = "";
            for (String[] tmRoleFunctionVo : tmRoleFunctions) {
                if (StringUtil.isNotEmpty((String)operateIds)) {
                    operateIds = operateIds + ",";
                }
                operateIds = operateIds + tmRoleFunctionVo.getOperation();
            }
            if (StringUtils.isNotEmpty((String)operateIds)) {
                String[] operates;
                for (String operatId : operates = operateIds.split(",")) {
                    if (operateIdBuffer.length() > 0) {
                        operateIdBuffer.append(",");
                    }
                    operateIdBuffer.append("'").append(operatId).append("'");
                }
            } else {
                operateIdBuffer.append("'-1'");
            }
            String hql = "FROM TmOperationEntity WHERE id IN (" + operateIdBuffer + ")";
            List list = super.findByHql(hql, new Object[0]);
            request.setAttribute(Globals.Yes_Operation_Codes, (Object)list);
            hql = "FROM TmOperationEntity WHERE tmFunction.id=? AND id NOT IN (" + operateIdBuffer + ")";
            List noPerlist = super.findByHql(hql, new Object[]{roleFunctionVo.getFunctionId()});
            request.setAttribute(Globals.No_Operation_Codes, (Object)noPerlist);
        }
        return tmRoleFunctions;
    }

    public void getDataRuleByRequest(HttpServletRequest request, List<TmRoleFunctionVo> roleFunctionVos) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(roleFunctionVos)) {
            String sql = "SELECT TRRFA.* FROM TM_R_ROLE_FUNC_AUTHOBJ TRRFA JOIN TM_R_ROLE_FUNCTION TRRF ON TRRF.ID=TRRFA.ROLE_FUNCTION_ID WHERE TRRF.FUNCTION_ID=? AND TRRF.ROLE_ID=?";
            TmRoleFunctionVo roleFunctionVo = roleFunctionVos.get(0);
            List list = this.findBySql(TmRoleFuncAuthobjEntity.class, sql, new Object[]{roleFunctionVo.getFunctionId(), roleFunctionVo.getRoleId()});
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                for (TmRoleFuncAuthobjEntity roleFuncAuthobjEntity : list) {
                    if (returnMap.containsKey(roleFuncAuthobjEntity.getAuthobj())) {
                        String authObjValue = (String)returnMap.get(roleFuncAuthobjEntity.getAuthobj());
                        if (StringUtil.isNotEmpty((String)authObjValue)) {
                            authObjValue = authObjValue + "," + roleFuncAuthobjEntity.getAuthobjValue();
                        }
                        returnMap.put(roleFuncAuthobjEntity.getAuthobj(), authObjValue);
                        continue;
                    }
                    returnMap.put(roleFuncAuthobjEntity.getAuthobj(), roleFuncAuthobjEntity.getAuthobjValue());
                }
            }
            String functionId = roleFunctionVo.getFunctionId();
            if (roleFunctionVo != null && StringUtil.isNotEmpty((String)functionId)) {
                Object fucntionName;
                Client client = ResourceUtil.getClient();
                List authObjList = client.getAuthObjList() == null ? new ArrayList() : client.getAuthObjList();
                TmFunctionEntity functionEntity = (TmFunctionEntity)this.get(TmFunctionEntity.class, (Serializable)((Object)functionId));
                if (functionEntity != null && StringUtil.isNotEmpty((String)(fucntionName = functionEntity.getFunctionName())) && (StringUtil.equals((String)fucntionName, (String)"\u5ba2\u6237\u7ba1\u7406") || StringUtil.equals((String)fucntionName, (String)"\u7ec8\u7aef\u7ba1\u7406"))) {
                    Map map = (Map)(client.getObj() == null ? new HashMap() : client.getObj());
                    map.put(functionId, fucntionName);
                    client.setObj((Object)map);
                }
                if (authObjList != null && authObjList.size() > 0) {
                    for (Map map : authObjList) {
                        map.put(functionId, returnMap);
                    }
                } else {
                    HashMap<String, HashMap<String, String>> authMap = new HashMap<String, HashMap<String, String>>();
                    authMap.put(functionId, returnMap);
                    authObjList.add(authMap);
                    client.setAuthObjList(authObjList);
                    ResourceUtil.setClient((Client)client);
                }
            }
        }
    }
}

