/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.productInfo.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.productInfo.dao.TmProductInfoDao;
import com.biz.eisp.mdm.productInfo.entity.TmProductInfoEntity;
import com.biz.eisp.mdm.productInfo.service.TmProductExtendService;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoFindProductInfoMainGridExtend;
import com.biz.eisp.mdm.productInfo.service.TmProductInfoService;
import com.biz.eisp.mdm.productInfo.transformer.TmProductInfoEntityToTmProductInfoVo;
import com.biz.eisp.mdm.productInfo.transformer.TmProductInfoVoToTmProductInfoEntity;
import com.biz.eisp.mdm.productInfo.vo.TmProductInfoVo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmProductInfoService")
@Transactional
public class TmProductInfoServiceImpl
extends BaseServiceImpl
implements TmProductInfoService {
    @Autowired
    private TmProductInfoDao tmProductInfoDao;
    @Autowired(required=false)
    private TmProductInfoFindProductInfoMainGridExtend tmProductInfoFindProductInfoMainGridExtend;
    @Autowired(required=false)
    private TmProductExtendService tmProductExtendService;

    public String saveOrUpdateProductInfo(TmProductInfoVo tmProductInfoVo) {
        UserRedis userRedis = UserUtils.getUser();
        Date date = new Date();
        TmProductInfoEntity tmProductInfoEntity = null;
        TmProductInfoVoToTmProductInfoEntity transForm = new TmProductInfoVoToTmProductInfoEntity((TmProductInfoService)this);
        tmProductInfoEntity = transForm.apply(tmProductInfoVo);
        if (StringUtil.isEmpty((String)tmProductInfoEntity.getId())) {
            tmProductInfoEntity.setCreateBy(userRedis.getUsername());
            tmProductInfoEntity.setCreateName(userRedis.getRealname());
            tmProductInfoEntity.setCreateDate(date);
        }
        tmProductInfoEntity.setUpdateBy(userRedis.getUsername());
        tmProductInfoEntity.setUpdateName(userRedis.getRealname());
        tmProductInfoEntity.setUpdateDate(date);
        if (StringUtil.isNotEmpty((Object)this.tmProductExtendService)) {
            this.tmProductExtendService.saveBefor(tmProductInfoVo);
        }
        this.saveOrUpdate((Object)tmProductInfoEntity);
        if (StringUtil.isNotEmpty((Object)this.tmProductExtendService)) {
            this.tmProductExtendService.saveAfter(tmProductInfoEntity);
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public TmProductInfoVo getProductInfoById(String id) {
        TmProductInfoEntity ie = (TmProductInfoEntity)this.get(TmProductInfoEntity.class, (Serializable)((Object)id));
        if (ie != null) {
            TmProductInfoEntityToTmProductInfoVo trans = new TmProductInfoEntityToTmProductInfoVo((TmProductInfoService)this);
            return trans.apply(ie);
        }
        return null;
    }

    public List<TmProductInfoVo> findProductInfoMainGrid(TmProductInfoVo tmProductInfoVo, Page page) {
        String sql = "";
        if (this.tmProductInfoFindProductInfoMainGridExtend != null) {
            sql = this.tmProductInfoFindProductInfoMainGridExtend.buildSearchSql(tmProductInfoVo);
        } else {
            sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_PRODUCT_INFO, (Object)tmProductInfoVo);
            sql = this.appendProductInfoCondition(sql, tmProductInfoVo, Globals.TABLE_PRODUCT_INFO);
        }
        return this.tmProductInfoDao.findTmProductInfoList(tmProductInfoVo, page, sql);
    }

    public String appendProductInfoCondition(String sql, TmProductInfoVo vo, String table) {
        KnlDictDataEntity tagerEntity;
        KnlDictDataEntity knlDictDataEntity;
        String orderSql = "";
        if (StringUtil.isNotBlank((String)vo.getSort()) && StringUtil.isNotBlank((String)vo.getOrder()) && (knlDictDataEntity = DictUtil.getDicData((String)Globals.mdm_table, (String)(table + "_"))) != null && StringUtil.isNotBlank((String)knlDictDataEntity.getDictCode()) && StringUtil.isNotBlank((String)(tagerEntity = DictUtil.getDictByParentIdAndDictCode((String)knlDictDataEntity.getId(), (String)vo.getSort())).getDictValue())) {
            String c = tagerEntity.getDictValue();
            orderSql = " order by " + c + " " + vo.getOrder();
        }
        sql = sql + orderSql;
        return sql;
    }

    public List<TmProductInfoVo> getTmProductInfoList(TmProductInfoVo tmProductInfoVo) {
        return this.tmProductInfoDao.getTmProductInfoList(tmProductInfoVo);
    }

    public AjaxJson delProductInfo(String ids) {
        String[] iconIds;
        AjaxJson j = new AjaxJson();
        for (String id : iconIds = ids.split(",")) {
            TmProductInfoEntity tmProductInfoEntity = (TmProductInfoEntity)this.get(TmProductInfoEntity.class, (Serializable)((Object)id));
            if (tmProductInfoEntity == null) {
                j.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                j.setSuccess(false);
                return j;
            }
            this.delete((Object)tmProductInfoEntity);
            if (!StringUtil.isNotEmpty((Object)this.tmProductExtendService)) continue;
            this.tmProductExtendService.delAfter(tmProductInfoEntity);
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }

    public AjaxJson startOrStop(TmProductInfoVo tmProductInfoVo) {
        AjaxJson j = new AjaxJson();
        TmProductInfoEntity tmProductInfoEntity = (TmProductInfoEntity)this.get(TmProductInfoEntity.class, (Serializable)((Object)tmProductInfoVo.getId()));
        if (StringUtil.isNotEmpty((Object)tmProductInfoEntity)) {
            if (tmProductInfoEntity.getEnableStatus().toString().equals(tmProductInfoVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmProductInfoVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmProductInfoEntity.setEnableStatus(tmProductInfoVo.getEnableStatus());
                this.updateEntity((Object)tmProductInfoEntity);
            }
            if (StringUtil.isNotEmpty((Object)this.tmProductExtendService)) {
                this.tmProductExtendService.startOrStopAfter(tmProductInfoVo);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

