<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>客户用户信息</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true" action="tmCustUserController.do?saveTmUser"
             beforeSubmit="setRole();">

    <div class="form">
        <label class="Validform_label">用户类型:</label>
        <select id="userType" name="userType">
            <c:forEach items="${userTypeList}" var="item">
                <c:if test="${item.dictCode == 1 || item.dictCode == 3}">
                    <option value="${item.dictCode}"
                            <c:if test="${item.dictCode == vo.userType}">selected</c:if> >${item.dictValue}</option>
                </c:if>
            </c:forEach>
        </select>
    </div>

    <!--动态表单加载 -->
    <t:formmdm extendTableName="${extendTableName}" optype="${optype}"
               objName="vo"></t:formmdm>

    <input name="custId" id="custId" type="hidden" value="${vo.custId }">
    <input name="custJson" id="custJson" type="hidden">
    <input name="roleIds" id="roleIds" type="hidden" value="${vo.roleIds }">
    <input name="roleJson" id="roleJson" type="hidden">

</t:formvalid>
<c:if test="${not empty includeJsp}">
    <jsp:include page="${includeJsp }" flush="true"/>
</c:if>
<script type="text/javascript">
    $(function () {
        $("#extChar1").parent().remove();
        var userId = '${vo.id}';
        if (!isEmpty(userId)) {
            $("input[name='password']").attr("autocomplete", 'off');
        } else {
            $("input[name='password']").val('${vo.password}');
        }
        $("input[name='password']")[0].type = "password";
    });

    //客户
    function popCust() {

        var url = "tmTermCustPostController.do?goCustomerMultiSelect&selectedCustIds=${vo.custId}&userId=${vo.id}";
        var userType = $("#userType").val();
        if (userType == "1") {
            var userName = $("#userName").val();
            if (userName == null || userName == "") {
                tip("请先填写登录账号");
                return;
            }
            url += "&customerCode=" + userName;
        }
        // popClickSingle("custList", "custId,custName", "id,customerName", url, 500, 400, true);
        popSelectClick("custJson", "custName", "customerName", url, "custCheckedList", null, 1000, 450);
    }

    $("#userType").change(function () {
        checkCustUserSelect();
    });

    $("#userName").change(function () {
        checkCustUserSelect();
    });

    function checkCustUserSelect() {
        var userType = $("#userType").val();
        if (userType == "1") {
            $("#custName").val("");
            $("#custId").val("");
        }
    }
    //权限角色
    function popRole() {
        popSelectClick("roleJson", "roleNames", "roleName", "tmPositionController.do?goSelectRole&userId=${vo.id}&accessEntry=" + accessEntry, "roleCheckedList", null, 1000, 450);
    }

    //提交前验证
    function setRole() {
        let status = true;

        status = doSetCust();
        if(!status) {
            return status;
        }
        //权限角色
        doSetRole();
        return true;
    }


    function doSetCust() {
        var custJson = $("#custJson").val();
        var custId = $("#custId").val();
        if (custJson != null && custJson != "") {
            custJson = JSON.parse(custJson);
            custId = "";
            $.each(custJson, function (i, v) {
                if (custId != "") {
                    custId += ",";
                }
                custId += v.id;
            });
        }
        $("#custId").val(custId);
        if(!custId || 'null' == custId || 'undefined' == custId){
            tip("请选择关联客户！");
            return false;
        }
        return true;
    }
    function doSetRole() {
        var roleJson = $("#roleJson").val();
        var roleIds = $("#roleIds").val();
        if (roleJson != null && roleJson != "") {
            roleJson = JSON.parse(roleJson);
            roleIds = "";
            $.each(roleJson, function (i, v) {
                if (roleIds != "") {
                    roleIds += ",";
                }
                roleIds += v.id;
            });
        }
        $("#roleIds").val(roleIds);
    }
</script>
</body>
</html>
