<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_custUserList" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="tmCustUserList" fitColumns="true"  actionUrl="tmCustUserController.do?findTmCustUserList"
	  	  extendTableName="${extendTableName}" idField="id" queryMode = "group" onLoadSuccess="displayEc" >
	        <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
	        <%--<t:dgCol title="客户类型" field="userType" columnOrder="4" dictionary="user_type"></t:dgCol>--%>
	        <t:dgCol title="关联客户" field="custName" query="true" columnOrder="4"></t:dgCol>
	        <t:dgCol title="客户编码" field="custCode" columnOrder="4"></t:dgCol>

	        <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmCustUserController.do?goTmCustUserForm&optype=0" funname="addTmUser"></t:dgToolBar>
	        <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmCustUserController.do?goTmCustUserForm&optype=1" funname="updateTmUser"></t:dgToolBar>
     	    <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmUserController.do?deleteTmUser" funname="deleteALLSelect"></t:dgToolBar>
	        <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="tmCustUserController.do?startOrStopTmuser" funname="startOrStopTmuser('009')"></t:dgToolBar>
	        <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmCustUserController.do?startOrStopTmuser" funname="startOrStopTmuser('003')"></t:dgToolBar>
	        <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmCustUser', gridName:'tmCustUserList'})"></t:dgToolBar>
	        <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmCustUserController.do?exportXls" funname="excelExport"></t:dgToolBar>
	        <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmCustUserController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
	        <t:dgToolBar title="微信解绑" operationCode="wxunbind" icon="icon-wx_unbound" url="" funname="untieWx"></t:dgToolBar>
	    </t:datagrid>
	</div>
</div>
<c:if test="${not empty includeJsp}">
	<jsp:include page="${includeJsp }" flush="true"/>
</c:if>
<script type="text/javascript">
    $(document).ready(function(){
        $(".datagrid-htable").find("td[field='extChar1']").attr("style","display: none");
        $(".datagrid-body").find("td[field='extChar1']").attr("style","display: none");
    });
    function displayEc() {
        $(".datagrid-htable").find("td[field='extChar1']").attr("style","display: none");
        $(".datagrid-body").find("td[field='extChar1']").attr("style","display: none");
    }
	//添加
	function addTmUser(title, url, gridname) {
		add(title, url, gridname, 380, 400);
	}
	//编辑
	function updateTmUser(title, url, gridname, width, height) {
		update(title, url, gridname, 380, 400);
	}
	//启用停用
	function startOrStopTmuser(flag){
		var tmUseTarget = $("#tmCustUserList").datagrid('getSelected');
		if(tmUseTarget == null){
			tip("请选择一条要操作的数据");
			return;
		}
		var tipmMsg = "";
		if(flag == '009'){
			tipmMsg = "确定要启用该数据吗?"
		}else{
			tipmMsg = "确定要停用该数据吗?"
		}
		$.messager.confirm('操作提示',tipmMsg,function(r){ 
		    if (r){
		    	$.ajax({
		        	type : "POST",
		        	url : "tmCustUserController.do?startOrStopTmuser",
		        	data : {
		            	"id" : tmUseTarget.id,
		            	"enableStatus": flag
		        	},
		        	dataType : "json",
		        	success : function(data) {
		        		tip(data.msg);
		        		$("#tmCustUserList").datagrid('reload');
		        	},
		        	error:function(){
		        		tip("服务器异常，请稍后再试");
		        	}
			   });
		    }
		});
	}

	//解绑微信
	function untieWx(title, url, grid, width, height) {
		var rows = $("#" + grid).datagrid("getSelections");
		if (rows.length < 1) {
			tip("请先选择数据");
			return;
		}
		if (rows.length > 1) {
			tip("只能选择一行数据");
			return;
		}
		var row = rows[0];

		$.messager.confirm('操作提示', "确定要解绑账号关联的全部微信吗", function (r) {
			if (r) {
				$.ajax({
					type: "POST",
					url: "tmCustUserController.do?untieWx",
					data: {
						userName: row.userName
					},
					success: function (data) {
						var d = data;
						tip(d.msg);
						if (d.success) {
							$("#" + grid).datagrid('reload');
						}
					},
					error: function () {
						tip("服务器异常，请稍后再试");
					}
				});
			}
		});
	}

	function goTip(){
		tip("项目二次开发");
		return;
	}
</script>