<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="product_price_List" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="productPriceList" fitColumns="false" extendTableName="${extendTableName}" idField="id"
                    actionUrl="tmProductPriceController.do?findProductPriceMainGrid" checkbox="true"
                    singleSelect="false" queryMode="group">

<%--            <t:dgCol field="productInfoCode" title="物料编码" query="true" width="100" columnOrder="5"></t:dgCol>--%>
<%--            <t:dgCol field="productInfoName" title="物料名称" query="true" width="100" columnOrder="5"></t:dgCol>--%>
<%--            <t:dgCol field="customerName" title="客户" width="100" columnOrder="8"></t:dgCol>--%>
<%--            <t:dgCol field="terminalName" title="门店" width="100" columnOrder="8"></t:dgCol>--%>
<%--            <t:dgCol field="beginTime" title="有效期开始" formatter="yyyy-MM-dd HH:mm:ss" columnOrder="14"></t:dgCol>--%>
<%--            <t:dgCol field="endTime" title="有效期结束" formatter="yyyy-MM-dd HH:mm:ss" columnOrder="14"></t:dgCol>--%>


            <t:dgToolBar title="新增" operationCode="add" url="tmProductPriceController.do?goSaveOrUpdateForm&optype=0"
                         icon="icon-add" funname="add"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" url="tmProductPriceController.do?goSaveOrUpdateForm&optype=1"
                         icon="icon-edit" funname="update"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look"
                         url="tmProductPriceController.do?goSaveOrUpdateForm&operation=search&optype=1" icon="icon-edit"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importDataByXml({impName:'tmProductPrice', gridName:'productPriceList'})"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="tmProductPriceController.do?exportXls&clickFunctionId=${clickFunctionId}"
                         funname="excelExport"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove"
                         url="tmProductPriceController.do?delProductPrice" funname="deleteALLSelect3"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmCustomerController.do?goTmLogDetailMain"
                         funname="detailLog" width="1200" height="460"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script>

    //删除
    function deleteALLSelect3(title, url) {
        var rowsData = $('#productPriceList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择产品价格');
            return;
        }
        var ids = [];
        if (rowsData.length > 0) {
            $.dialog.confirm('是否删除选中数据？', function (r) {
                if (r) {
                    for (var i = 0; i < rowsData.length; i++) {
                        ids.push(rowsData[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        dataType: "json",
                        success: function (data) {
                            tip(data.msg);
                            if (data.success) {
                                $("#productPriceList").datagrid('reload');
                            }
                        }
                    });
                }
            });
        } else {
            tip("请选择要删除的数据！");
        }
    }
</script>