<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="tools" extendUrlKey="eispHome"></t:base>
<style type="text/css">
    .biz-home {
        width: 100%;
        height: 100%;
        padding: 5%;
        box-sizing: border-box;
        background: #EFF2F5;
    }

    @media screen and (max-width: 1300px) {
        .biz-home {
            padding: 3%;
        }

        .biz-home-title {
            height: 35px;
        }

        .biz-home-table table thead th {
            height: 35px;
            line-height: 35px;
        }

        .biz-home-table table tbody td {
            height: 35px;
            line-height: 35px;
        }
    }

    .biz-home-cards {
        width: 100%;
        height: 100%;
        box-sizing: border-box;
    }

    .biz-home-cards-top {
        height: 36%;
        box-sizing: border-box;
    }

    .biz-home-cards-bottom {
        margin-top: 16px;
        box-sizing: border-box;
        height: 0;
    }

    .biz-home-card {
        background: #FFFFFF;
        box-shadow: 0 0 7px 0 rgba(185, 196, 217, 0.50);
        border-radius: 4px;
        padding: 0 10px 10px;
        height: 100%;
        box-sizing: border-box;
    }

    .biz-home-title {
        height: 40px;
        border-bottom: 1px solid #E9E9E9;
        box-sizing: border-box;
    }

    .biz-home-title-info > img {
        width: 14px;
        height: 14px;
        margin-right: 10px;
    }

    .biz-home-title-info > span {
        font-size: 13px;
        color: #0F467C;
        font-weight: 600;
    }

    .biz-home-card-more {
        font-size: 10px;
        color: #9F9F9F;
        letter-spacing: 0;
    }

    .biz-home-card-more:hover {
        color: #0F467C;
    }

    .card-notice {
        flex: 0 0 42%;
        margin-right: 16px;
        overflow: hidden;
    }

    .card-deal {
        flex: 0 0 33%;
        margin-right: 16px;
        overflow: hidden;
    }

    .card-favorites {
        flex: auto;
    }

    .card-cc {
        flex: 0 0 29%;
        margin-right: 16px;
        overflow: hidden;
    }

    .card-center {
        flex: 0 0 46%;
        margin-right: 16px;
        width: 0;
        height: 100%;
    }

    .card-apply {
        overflow: hidden;
    }

    .card-reject {
        margin-top: 16px;
        overflow: hidden;
    }

    .card-info {
        flex: auto;
    }

    /*table*/
    .biz-home-table {
        overflow-y: auto;
    }

    .biz-home-table table {
        width: 100%;
        table-layout: fixed;
        border-collapse: collapse;
        box-sizing: border-box;
    }

    .biz-home-table table thead th {
        font-size: 14px;
        color: #0F467C;
        text-align: left;
        height: 22px;
        line-height: 22px;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        font-weight: 500;
    }

    .biz-home-table table tbody td {
        font-size: 14px;
        color: #585B5F;
        text-align: left;
        height: 22px;
        line-height: 22px;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .biz-home-table table tbody tr:hover td {
        color: #0F467C;
        font-weight: 600;
        cursor: pointer;
    }

    /*.biz-home-table table tbody tr:hover {*/
    /*background: #fbf2b3;*/
    /*}*/

    .biz-home-table table tbody tr .can-link {
        /*color: #0F467C;*/
        /*font-weight: 600;*/
        cursor: pointer;
    }

    /*.biz-home-table table tbody td .can-link:hover {*/
    /*text-decoration: underline;*/
    /*}*/

    .biz-home-favorites {
        width: 100%;
        height: 0;
        overflow-x: auto;
    }

    .biz-home-favorites-menu {
        width: 50%;
        height: 50%;
    }

    .biz-home-favorites-menu > img {
        width: 32px;
        height: 32px;
    }

    .biz-home-favorites-menu > p {
        font-size: 14px;
        color: #333333;
        padding: 0;
        margin: 0;
        margin-top: 5px;
    }

    .biz-home-favorites-menu:hover > p {
        color: #0F467C;
        font-weight: 600;
        cursor: pointer;
    }

    .biz-home-info-title {
        font-size: 18px;
        color: #0F467C;
        margin-bottom: 0;
    }

    .biz-home-info-des {
        font-size: 12px;
        color: #666666;
        line-height: 20px;
        width: 80%;
    }

    .biz-home-info-des > a {
        font-size: 12px;
        color: #0F467C;
        cursor: pointer;
    }

    .biz-home-info-img {
        height: 0;
        overflow: hidden;
    }

    .biz-home-info-img > img {
        width: 100%;
        height: 100%;
    }
</style>
<div class="biz-home">
    <div class="biz-home-cards flex flex-column">
        <div class="biz-home-cards-top flex-none flex flex-align-items-center">
            <div class="biz-home-card card-notice flex flex-column">
                <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                    <div class="biz-home-title-info flex flex-align-items-center">
                        <img src="/resources/home/notice.png" alt="消息公告">
                        <span>消息公告</span>
                    </div>
                    <div>
                        <a class="biz-home-card-more" href="javascript:void(0)"
                           onclick="addTab('消息公告','/page/knlNoticeController/goKnlNoticeMain?1=1','menu-sys_manage.png')">MORE</a>
                    </div>
                </div>
                <div class="biz-home-table flex-auto height0" id="noticeTable">

                </div>
            </div>
            <div class="biz-home-card card-deal flex flex-column">
                <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                    <div class="biz-home-title-info flex flex-align-items-center">
                        <img src="/resources/home/deal.png" alt="待处理">
                        <span>待处理</span>
                    </div>
                    <div>
                        <a class="biz-home-card-more" href="javascript:void(0)"
                           onclick="addTab('待处理','/page/taTaskController/goMyTaskMain?1=1','menu-sys_manage.png')">MORE</a>
                    </div>
                </div>
                <div class="biz-home-table flex-auto height0" id="dealTable">

                </div>
            </div>
            <div class="biz-home-card card-favorites flex flex-column">
                <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                    <div class="biz-home-title-info flex flex-align-items-center">
                        <img src="/resources/home/favorites.png" alt="我的收藏">
                        <span>我的收藏</span>
                    </div>
                    <div>
                        <%--<a class="biz-home-card-more" href="#">MORE</a>--%>
                    </div>
                </div>
                <div class="biz-home-favorites flex-auto flex flex-wrap">

                </div>
            </div>
        </div>
        <div class="biz-home-cards-bottom flex-auto flex flex-align-items-center">
            <div class="biz-home-card card-cc flex flex-column">
                <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                    <div class="biz-home-title-info flex flex-align-items-center">
                        <img src="/resources/home/cc.png" alt="抄送和传阅">
                        <span>抄送和传阅</span>
                    </div>
                    <div>
                        <a class="biz-home-card-more" href="javascript:void(0)"
                           onclick="addTab('抄送和传阅','/page/taCarbonCopyController/goCarbonCopyMain?1=1','menu-sys_manage.png')">MORE</a>
                    </div>
                </div>
                <div class="biz-home-table flex-auto height0" id="ccTable">

                </div>
            </div>
            <div class="card-center flex flex-column">
                <div class="biz-home-card flex-1 card-apply flex flex-column">
                    <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                        <div class="biz-home-title-info flex flex-align-items-center">
                            <img src="/resources/home/apply.png" alt="我的申请">
                            <span>我的申请</span>
                        </div>
                        <div>
                            <a class="biz-home-card-more" href="javascript:void(0)"
                               onclick="addTab('我的申请','/page/taProcessInstanceController/goMyStartedProcessMain?1=1','menu-sys_manage.png')">MORE</a>
                        </div>
                    </div>
                    <div class="biz-home-table flex-auto height0" id="applyTable">

                    </div>
                </div>
                <div class="biz-home-card flex-1 card-reject flex flex-column">
                    <div class="biz-home-title flex-none flex flex-align-items-center flex-justify-content-between">
                        <div class="biz-home-title-info flex flex-align-items-center">
                            <img src="/resources/home/reject.png" alt="被驳回">
                            <span>被驳回</span>
                        </div>
                        <div>
                            <a class="biz-home-card-more" href="javascript:void(0)"
                               onclick="addTab('被驳回','/page/taProcessInstanceController/goMyStartedProcessMain?1=1','menu-sys_manage.png')">MORE</a>
                        </div>
                    </div>
                    <div class="biz-home-table flex-auto height0" id="rejectTable">

                    </div>
                </div>
            </div>
            <div class="biz-home-card card-info flex flex-column">
                <div class="biz-home-info-top flex-none">
                    <p class="biz-home-info-title">博智营销中台</p>
                    <p class="biz-home-info-des">
                        帮助企业降低运营成本，提高工作效率，优化营销体系，详情请点击<a href="http://www.biz-united.com.cn/biz-official/src/index.html"
                                                         target="_blank" class="ml5">联系我们</a>
                    </p>
                </div>
                <div class="biz-home-info-img flex-auto">
                    <img src="/resources/home/biz_info.png" alt="博智营销中台">
                </div>
            </div>
        </div>
    </div>
</div>
<script>

    var noticeData = {
        head: [{
            title: "类型",
            field: "noticeTypeStr",
            width: "3em"
        }, {
            title: "日期",
            field: "updateDate",
            width: "3em"
        }, {
            title: "标题",
            field: "noticeTitle"
        }],
        body: []
    };
    var dealData = {
        head: [{
            title: "流程编号",
            field: "processInstanceId",
            width: "5em"
        }, {
            title: "发起人",
            field: "createUserName",
            width: "4em"
        }, {
            title: "标题",
            field: "processTitle"
        }],
        body: []
    };
    var ccData = {
        head: [{
            title: "流程编号",
            field: "processInstanceId",
            width: "5em"
        }, {
            title: "抄送/传阅人",
            field: "createName",
            width: "4em"
        }, {
            title: "标题",
            field: "processTitle"
        }],
        body: []
    };
    var applyData = {
        head: [
            {
                title: "流程编号",
                field: "processInstanceId",
                width: "5em"
            },
            {
                title: "状态 ",
                field: "runtimeStatus",
                width: "3em"
            }, {
                title: "标题",
                field: "processTitle"
            }],
        body: []
    };
    var rejectData = {

        head: [
            {
                title: "流程编号",
                field: "processInstanceId",
                width: "5em"
            },
            {
                title: "驳回人",
                field: "createUserName",
                width: "4em"
            }, {
                title: "标题",
                field: "processTitle"
            }, {
                title: "日期",
                field: "createTime",
                width: "3em"
            }
        ],
        body: []
    };
    $(function () {
        loadFavorites();
        initAllTable();
        //注册流程编号事件
        $(".biz-home-table").on('click', '.can-link', function () {
            var table = $(this).attr("table");
            if (table === "dealTable") {
                var id = $(this).attr("id");
                var isCommunicate = $(this).attr("isCommunicate");
                var taskId = $(this).attr("taskId");
                var processInstanceId = $(this).attr("processInstanceId");
                var isReadFlag = $(this).attr("isReadFlag");
                var isView = $(this).attr("isView");
                var url = "/page/taTaskController/goInstanceHandleTabForm?isReadFlag=" + isReadFlag + "&isView=" + isView + "&id=" + id + "&isCommunicate=" + isCommunicate + "&taskId=" + taskId + "&processInstanceId=" + processInstanceId;
                openwindow("处理", url, "", 1200, 500);
            }
            if (table === "ccTable") {
                var id = $(this).attr("id");
                var contentId = $(this).attr("contentId");
                var taskId = $(this).attr("taskId");
                var type = $(this).attr("type");
                var inOutType = $(this).attr("inOutType");
                var processInstanceId = $(this).attr("processInstanceId");
                var url = "/page/taCarbonCopyController/goCopyAndCirculationTabs?contentId=" + contentId + "&type=" + type + "&id=" + id + "&inOutType=" + inOutType + "&taskId=" + taskId + "&processInstanceId=" + processInstanceId;

                var title = "处理";
                var name = "";
                var width = 1200;
                var height = 500;
                gridname = name;
                width = width || 'auto';
                height = height || 'auto';
                safeShowDialog({
                    content: 'url:' + url,
                    title: title,
                    cache: false,
                    lock: true,
                    width: width,
                    height: height,
                    close: function () {
                        $.post("/activiti/taCarbonCopyController/updateCarbonOrCirculationState",
                            {
                                "type": type,
                                "contentId": contentId,
                                "inOutType": inOutType
                            },
                            function (data) {

                            }, "json");
                    }
                });
            }
            if (table === "applyTable" || table === "rejectTable") {
                var processInstanceId = $(this).attr("processInstanceId");
                var isReadFlag = $(this).attr("isReadFlag");
                var isView = $(this).attr("isView");
                var id = $(this).attr("id");
                var url = "/page/taTaskController/goInstanceHandleTabForm?isReadFlag=" + isReadFlag + "&isView=" + isView + "&processInstanceId=" + processInstanceId;
                var title = "处理";
                var name = "";
                var width = 1200;
                var height = 500;
                gridname = name;
                width = width || 'auto';
                height = height || 'auto';
                safeShowDialog({
                    content: 'url:' + url,
                    title: title,
                    cache: false,
                    lock: true,
                    width: width,
                    height: height,
                    close: function () {
                        $.post("/activiti/taProcessInstanceController/updateViewStatus",
                            {
                                "id": id
                            },
                            function (data) {

                            }, "json");
                    }
                });
            }
            if (table === "noticeTable") {
                var id = $(this).attr("id");
                safeShowDialog({
                    content: 'url:' + '/page/knlNoticeController/goSaveOrUpdateNotice?load=detail&id=' + id,
                    title: "公告详情",
                    cache: false,
                    lock: true,
                    width: 1000,
                    height: 500,
                    close: function () {

                    }
                });

            }
        });

        $(".biz-home-favorites").on('click', '.biz-home-favorites-menu', function () {
            var name = $(this).attr("name");
            var url = $(this).attr("url");
            addTab(name, url, 'menu-sys_manage.png');
        })
    });


    function loadFavorites() {
        $.ajax({
            url: "tmUserCollectController.do?getTmUserCollectList",
            type: "post",
            dataType: "json",
            success: function (res) {
                if (res) {
                    var html = "";
                    $.each(res, function (index,item) {
                        html += '<div name="' + item.functionName + '" url="' + item.functionUrl+'&clickFunctionId='+item.functionId + '" class="biz-home-favorites-menu flex flex-column flex-align-items-center flex-justify-content-center">';
                        html += '<img src="' + item.iconPath + '" alt="' + item.functionName + '">';
                        html += '<p>' + item.functionName + '</p>';
                        html += '</div>';
                    });
                    $(".biz-home-favorites").html(html);
                }
            },
            error: function (error) {

            }
        })
    }

    function initAllTable() {
        loadData("/kernel/kernel-api/knlApiNoticeController/getKnlNoticeList", noticeData, "noticeTable");
        loadData("/activiti/taTaskController/findMyTaskList?page=1&rows=5", dealData, "dealTable");
        loadData("/activiti/taCarbonCopyController/findHomeCarbonCopyList?1=1&page=1&rows=8&viewStatus=0", ccData, "ccTable");
        loadData("/activiti/taProcessInstanceController/findMyStartedProcessList?1=1&page=1&rows=5", applyData, "applyTable");
        loadData("/activiti/taTaskController/findMyRejectTaskList?1=1&page=1&rows=5&viewStatus=0", rejectData, "rejectTable");
    }

    //渲染表格
    function renderTable(tableId, tableData) {
        if (!tableData) {
            return false;
        } else {
            var head = tableData.head;
            var body = tableData.body;
            var _table = $("<table>");
            var _tbody = $("<tbody>");
            var htmlHeader = renderThead(head);
            $.each(body, function (index, item) {
                var _tr = $("<tr>");
                _tr.attr("class", "can-link");
                $.each(head, function (i, h) {
                    var _td = $("<td>");
                    if (tableId === "noticeTable") {
                        _tr.attr("id", item.id);
                        _tr.attr("table", tableId);
                    }
                    if (h.field === "processInstanceId") {
                        var _span = $("<span>");
                        // _span.attr("class", "can-link");
                        _tr.attr("table", tableId);
                        //处理
                        if (tableId === "dealTable") {
                            _tr.attr("id", item.id);
                            _tr.attr("isCommunicate", item.isCommunicate);
                            _tr.attr("taskId", item.taskId);
                            _tr.attr("processInstanceId", item.processInstanceId);
                            _tr.attr("isReadFlag", "false");
                            _tr.attr("isView", "false")
                        }
                        //抄送/传阅
                        if (tableId === "ccTable") {
                            _tr.attr("id", item.id);
                            _tr.attr("contentId", item.contentId);
                            _tr.attr("type", item.type);
                            _tr.attr("inOutType", item.inOutType);
                            _tr.attr("processInstanceId", item.processInstanceId);
                        }
                        //申请or拒绝
                        if (tableId === "applyTable" || tableId === "rejectTable") {
                            _tr.attr("processInstanceId", item.processInstanceId);
                            _tr.attr("isView", "true");
                            _tr.attr("isReadFlag", "false");
                            _tr.attr("id", item.id);
                        }
                        _span.text(item[h.field]);
                        _td.html(_span.prop("outerHTML"))
                    } else if (h.field === "updateDate" || h.field === "createTime") {
                        _td.text(formateMonth(item[h.field]));
                    } else if (h.field === "runtimeStatus") {
                        _td.text(changeRunTimeStatus(item[h.field]));
                    } else {
                        _td.text(item[h.field]);
                    }
                    _tr.append(_td.prop("outerHTML"));
                });
                _tbody.append(_tr.prop("outerHTML"));
            });
            if (body.length > 0) {
                _table.append(htmlHeader);
            }
            _table.append(_tbody.prop("outerHTML"));
            $("#" + tableId).html(_table.prop("outerHTML"));
        }
    }

    //渲染表格头
    function renderThead(head) {
        var _thead = $("<thead>");
        var _tr = $("<tr>");
        $.each(head, function (index, item) {
            var _th = $("<th>");
            _th.text(item.title);
            _th.attr("width", item.width);
            _th.css('width', item.width);
            _th.attr("field", item.field);
            _tr.append(_th.prop("outerHTML"));
        });
        _thead.append(_tr.prop("outerHTML"));
        return _thead.prop("outerHTML");
    }

    //加载数据
    function loadData(url, data, table) {
        $.ajax({
            url: url,
            contentType: "application/json",
            data: JSON.stringify({}),
            type: "post",
            dataType: "json",
            success: function (res) {
                if (res.success) {
                    if (res.objList) {
                        data.body = res.objList || [];
                    } else {
                        data.body = res.rows || [];
                    }
                    renderTable(table, data);
                }
            }, error: function (error) {

            }
        })
    }

    //格式化时间
    function formateMonth(date) {
        if (!date) return;
        date = date.replace(/-/g,"/");
        date = new Date(date);
        var month = date.getMonth() + 1;
        var day = date.getDate();
        month = month + '';
        month = month[1] ? month : '0' + month;
        day = day + '';
        day = day[1] ? day : '0' + day;
        return [month, day].join("-");
    }

    function changeRunTimeStatus(date) {
        if (!date) return;
        var status = "";
        switch (date) {
            case "completed" :
                status = "完成";
                break;
            case "doing" :
                status = "处理中";
                break;
            case "reject" :
                status = "驳回";
                break;

        }
        return status;

    }

</script>
